/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBMultiOverlappedChunkInUnseqIT {
    private static long beforeMemtableSizeThreshold;

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.NO_COMPACTION);
        beforeMemtableSizeThreshold = IoTDBDescriptor.getInstance().getConfig().getMemtableSizeThreshold();
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold(1024L);
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        IoTDBMultiOverlappedChunkInUnseqIT.insertData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold(beforeMemtableSizeThreshold);
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
    }

    @Test
    public void selectOverlappedPageTest() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String sql = "select count(s0) from root.vehicle.d0 where time < 1000000";
            try (ResultSet resultSet = statement.executeQuery(sql);){
                while (resultSet.next()) {
                    String ans = resultSet.getString(TestConstant.count("root.vehicle.d0.s0"));
                    Assert.assertEquals((Object)"1000", (Object)ans);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static void insertData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            long time;
            statement.execute("CREATE TIMESERIES root.vehicle.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE");
            String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", 1000000, 1000000);
            statement.execute(sql);
            statement.execute("flush");
            for (time = 1L; time <= 1000L; ++time) {
                sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time);
                statement.execute(sql);
            }
            for (time = 2L; time <= 1000L; ++time) {
                sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, 1000);
                statement.execute(sql);
            }
            statement.execute("flush");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

