/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBMultiDeviceIT {
    private static TSFileConfig tsFileConfig = TSFileDescriptor.getInstance().getConfig();
    private static int maxNumberOfPointsInPage;
    private static int pageSizeInByte;
    private static int groupSizeInByte;
    private static long prevPartitionInterval;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.NO_COMPACTION);
        maxNumberOfPointsInPage = tsFileConfig.getMaxNumberOfPointsInPage();
        pageSizeInByte = tsFileConfig.getPageSizeInByte();
        groupSizeInByte = tsFileConfig.getGroupSizeInByte();
        tsFileConfig.setMaxNumberOfPointsInPage(1000);
        tsFileConfig.setPageSizeInByte(153600);
        tsFileConfig.setGroupSizeInByte(1024000);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold(1024000L);
        prevPartitionInterval = IoTDBDescriptor.getInstance().getConfig().getPartitionInterval();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(100L);
        TSFileDescriptor.getInstance().getConfig().setCompressor("LZ4");
        EnvironmentUtils.envSetUp();
        IoTDBMultiDeviceIT.insertData();
    }

    @After
    public void tearDown() throws Exception {
        tsFileConfig.setMaxNumberOfPointsInPage(maxNumberOfPointsInPage);
        tsFileConfig.setPageSizeInByte(pageSizeInByte);
        tsFileConfig.setGroupSizeInByte(groupSizeInByte);
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(prevPartitionInterval);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold((long)groupSizeInByte);
        TSFileDescriptor.getInstance().getConfig().setCompressor("SNAPPY");
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
    }

    private static void insertData() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int time;
            for (String sql : TestConstant.create_sql) {
                statement.execute(sql);
            }
            statement.execute("SET STORAGE GROUP TO root.fans");
            statement.execute("CREATE TIMESERIES root.fans.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE");
            statement.execute("CREATE TIMESERIES root.fans.d1.s0 WITH DATATYPE=INT32, ENCODING=RLE");
            statement.execute("CREATE TIMESERIES root.fans.d2.s0 WITH DATATYPE=INT32, ENCODING=RLE");
            statement.execute("CREATE TIMESERIES root.fans.d3.s0 WITH DATATYPE=INT32, ENCODING=RLE");
            statement.execute("CREATE TIMESERIES root.car.d0.s1 WITH DATATYPE=INT64, ENCODING=RLE");
            statement.execute("CREATE TIMESERIES root.car.d1.s1 WITH DATATYPE=INT64, ENCODING=RLE");
            statement.execute("CREATE TIMESERIES root.car.d2.s1 WITH DATATYPE=INT64, ENCODING=RLE");
            for (time = 0; time < 1000; ++time) {
                String sql = String.format("insert into root.fans.d0(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d1(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d2(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d3(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.car.d0(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.car.d1(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.car.d2(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
            }
            for (time = 13700; time < 24000; ++time) {
                String sql = String.format("insert into root.fans.d0(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d1(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d2(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d3(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.car.d0(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.car.d1(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.car.d2(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
            }
            for (time = 3000; time < 13600; ++time) {
                String sql = String.format("insert into root.fans.d0(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d1(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d2(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d3(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.car.d0(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.car.d1(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.car.d2(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
            }
            statement.execute("flush");
            statement.execute("merge");
            for (time = 10000; time < 11000; ++time) {
                String sql = String.format("insert into root.fans.d0(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d1(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d2(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d3(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.car.d0(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.car.d1(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.car.d2(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
            }
            for (time = 200000; time < 201000; ++time) {
                String sql = String.format("insert into root.fans.d0(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d1(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d2(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d3(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.car.d0(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.car.d1(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.car.d2(timestamp,s0) values(%s,%s)", time, time % 40);
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectAllTest() throws ClassNotFoundException {
        String selectSql = "select * from root";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute(selectSql);
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                long before = -1L;
                while (resultSet.next()) {
                    long cur = Long.parseLong(resultSet.getString("Time"));
                    if (cur <= before) {
                        Assert.fail((String)"time order wrong!");
                    }
                    before = cur;
                    ++cnt;
                }
                Assert.assertEquals((long)22900L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectAfterDeleteTest() throws ClassNotFoundException {
        String selectSql = "select * from root";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("DELETE FROM root.fans.* WHERE time <= 1000");
            statement.execute("DELETE FROM root.car.* WHERE time <= 1000");
            statement.execute("DELETE FROM root.fans.* WHERE time >= 200500 and time < 201000");
            statement.execute("DELETE FROM root.car.* WHERE time >= 200500 and time < 201000");
            boolean hasResultSet = statement.execute(selectSql);
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                long before = -1L;
                while (resultSet.next()) {
                    long cur = Long.parseLong(resultSet.getString("Time"));
                    if (cur <= before) {
                        Assert.fail((String)"time order wrong!");
                    }
                    before = cur;
                    ++cnt;
                }
                Assert.assertEquals((long)21400L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

