/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBMetadataFetchIT {
    private DatabaseMetaData databaseMetaData;
    private static final Logger logger = LoggerFactory.getLogger(IoTDBMetadataFetchIT.class);

    private static void insertSQL() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] insertSqls;
            for (String sql : insertSqls = new String[]{"SET STORAGE GROUP TO root.ln.wf01.wt01", "SET STORAGE GROUP TO root.ln1.wf01.wt01", "SET STORAGE GROUP TO root.ln2.wf01.wt01", "CREATE TIMESERIES root.ln.wf01.wt01.status WITH DATATYPE = BOOLEAN, ENCODING = PLAIN", "CREATE TIMESERIES root.ln.wf01.wt01.status.s1 WITH DATATYPE = BOOLEAN, ENCODING = PLAIN", "CREATE TIMESERIES root.ln.wf01.wt01.temperature WITH DATATYPE = FLOAT, ENCODING = RLE, compressor = SNAPPY, MAX_POINT_NUMBER = 3"}) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            logger.error("insertSQL() failed", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        IoTDBMetadataFetchIT.insertSQL();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void showTimeseriesTest() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] sqls = new String[]{"show timeseries root.ln.wf01.wt01.status", "show timeseries root.ln", "show timeseries root.ln.*.wt01", "show timeseries", "show timeseries root.a.b"};
            Set[] standards = new Set[]{new HashSet<String>(Arrays.asList("root.ln.wf01.wt01.status,null,root.ln.wf01.wt01,BOOLEAN,PLAIN,SNAPPY,null,null,", "root.ln.wf01.wt01.status.s1,null,root.ln.wf01.wt01,BOOLEAN,PLAIN,SNAPPY,null,null,")), new HashSet<String>(Arrays.asList("root.ln.wf01.wt01.status,null,root.ln.wf01.wt01,BOOLEAN,PLAIN,SNAPPY,null,null,", "root.ln.wf01.wt01.status.s1,null,root.ln.wf01.wt01,BOOLEAN,PLAIN,SNAPPY,null,null,", "root.ln.wf01.wt01.temperature,null,root.ln.wf01.wt01,FLOAT,RLE,SNAPPY,null,null,")), new HashSet<String>(Arrays.asList("root.ln.wf01.wt01.status,null,root.ln.wf01.wt01,BOOLEAN,PLAIN,SNAPPY,null,null,", "root.ln.wf01.wt01.status.s1,null,root.ln.wf01.wt01,BOOLEAN,PLAIN,SNAPPY,null,null,", "root.ln.wf01.wt01.temperature,null,root.ln.wf01.wt01,FLOAT,RLE,SNAPPY,null,null,")), new HashSet<String>(Arrays.asList("root.ln.wf01.wt01.status,null,root.ln.wf01.wt01,BOOLEAN,PLAIN,SNAPPY,null,null,", "root.ln.wf01.wt01.status.s1,null,root.ln.wf01.wt01,BOOLEAN,PLAIN,SNAPPY,null,null,", "root.ln.wf01.wt01.temperature,null,root.ln.wf01.wt01,FLOAT,RLE,SNAPPY,null,null,")), new HashSet<String>(Collections.singletonList(""))};
            for (int n = 0; n < sqls.length; ++n) {
                String sql = sqls[n];
                Set standard = standards[n];
                try {
                    boolean hasResultSet = statement.execute(sql);
                    if (!hasResultSet) continue;
                    try (ResultSet resultSet = statement.getResultSet();){
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        while (resultSet.next()) {
                            StringBuilder builder = new StringBuilder();
                            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                                builder.append(resultSet.getString(i)).append(",");
                            }
                            Assert.assertTrue((boolean)standard.contains(builder.toString()));
                        }
                        continue;
                    }
                }
                catch (SQLException e) {
                    logger.error("showTimeseriesTest() failed", (Throwable)e);
                    Assert.fail((String)e.getMessage());
                }
            }
        }
    }

    @Test
    public void showStorageGroupTest() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] sqls = new String[]{"show storage group", "show storage group root.ln.wf01", "show storage group root.ln.wf01.wt01.status"};
            Set[] standards = new Set[]{new HashSet<String>(Arrays.asList("root.ln.wf01.wt01,", "root.ln1.wf01.wt01,", "root.ln2.wf01.wt01,")), new HashSet<String>(Collections.singletonList("root.ln.wf01.wt01,")), new HashSet<String>(Collections.singletonList(""))};
            for (int n = 0; n < sqls.length; ++n) {
                String sql = sqls[n];
                Set standard = standards[n];
                try {
                    boolean hasResultSet = statement.execute(sql);
                    if (!hasResultSet) continue;
                    try (ResultSet resultSet = statement.getResultSet();){
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        while (resultSet.next()) {
                            StringBuilder builder = new StringBuilder();
                            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                                builder.append(resultSet.getString(i)).append(",");
                            }
                            Assert.assertTrue((boolean)standard.contains(builder.toString()));
                        }
                        continue;
                    }
                }
                catch (SQLException e) {
                    logger.error("showStorageGroupTest() failed", (Throwable)e);
                    Assert.fail((String)e.getMessage());
                }
            }
        }
    }

    @Test
    public void databaseMetaDataTest() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = null;){
            connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
            this.databaseMetaData = connection.getMetaData();
            this.showTimeseriesInJson();
        }
    }

    @Test
    public void showVersion() throws SQLException, ClassNotFoundException {
        block20: {
            Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
            try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
                 Statement statement = connection.createStatement();){
                String sql = "show version";
                try {
                    boolean hasResultSet = statement.execute(sql);
                    if (!hasResultSet) break block20;
                    try (ResultSet resultSet = statement.getResultSet();){
                        resultSet.next();
                        Assert.assertEquals((Object)IoTDBConstant.VERSION, (Object)resultSet.getString(1));
                    }
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        }
    }

    @Test
    public void showDevicesWithSgTest() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] sqls = new String[]{"show devices root.ln with storage group", "show devices root.ln.wf01.wt01.temperature"};
            Set[] standards = new Set[]{new HashSet<String>(Arrays.asList("root.ln.wf01.wt01,root.ln.wf01.wt01,", "root.ln.wf01.wt01.status,root.ln.wf01.wt01,")), new HashSet<String>(Collections.singletonList(""))};
            for (int n = 0; n < sqls.length; ++n) {
                String sql = sqls[n];
                Set standard = standards[n];
                try {
                    boolean hasResultSet = statement.execute(sql);
                    if (!hasResultSet) continue;
                    try (ResultSet resultSet = statement.getResultSet();){
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        while (resultSet.next()) {
                            StringBuilder builder = new StringBuilder();
                            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                                builder.append(resultSet.getString(i)).append(",");
                            }
                            Assert.assertTrue((boolean)standard.contains(builder.toString()));
                        }
                        continue;
                    }
                }
                catch (SQLException e) {
                    logger.error("showDevicesTest() failed", (Throwable)e);
                    Assert.fail((String)e.getMessage());
                }
            }
        }
    }

    @Test
    public void showDevicesTest() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] sqls = new String[]{"show devices root.ln", "show devices root.ln.wf01.wt01.temperature"};
            Set[] standards = new Set[]{new HashSet<String>(Arrays.asList("root.ln.wf01.wt01,", "root.ln.wf01.wt01.status,")), new HashSet<String>(Collections.singletonList(""))};
            for (int n = 0; n < sqls.length; ++n) {
                String sql = sqls[n];
                Set standard = standards[n];
                try {
                    boolean hasResultSet = statement.execute(sql);
                    if (!hasResultSet) continue;
                    try (ResultSet resultSet = statement.getResultSet();){
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        while (resultSet.next()) {
                            StringBuilder builder = new StringBuilder();
                            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                                builder.append(resultSet.getString(i)).append(",");
                            }
                            Assert.assertTrue((boolean)standard.contains(builder.toString()));
                        }
                        continue;
                    }
                }
                catch (SQLException e) {
                    logger.error("showDevicesTest() failed", (Throwable)e);
                    Assert.fail((String)e.getMessage());
                }
            }
        }
    }

    @Test
    public void showChildPaths() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] sqls = new String[]{"show child paths root.ln"};
            String[] standards = new String[]{"root.ln.wf01,\n"};
            for (int n = 0; n < sqls.length; ++n) {
                String sql = sqls[n];
                String standard = standards[n];
                StringBuilder builder = new StringBuilder();
                try {
                    boolean hasResultSet = statement.execute(sql);
                    if (hasResultSet) {
                        try (ResultSet resultSet = statement.getResultSet();){
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            while (resultSet.next()) {
                                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                                    builder.append(resultSet.getString(i)).append(",");
                                }
                                builder.append("\n");
                            }
                        }
                    }
                    Assert.assertEquals((Object)standard, (Object)builder.toString());
                    continue;
                }
                catch (SQLException e) {
                    logger.error("showChildPaths() failed", (Throwable)e);
                    Assert.fail((String)e.getMessage());
                }
            }
        }
    }

    @Test
    public void showChildNodes() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] sqls = new String[]{"show child nodes root.ln"};
            String[] standards = new String[]{"wf01,\n"};
            for (int n = 0; n < sqls.length; ++n) {
                String sql = sqls[n];
                String standard = standards[n];
                StringBuilder builder = new StringBuilder();
                try {
                    boolean hasResultSet = statement.execute(sql);
                    if (hasResultSet) {
                        try (ResultSet resultSet = statement.getResultSet();){
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            while (resultSet.next()) {
                                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                                    builder.append(resultSet.getString(i)).append(",");
                                }
                                builder.append("\n");
                            }
                        }
                    }
                    Assert.assertEquals((Object)standard, (Object)builder.toString());
                    continue;
                }
                catch (SQLException e) {
                    logger.error("showChildNodes() failed", (Throwable)e);
                    Assert.fail((String)e.getMessage());
                }
            }
        }
    }

    @Test
    public void showCountTimeSeries() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] sqls = new String[]{"COUNT TIMESERIES root.ln", "COUNT TIMESERIES"};
            String[] standards = new String[]{"3,\n", "3,\n"};
            for (int n = 0; n < sqls.length; ++n) {
                String sql = sqls[n];
                String standard = standards[n];
                StringBuilder builder = new StringBuilder();
                try {
                    boolean hasResultSet = statement.execute(sql);
                    if (hasResultSet) {
                        try (ResultSet resultSet = statement.getResultSet();){
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            while (resultSet.next()) {
                                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                                    builder.append(resultSet.getString(i)).append(",");
                                }
                                builder.append("\n");
                            }
                        }
                    }
                    Assert.assertEquals((Object)standard, (Object)builder.toString());
                    continue;
                }
                catch (SQLException e) {
                    logger.error("showCountTimeSeries() failed", (Throwable)e);
                    Assert.fail((String)e.getMessage());
                }
            }
        }
    }

    @Test
    public void showCountDevices() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] sqls = new String[]{"COUNT DEVICES root.ln", "COUNT DEVICES", "COUNT DEVICES root.ln.wf01.wt01.temperature"};
            String[] standards = new String[]{"2,\n", "2,\n", "0,\n"};
            for (int n = 0; n < sqls.length; ++n) {
                String sql = sqls[n];
                String standard = standards[n];
                StringBuilder builder = new StringBuilder();
                try {
                    boolean hasResultSet = statement.execute(sql);
                    if (hasResultSet) {
                        try (ResultSet resultSet = statement.getResultSet();){
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            while (resultSet.next()) {
                                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                                    builder.append(resultSet.getString(i)).append(",");
                                }
                                builder.append("\n");
                            }
                        }
                    }
                    Assert.assertEquals((Object)standard, (Object)builder.toString());
                    continue;
                }
                catch (SQLException e) {
                    logger.error("showCountDevices() failed", (Throwable)e);
                    Assert.fail((String)e.getMessage());
                }
            }
        }
    }

    @Test
    public void showCountStorageGroup() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] sqls = new String[]{"count storage group root.ln", "count storage group", "count storage group root.ln.wf01.wt01.status"};
            String[] standards = new String[]{"1,\n", "3,\n", "0,\n"};
            for (int n = 0; n < sqls.length; ++n) {
                String sql = sqls[n];
                String standard = standards[n];
                StringBuilder builder = new StringBuilder();
                try {
                    boolean hasResultSet = statement.execute(sql);
                    if (hasResultSet) {
                        try (ResultSet resultSet = statement.getResultSet();){
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            while (resultSet.next()) {
                                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                                    builder.append(resultSet.getString(i)).append(",");
                                }
                                builder.append("\n");
                            }
                        }
                    }
                    Assert.assertEquals((Object)standard, (Object)builder.toString());
                    continue;
                }
                catch (SQLException e) {
                    logger.error("showCountStorageGroup() failed", (Throwable)e);
                    Assert.fail((String)e.getMessage());
                }
            }
        }
    }

    @Test
    public void showCountTimeSeriesGroupBy() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] sqls = new String[]{"COUNT TIMESERIES root group by level=1"};
            Set[] standards = new Set[]{new HashSet<String>(Arrays.asList("root.ln,3,", "root.ln1,0,", "root.ln2,0,"))};
            for (int n = 0; n < sqls.length; ++n) {
                String sql = sqls[n];
                Set standard = standards[n];
                try {
                    boolean hasResultSet = statement.execute(sql);
                    if (!hasResultSet) continue;
                    try (ResultSet resultSet = statement.getResultSet();){
                        while (resultSet.next()) {
                            StringBuilder builder = new StringBuilder();
                            builder.append(resultSet.getString(1)).append(",");
                            builder.append(resultSet.getInt(2)).append(",");
                            Assert.assertTrue((boolean)standard.contains(builder.toString()));
                        }
                        continue;
                    }
                }
                catch (SQLException e) {
                    logger.error("showCountTimeSeriesGroupBy() failed", (Throwable)e);
                    Assert.fail((String)e.getMessage());
                }
            }
        }
    }

    @Test
    public void showCountNodes() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] sqls = new String[]{"COUNT NODES root level=1"};
            String[] standards = new String[]{"3,\n"};
            for (int n = 0; n < sqls.length; ++n) {
                String sql = sqls[n];
                String standard = standards[n];
                StringBuilder builder = new StringBuilder();
                try {
                    boolean hasResultSet = statement.execute(sql);
                    if (hasResultSet) {
                        try (ResultSet resultSet = statement.getResultSet();){
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            while (resultSet.next()) {
                                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                                    builder.append(resultSet.getString(i)).append(",");
                                }
                                builder.append("\n");
                            }
                        }
                    }
                    Assert.assertEquals((Object)standard, (Object)builder.toString());
                    continue;
                }
                catch (SQLException e) {
                    logger.error("showCountNodes() failed", (Throwable)e);
                    Assert.fail((String)e.getMessage());
                }
            }
        }
    }

    private void showTimeseriesInJson() {
        String metadataInJson = this.databaseMetaData.toString();
        String standard = "===  Timeseries Tree  ===\n\n{\n\t\"root\":{\n\t\t\"ln2\":{\n\t\t\t\"wf01\":{\n\t\t\t\t\"wt01\":{}\n\t\t\t}\n\t\t},\n\t\t\"ln\":{\n\t\t\t\"wf01\":{\n\t\t\t\t\"wt01\":{\n\t\t\t\t\t\"temperature\":{\n\t\t\t\t\t\t\"args\":\"{max_point_number=3}\",\n\t\t\t\t\t\t\"StorageGroup\":\"root.ln.wf01.wt01\",\n\t\t\t\t\t\t\"DataType\":\"FLOAT\",\n\t\t\t\t\t\t\"Compressor\":\"SNAPPY\",\n\t\t\t\t\t\t\"Encoding\":\"RLE\"\n\t\t\t\t\t},\n\t\t\t\t\t\"status\":{\n\t\t\t\t\t\t\"s1\":{\n\t\t\t\t\t\t\t\"StorageGroup\":\"root.ln.wf01.wt01\",\n\t\t\t\t\t\t\t\"DataType\":\"BOOLEAN\",\n\t\t\t\t\t\t\t\"Compressor\":\"SNAPPY\",\n\t\t\t\t\t\t\t\"Encoding\":\"PLAIN\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ln1\":{\n\t\t\t\"wf01\":{\n\t\t\t\t\"wt01\":{}\n\t\t\t}\n\t\t}\n\t}\n}";
        String rawJsonString = metadataInJson.substring("===  Timeseries Tree  ===\n\n".length());
        Gson gson = new Gson();
        JsonObject actual = (JsonObject)gson.fromJson(rawJsonString, JsonObject.class);
        JsonObject expected = (JsonObject)gson.fromJson(standard.substring("===  Timeseries Tree  ===\n\n".length()), JsonObject.class);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

