/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBMergeIT {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBMergeIT.class);
    private long prevPartitionInterval;
    private CompactionStrategy prevTsFileManagementStrategy;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        this.prevPartitionInterval = IoTDBDescriptor.getInstance().getConfig().getPartitionInterval();
        this.prevTsFileManagementStrategy = IoTDBDescriptor.getInstance().getConfig().getCompactionStrategy();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(1L);
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(this.prevPartitionInterval);
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(this.prevTsFileManagementStrategy);
    }

    @Test
    public void testOverlap() throws SQLException {
        logger.info("test...");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.mergeTest");
            try {
                statement.execute("CREATE TIMESERIES root.mergeTest.s1 WITH DATATYPE=INT64,ENCODING=PLAIN");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1) VALUES (%d,%d)", 1, 1));
            statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1) VALUES (%d,%d)", 2, 2));
            statement.execute("FLUSH");
            statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1) VALUES (%d,%d)", 5, 5));
            statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1) VALUES (%d,%d)", 6, 6));
            statement.execute("FLUSH");
            statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1) VALUES (%d,%d)", 2, 3));
            statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1) VALUES (%d,%d)", 3, 3));
            statement.execute("FLUSH");
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.mergeTest");){
                int cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s1 = resultSet.getLong("root.mergeTest.s1");
                    if (time == 2L) {
                        Assert.assertEquals((long)3L, (long)s1);
                    } else {
                        Assert.assertEquals((long)time, (long)s1);
                    }
                    ++cnt;
                }
                Assert.assertEquals((long)5L, (long)cnt);
            }
        }
    }

    @Test
    public void test() throws SQLException {
        logger.info("test...");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int i;
            statement.execute("SET STORAGE GROUP TO root.mergeTest");
            for (i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.mergeTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (i = 0; i < 10; ++i) {
                int cnt;
                int j;
                logger.info("Running the {} round merge", (Object)i);
                for (j = i * 10 + 1; j <= (i + 1) * 10; ++j) {
                    statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", j, j + 1, j + 2, j + 3));
                }
                statement.execute("FLUSH");
                for (j = i * 10 + 1; j <= (i + 1) * 10; ++j) {
                    statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", j, j + 10, j + 20, j + 30));
                }
                statement.execute("FLUSH");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.mergeTest");){
                    cnt = 0;
                    while (resultSet.next()) {
                        long time = resultSet.getLong("Time");
                        long s1 = resultSet.getLong("root.mergeTest.s1");
                        long s2 = resultSet.getLong("root.mergeTest.s2");
                        long s3 = resultSet.getLong("root.mergeTest.s3");
                        Assert.assertEquals((long)(time + 10L), (long)s1);
                        Assert.assertEquals((long)(time + 20L), (long)s2);
                        Assert.assertEquals((long)(time + 30L), (long)s3);
                        ++cnt;
                    }
                }
                Assert.assertEquals((long)((i + 1) * 10), (long)cnt);
            }
        }
    }

    @Test
    public void testInvertedOrder() {
        logger.info("testInvertedOrder...");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            int j;
            statement.execute("SET STORAGE GROUP TO root.mergeTest");
            for (int i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.mergeTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (j = 10; j < 20; ++j) {
                statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", j, j + 1, j + 2, j + 3));
            }
            statement.execute("FLUSH");
            for (j = 20; j < 30; ++j) {
                statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", j, j + 1, j + 2, j + 3));
            }
            statement.execute("FLUSH");
            for (j = 20; j < 30; ++j) {
                statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", j, j + 10, j + 20, j + 30));
            }
            statement.execute("FLUSH");
            for (j = 10; j < 20; ++j) {
                statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", j, j + 10, j + 20, j + 30));
            }
            statement.execute("FLUSH");
            statement.execute("MERGE");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.mergeTest");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s1 = resultSet.getLong("root.mergeTest.s1");
                    long s2 = resultSet.getLong("root.mergeTest.s2");
                    long s3 = resultSet.getLong("root.mergeTest.s3");
                    Assert.assertEquals((long)(cnt + 10), (long)time);
                    Assert.assertEquals((long)(time + 10L), (long)s1);
                    Assert.assertEquals((long)(time + 20L), (long)s2);
                    Assert.assertEquals((long)(time + 30L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)20L, (long)cnt);
        }
        catch (SQLException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCrossPartition() throws SQLException {
        logger.info("testCrossPartition...");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            statement.execute("SET STORAGE GROUP TO root.mergeTest");
            for (int i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.mergeTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (int k = 0; k < 7; ++k) {
                for (int i = 0; i < 10; ++i) {
                    int j;
                    for (j = i * 1000 + 300 + k * 100; j <= i * 1000 + 399 + k * 100; ++j) {
                        statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", j, j + 1, j + 2, j + 3));
                    }
                    statement.execute("FLUSH");
                    for (j = i * 1000 + k * 100; j <= i * 1000 + 99 + k * 100; ++j) {
                        statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", j, j + 10, j + 20, j + 30));
                    }
                    statement.execute("FLUSH");
                }
            }
            statement.execute("MERGE");
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.mergeTest");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s1 = resultSet.getLong("root.mergeTest.s1");
                    long s2 = resultSet.getLong("root.mergeTest.s2");
                    long s3 = resultSet.getLong("root.mergeTest.s3");
                    Assert.assertEquals((long)cnt, (long)time);
                    if (time % 1000L < 700L) {
                        Assert.assertEquals((long)(time + 10L), (long)s1);
                        Assert.assertEquals((long)(time + 20L), (long)s2);
                        Assert.assertEquals((long)(time + 30L), (long)s3);
                    } else {
                        Assert.assertEquals((long)(time + 1L), (long)s1);
                        Assert.assertEquals((long)(time + 2L), (long)s2);
                        Assert.assertEquals((long)(time + 3L), (long)s3);
                    }
                    ++cnt;
                }
            }
            Assert.assertEquals((long)10000L, (long)cnt);
        }
    }

    @Test
    public void testShowMergeStatus() throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            int j;
            statement.execute("SET STORAGE GROUP TO root.mergeTest");
            for (int i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.mergeTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (j = 1; j <= 10; ++j) {
                statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", j, j + 1, j + 2, j + 3));
            }
            statement.execute("FLUSH");
            for (j = 1; j <= 10; ++j) {
                statement.execute(String.format("INSERT INTO root.mergeTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", j, j + 10, j + 20, j + 30));
            }
            statement.execute("FLUSH");
            statement.execute("MERGE");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try (ResultSet resultSet = statement.executeQuery("SHOW MERGE");){
                cnt = 0;
                int colNum = resultSet.getMetaData().getColumnCount();
                while (resultSet.next()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < colNum; ++i) {
                        stringBuilder.append(resultSet.getString(i + 1)).append(",");
                    }
                    System.out.println(stringBuilder);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)4L, (long)cnt);
        }
    }
}

