/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.FileUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBLoadExternalTsFileWithTimePartitionIT {
    String DOT = ".";
    String tempDir = "temp";
    String STORAGE_GROUP = "root.ln";
    String[] devices = new String[]{"d1", "d2"};
    String[] measurements = new String[]{"s1", "s2"};
    long startTime = 0L;
    long endTime = 1000000L;
    long timePartition = 100L;
    long recordTimeGap = 1000L;
    int originalTsFileNum = 0;
    boolean originalIsEnablePartition;
    long originalPartitionInterval;
    IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    @Before
    public void setUp() throws Exception {
        this.originalIsEnablePartition = this.config.isEnablePartition();
        this.originalPartitionInterval = this.config.getPartitionInterval();
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        StorageEngine.setEnablePartition((boolean)true);
        StorageEngine.setTimePartitionInterval((long)this.timePartition);
        this.prepareData();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
        StorageEngine.setEnablePartition((boolean)this.originalIsEnablePartition);
        StorageEngine.setTimePartitionInterval((long)this.originalPartitionInterval);
        File f = new File(this.tempDir);
        if (f.exists()) {
            FileUtils.deleteDirectory((File)f);
        }
    }

    String getName(int counter) {
        return this.tempDir + File.separator + System.currentTimeMillis() + "-" + counter + "-0.tsfile";
    }

    void writeData(TsFileWriter tsFileWriter, long timestamp) throws IOException, WriteProcessException {
        for (String deviceId : this.devices) {
            TSRecord tsRecord = new TSRecord(timestamp, this.STORAGE_GROUP + this.DOT + deviceId);
            for (String measurement : this.measurements) {
                LongDataPoint dPoint = new LongDataPoint(measurement, 10000L);
                tsRecord.addTuple((DataPoint)dPoint);
            }
            tsFileWriter.write(tsRecord);
        }
    }

    void register(TsFileWriter tsFileWriter) {
        try {
            for (String deviceId : this.devices) {
                for (String measurement : this.measurements) {
                    tsFileWriter.registerTimeseries(new Path(this.STORAGE_GROUP + this.DOT + deviceId, measurement), new MeasurementSchema(measurement, TSDataType.INT64, TSEncoding.RLE));
                }
            }
        }
        catch (WriteProcessException e) {
            e.printStackTrace();
        }
    }

    private void prepareData() {
        File dir = new File(this.tempDir);
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdir();
        try {
            TsFileWriter tsFileWriter = null;
            int counter = 0;
            for (long timestamp = this.startTime; timestamp < this.endTime; timestamp += this.recordTimeGap) {
                if (timestamp % (this.timePartition * this.recordTimeGap) == 0L) {
                    if (tsFileWriter != null) {
                        tsFileWriter.flushAllChunkGroups();
                        tsFileWriter.close();
                        ++counter;
                    }
                    String path = this.getName(counter);
                    File f = FSFactoryProducer.getFSFactory().getFile(path);
                    tsFileWriter = new TsFileWriter(new TsFileIOWriter(f));
                    this.register(tsFileWriter);
                }
                this.writeData(tsFileWriter, timestamp);
            }
            tsFileWriter.flushAllChunkGroups();
            tsFileWriter.close();
            this.originalTsFileNum = counter + 1;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Test
    public void loadTsFileWithTimePartition() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int i;
            statement.execute(String.format("load \"%s\"", new File(this.tempDir).getAbsolutePath()));
            String dataDir = this.config.getDataDirs()[0];
            File f = new File(dataDir, new PartialPath("sequence") + File.separator + "root.ln" + File.separator + "0");
            Assert.assertEquals((long)((this.endTime - this.startTime) / this.timePartition), (long)(f.list().length * this.originalTsFileNum));
            int totalPartitionsNum = (int)((this.endTime - this.startTime) / this.timePartition / (long)this.originalTsFileNum);
            int[] splitTsFilePartitions = new int[totalPartitionsNum];
            for (i = 0; i < splitTsFilePartitions.length; ++i) {
                splitTsFilePartitions[i] = Integer.parseInt(f.list()[i]);
            }
            Arrays.sort(splitTsFilePartitions);
            i = 0;
            while ((long)i < (this.endTime - this.startTime) / this.timePartition / (long)this.originalTsFileNum) {
                Assert.assertEquals((long)(i * this.originalTsFileNum), (long)splitTsFilePartitions[i]);
                ++i;
            }
            i = 0;
            while ((long)i < (this.endTime - this.startTime) / this.timePartition / (long)this.originalTsFileNum) {
                Assert.assertEquals((long)2L, (long)new File(f.getAbsolutePath(), "" + i * this.originalTsFileNum).list().length);
                ++i;
            }
        }
        catch (SQLException | IllegalPathException throwables) {
            throwables.printStackTrace();
        }
    }
}

