/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.jdbc.IoTDBDatabaseMetadata;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBLimitSlimitIT {
    private static String[] insertSqls = new String[]{"SET STORAGE GROUP TO root.vehicle", "CREATE TIMESERIES root.vehicle.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s1 WITH DATATYPE=INT64, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s2 WITH DATATYPE=FLOAT, ENCODING=RLE", "insert into root.vehicle.d0(timestamp,s0) values(1,101)", "insert into root.vehicle.d0(timestamp,s0) values(2,198)", "insert into root.vehicle.d0(timestamp,s0) values(100,99)", "insert into root.vehicle.d0(timestamp,s0) values(101,99)", "insert into root.vehicle.d0(timestamp,s0) values(102,80)", "insert into root.vehicle.d0(timestamp,s0) values(103,99)", "insert into root.vehicle.d0(timestamp,s0) values(104,90)", "insert into root.vehicle.d0(timestamp,s0) values(105,99)", "insert into root.vehicle.d0(timestamp,s0) values(106,99)", "insert into root.vehicle.d0(timestamp,s0) values(2,10000)", "insert into root.vehicle.d0(timestamp,s0) values(50,10000)", "insert into root.vehicle.d0(timestamp,s0) values(1000,22222)", "insert into root.vehicle.d0(timestamp,s1) values(1,1101)", "insert into root.vehicle.d0(timestamp,s1) values(2,198)", "insert into root.vehicle.d0(timestamp,s1) values(100,199)", "insert into root.vehicle.d0(timestamp,s1) values(101,199)", "insert into root.vehicle.d0(timestamp,s1) values(102,180)", "insert into root.vehicle.d0(timestamp,s1) values(103,199)", "insert into root.vehicle.d0(timestamp,s1) values(104,190)", "insert into root.vehicle.d0(timestamp,s1) values(105,199)", "insert into root.vehicle.d0(timestamp,s1) values(2,40000)", "insert into root.vehicle.d0(timestamp,s1) values(50,50000)", "insert into root.vehicle.d0(timestamp,s1) values(1000,55555)", "insert into root.vehicle.d0(timestamp,s2) values(1000,55555)", "insert into root.vehicle.d0(timestamp,s2) values(2,2.22)", "insert into root.vehicle.d0(timestamp,s2) values(3,3.33)", "insert into root.vehicle.d0(timestamp,s2) values(4,4.44)", "insert into root.vehicle.d0(timestamp,s2) values(102,10.00)", "insert into root.vehicle.d0(timestamp,s2) values(105,11.11)", "insert into root.vehicle.d0(timestamp,s2) values(1000,1000.11)", "insert into root.vehicle.d0(timestamp,s1) values(2000-01-01T08:00:00+08:00, 100)"};

    @BeforeClass
    public static void setUp() {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    private static void insertData() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : insertSqls) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void Test() throws ClassNotFoundException {
        IoTDBLimitSlimitIT.insertData();
        this.SelectTest();
    }

    public void SelectTest() throws ClassNotFoundException {
        String[] sqlS = new String[]{"SELECT s1 FROM root.vehicle.d0 WHERE time<200 limit 3", "1,1101,\n2,40000,\n50,50000,\n", "SELECT s0 FROM root.vehicle.d0 WHERE s1 > 190 limit 3", "1,101,\n2,10000,\n50,10000,\n", "SELECT s1,s2 FROM root.vehicle.d0 where s1>190 or s2<10.0 limit 3 offset 2", "3,null,3.33,\n4,null,4.44,\n50,50000,null,\n", "select * from root.vehicle.d0 slimit 1", "1,101,\n2,10000,\n50,10000,\n100,99,\n101,99,\n102,80,\n103,99,\n104,90,\n105,99,\n106,99,\n1000,22222,\n", "select * from root.vehicle.d0 slimit 1 soffset 2", "2,2.22,\n3,3.33,\n4,4.44,\n102,10.0,\n105,11.11,\n1000,1000.11,\n", "select d0 from root.vehicle slimit 1 soffset 2", "2,2.22,\n3,3.33,\n4,4.44,\n102,10.0,\n105,11.11,\n1000,1000.11,\n", "select * from root.vehicle.d0 where s1>190 or s2 < 10.0 limit 3 offset 1 slimit 1 soffset 2 ", "3,3.33,\n4,4.44,\n105,11.11,\n"};
        this.executeSQL(sqlS);
    }

    private void executeSQL(String[] sqls) throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String result = "";
            Long now_start = 0L;
            boolean cmp = false;
            for (String sql : sqls) {
                if (cmp) {
                    Assert.assertEquals((Object)sql, (Object)result);
                    cmp = false;
                    continue;
                }
                if (sql.equals("SHOW TIMESERIES")) {
                    DatabaseMetaData data = connection.getMetaData();
                    result = ((IoTDBDatabaseMetadata)data).getMetadataInJson();
                    cmp = true;
                    continue;
                }
                if (sql.contains("NOW()") && now_start == 0L) {
                    now_start = System.currentTimeMillis();
                }
                statement.execute(sql);
                if (!(sql.split(" ")[0].equals("SELECT") | sql.split(" ")[0].equals("select"))) continue;
                try (ResultSet resultSet = statement.getResultSet();){
                    int i;
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    int count = metaData.getColumnCount();
                    String[] column = new String[count];
                    for (i = 0; i < count; ++i) {
                        column[i] = metaData.getColumnName(i + 1);
                    }
                    result = "";
                    while (resultSet.next()) {
                        for (i = 1; i <= count; ++i) {
                            if (now_start > 0L && column[i - 1] == "Time") {
                                String timestr = resultSet.getString(i);
                                Long tn = Long.valueOf(timestr);
                                Long now = System.currentTimeMillis();
                                if (tn >= now_start && tn <= now) {
                                    timestr = "NOW()";
                                }
                                result = result + timestr + ',';
                                continue;
                            }
                            result = result + resultSet.getString(i) + ',';
                        }
                        result = result + '\n';
                    }
                    cmp = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

