/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBLevelCompactionIT {
    CompactionStrategy prevCompactionStrategy;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        this.prevCompactionStrategy = IoTDBDescriptor.getInstance().getConfig().getCompactionStrategy();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(this.prevCompactionStrategy);
    }

    @Test
    public void test() throws SQLException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(3);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            for (int i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.compactionTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            int flushCount = 32;
            for (int i = 0; i < flushCount; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s1 = resultSet.getLong("root.compactionTest.s1");
                    long s2 = resultSet.getLong("root.compactionTest.s2");
                    long s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 1L), (long)s1);
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)flushCount, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
    }

    @Test
    public void testAppendMergeAfterDeserializeMerge() throws SQLException {
        boolean prevEnableUnseqCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqCompaction();
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(3);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(false);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            long row;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            try {
                statement.execute("CREATE TIMESERIES root.compactionTest.s1 WITH DATATYPE=INT64");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            long pageSize = 100L;
            long timestamp = 1L;
            for (row = 0L; row < 10000L; ++row) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1) VALUES (%d,%d)", timestamp, 1));
                if (row % pageSize == 0L) {
                    statement.execute("FLUSH");
                }
                ++timestamp;
            }
            timestamp = 8322L;
            for (row = 0L; row < 2400L; ++row) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1) VALUES (%d,%d)", timestamp, 1));
                if (row % pageSize == 0L) {
                    statement.execute("FLUSH");
                }
                ++timestamp;
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT COUNT(s1) FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    System.out.println(resultSet.getLong(1));
                    Assert.assertEquals((long)10721L, (long)resultSet.getLong(1));
                    ++cnt;
                }
            }
            Assert.assertEquals((long)1L, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(prevEnableUnseqCompaction);
    }

    @Test
    public void testDeserializeMergeAfterAppendMerge() throws SQLException {
        boolean prevEnableUnseqCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqCompaction();
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(3);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(false);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            long row;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            try {
                statement.execute("CREATE TIMESERIES root.compactionTest.s1 WITH DATATYPE=INT64");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            long pageSize = 100L;
            long timestamp = 1L;
            int prevMergePagePointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getMergePagePointNumberThreshold();
            IoTDBDescriptor.getInstance().getConfig().setMergePagePointNumberThreshold(1);
            for (row = 0L; row < 10000L; ++row) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1) VALUES (%d,%d)", timestamp, 1));
                if (row % pageSize == 0L) {
                    statement.execute("FLUSH");
                }
                ++timestamp;
            }
            timestamp = 8322L;
            IoTDBDescriptor.getInstance().getConfig().setMergePagePointNumberThreshold(10000000);
            for (row = 0L; row < 2400L; ++row) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1) VALUES (%d,%d)", timestamp, 1));
                if (row % pageSize == 0L) {
                    statement.execute("FLUSH");
                }
                ++timestamp;
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT COUNT(s1) FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    System.out.println(resultSet.getLong(1));
                    Assert.assertEquals((long)10721L, (long)resultSet.getLong(1));
                    ++cnt;
                }
            }
            Assert.assertEquals((long)1L, (long)cnt);
            IoTDBDescriptor.getInstance().getConfig().setMergePagePointNumberThreshold(prevMergePagePointNumberThreshold);
        }
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(prevEnableUnseqCompaction);
    }

    private void testCompactionNoUnseq(int mergeCount) throws SQLException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(3);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            int i;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            for (i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.compactionTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (i = 0; i < mergeCount; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s1 = resultSet.getLong("root.compactionTest.s1");
                    long s2 = resultSet.getLong("root.compactionTest.s2");
                    long s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 1L), (long)s1);
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)mergeCount, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
    }

    @Test
    public void testCompactionOnceNoUnseq() throws SQLException {
        this.testCompactionNoUnseq(2);
    }

    @Test
    public void testCompactionOnceWithUnseq() throws SQLException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(3);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            for (int i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.compactionTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", 1, 2, 3, 4));
            statement.execute("FLUSH");
            statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", 0, 1, 2, 3));
            statement.execute("FLUSH");
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s1 = resultSet.getLong("root.compactionTest.s1");
                    long s2 = resultSet.getLong("root.compactionTest.s2");
                    long s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 1L), (long)s1);
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)2L, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
    }

    @Test
    public void testCompactionToSecondLevelNoUnseq() throws SQLException {
        this.testCompactionNoUnseq(4);
    }

    @Test
    public void testCompactionToSecondLevelWithUnseq() throws SQLException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(3);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            int i;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            for (i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.compactionTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (i = 1; i < 3; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 0; i < 1; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 3; i < 5; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s1 = resultSet.getLong("root.compactionTest.s1");
                    long s2 = resultSet.getLong("root.compactionTest.s2");
                    long s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 1L), (long)s1);
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)5L, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
    }

    @Test
    public void testCompactionToSecondLevelWithUnseqDisableUnseqCompaction() throws SQLException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        boolean prevEnableUnseqCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqCompaction();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(3);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            int i;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            for (i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.compactionTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (i = 1; i < 3; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 0; i < 1; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 3; i < 5; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s1 = resultSet.getLong("root.compactionTest.s1");
                    long s2 = resultSet.getLong("root.compactionTest.s2");
                    long s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 1L), (long)s1);
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)5L, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(prevEnableUnseqCompaction);
    }

    @Test
    public void testCompactionToStableLevelNoUnseq() throws SQLException {
        this.testCompactionNoUnseq(8);
    }

    @Test
    public void testCompactionToStableLevelWithUnseq() throws SQLException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(3);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            int i;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            for (i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.compactionTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (i = 4; i < 8; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 0; i < 4; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 8; i < 12; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s1 = resultSet.getLong("root.compactionTest.s1");
                    long s2 = resultSet.getLong("root.compactionTest.s2");
                    long s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 1L), (long)s1);
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)12L, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
    }

    @Test
    public void testCompactionToStableLevelWithUnseqDisableUnseqCompaction() throws SQLException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        boolean prevEnableUnseqCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqCompaction();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(3);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            int i;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            for (i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.compactionTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (i = 4; i < 8; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 0; i < 4; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 8; i < 12; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s1 = resultSet.getLong("root.compactionTest.s1");
                    long s2 = resultSet.getLong("root.compactionTest.s2");
                    long s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 1L), (long)s1);
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)12L, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(prevEnableUnseqCompaction);
    }

    @Test
    public void testCompactionSeqMaxLevelNumError0() throws SQLException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(0);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            int i;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            for (i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.compactionTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (i = 4; i < 8; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 0; i < 4; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 8; i < 12; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s1 = resultSet.getLong("root.compactionTest.s1");
                    long s2 = resultSet.getLong("root.compactionTest.s2");
                    long s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 1L), (long)s1);
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)12L, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
    }

    @Test
    public void testCompactionSeqMaxLevelNumError1() throws SQLException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(-1);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            int i;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            for (i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.compactionTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (i = 4; i < 8; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 0; i < 4; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 8; i < 12; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s1 = resultSet.getLong("root.compactionTest.s1");
                    long s2 = resultSet.getLong("root.compactionTest.s2");
                    long s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 1L), (long)s1);
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)12L, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
    }

    @Test
    public void testCompactionSeqFileNumInEachLevelError0() throws SQLException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(0);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(3);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            int i;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            for (i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.compactionTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (i = 4; i < 8; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 0; i < 4; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 8; i < 12; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s1 = resultSet.getLong("root.compactionTest.s1");
                    long s2 = resultSet.getLong("root.compactionTest.s2");
                    long s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 1L), (long)s1);
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)12L, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
    }

    @Test
    public void testCompactionSeqFileNumInEachLevelError1() throws SQLException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(-1);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(3);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            int i;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            for (i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.compactionTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (i = 4; i < 8; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 0; i < 4; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 8; i < 12; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s1 = resultSet.getLong("root.compactionTest.s1");
                    long s2 = resultSet.getLong("root.compactionTest.s2");
                    long s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 1L), (long)s1);
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)12L, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
    }

    @Test
    public void testCompactionWithUnseqCompaction() throws SQLException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        int prevUnSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getUnseqFileNumInEachLevel();
        int prevUnSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getUnseqLevelNum();
        boolean prevEnableUnseqCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(false);
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(3);
        IoTDBDescriptor.getInstance().getConfig().setUnseqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setUnseqLevelNum(3);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            long s3;
            long s2;
            long s1;
            long time;
            int cnt;
            int i;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            for (i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.compactionTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (i = 10000; i < 10001; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 0; i < 50; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 10001; i < 10005; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    time = resultSet.getLong("Time");
                    s1 = resultSet.getLong("root.compactionTest.s1");
                    s2 = resultSet.getLong("root.compactionTest.s2");
                    s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 1L), (long)s1);
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)55L, (long)cnt);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(true);
            for (int i2 = 10010; i2 < 10055; ++i2) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i2, i2 + 1, i2 + 2, i2 + 3));
                statement.execute("FLUSH");
            }
            resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");
            try {
                cnt = 0;
                while (resultSet.next()) {
                    time = resultSet.getLong("Time");
                    s1 = resultSet.getLong("root.compactionTest.s1");
                    s2 = resultSet.getLong("root.compactionTest.s2");
                    s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 1L), (long)s1);
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            Assert.assertEquals((long)100L, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(prevEnableUnseqCompaction);
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
        IoTDBDescriptor.getInstance().getConfig().setUnseqFileNumInEachLevel(prevUnSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setUnseqLevelNum(prevUnSeqLevelNum);
    }

    @Test
    public void testCompactionWithDeletionTimeseries() throws SQLException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        int prevUnSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getUnseqFileNumInEachLevel();
        int prevUnSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getUnseqLevelNum();
        boolean prevEnableUnseqCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(false);
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(3);
        IoTDBDescriptor.getInstance().getConfig().setUnseqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setUnseqLevelNum(3);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            int i;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            for (i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.compactionTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (i = 0; i < 1; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            statement.execute("DELETE timeseries root.compactionTest.s1");
            for (i = 1; i < 2; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s2,s3) VALUES (%d,%d,%d)", i, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    long s2 = resultSet.getLong("root.compactionTest.s2");
                    long s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)2L, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(prevEnableUnseqCompaction);
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
        IoTDBDescriptor.getInstance().getConfig().setUnseqFileNumInEachLevel(prevUnSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setUnseqLevelNum(prevUnSeqLevelNum);
    }

    @Test
    public void testCompactionWithDeletionTimeseriesAndCreateDifferentTypeTest() throws SQLException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        int prevUnSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getUnseqFileNumInEachLevel();
        int prevUnSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getUnseqLevelNum();
        boolean prevEnableUnseqCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(false);
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(3);
        IoTDBDescriptor.getInstance().getConfig().setUnseqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setUnseqLevelNum(3);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            long s3;
            long s2;
            long time;
            int cnt;
            int i;
            statement.execute("SET STORAGE GROUP TO root.compactionTest");
            for (i = 1; i <= 3; ++i) {
                try {
                    statement.execute("CREATE TIMESERIES root.compactionTest.s" + i + " WITH DATATYPE=INT64,ENCODING=PLAIN");
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            for (i = 10000; i < 10001; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            for (i = 0; i < 50; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                if (i % 2 != 1) continue;
                statement.execute("FLUSH");
            }
            statement.execute("FLUSH");
            statement.execute("DELETE timeseries root.compactionTest.s1");
            statement.execute("create timeseries root.compactionTest.s1 with datatype=FLOAT, encoding=PLAIN");
            for (i = 10001; i < 10005; ++i) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i, i + 1, i + 2, i + 3));
                statement.execute("FLUSH");
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");){
                cnt = 0;
                while (resultSet.next()) {
                    time = resultSet.getLong("Time");
                    s2 = resultSet.getLong("root.compactionTest.s2");
                    s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)55L, (long)cnt);
            IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(true);
            for (int i2 = 10010; i2 < 10055; ++i2) {
                statement.execute(String.format("INSERT INTO root.compactionTest(timestamp,s1,s2,s3) VALUES (%d,%d,%d,%d)", i2, i2 + 1, i2 + 2, i2 + 3));
                statement.execute("FLUSH");
            }
            resultSet = statement.executeQuery("SELECT * FROM root.compactionTest");
            try {
                cnt = 0;
                while (resultSet.next()) {
                    time = resultSet.getLong("Time");
                    s2 = resultSet.getLong("root.compactionTest.s2");
                    s3 = resultSet.getLong("root.compactionTest.s3");
                    Assert.assertEquals((long)(time + 2L), (long)s2);
                    Assert.assertEquals((long)(time + 3L), (long)s3);
                    ++cnt;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            Assert.assertEquals((long)100L, (long)cnt);
        }
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(prevEnableUnseqCompaction);
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
        IoTDBDescriptor.getInstance().getConfig().setUnseqFileNumInEachLevel(prevUnSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setUnseqLevelNum(prevUnSeqLevelNum);
    }
}

