/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBLargeDataIT {
    private static TSFileConfig tsFileConfig = TSFileDescriptor.getInstance().getConfig();
    private static int maxNumberOfPointsInPage;
    private static int pageSizeInByte;
    private static int groupSizeInByte;

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.NO_COMPACTION);
        maxNumberOfPointsInPage = tsFileConfig.getMaxNumberOfPointsInPage();
        pageSizeInByte = tsFileConfig.getPageSizeInByte();
        groupSizeInByte = tsFileConfig.getGroupSizeInByte();
        tsFileConfig.setMaxNumberOfPointsInPage(1000);
        tsFileConfig.setPageSizeInByte(153600);
        tsFileConfig.setGroupSizeInByte(1024000);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold(1024000L);
        EnvironmentUtils.envSetUp();
        IoTDBLargeDataIT.insertData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        tsFileConfig.setMaxNumberOfPointsInPage(maxNumberOfPointsInPage);
        tsFileConfig.setPageSizeInByte(pageSizeInByte);
        tsFileConfig.setGroupSizeInByte(groupSizeInByte);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold((long)groupSizeInByte);
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
        EnvironmentUtils.cleanEnv();
    }

    private static void insertData() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int time;
            for (String sql : TestConstant.create_sql) {
                statement.execute(sql);
            }
            for (time = 13700; time < 24000; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, time % 123);
                statement.execute(sql);
            }
            for (time = 3000; time < 13600; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time % 100);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time % 17);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, time % 22);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s3) values(%s,'%s')", time, TestConstant.stringValue[time % 5]);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s4) values(%s, %s)", time, TestConstant.booleanValue[time % 2]);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s5) values(%s, %s)", time, time);
                statement.execute(sql);
            }
            statement.execute("flush");
            statement.execute("merge");
            for (time = 100000; time < 101000; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time % 20);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time % 30);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, time % 77);
                statement.execute(sql);
            }
            statement.execute("flush");
            for (time = 200000; time < 201000; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, -time % 20);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, -time % 30);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, -time % 77);
                statement.execute(sql);
            }
            for (time = 2000; time < 2500; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time + 1);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, time + 2);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s3) values(%s,'%s')", time, TestConstant.stringValue[time % 5]);
                statement.execute(sql);
            }
            for (time = 200900; time < 201000; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, 6666);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, 7777);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, 8888);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s3) values(%s,'%s')", time, "goodman");
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s4) values(%s, %s)", time, TestConstant.booleanValue[time % 2]);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s5) values(%s, %s)", time, 9999);
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectAllTest() throws ClassNotFoundException {
        String selectSql = "select * from root.vehicle";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute(selectSql);
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString("root.vehicle.d0.s0") + "," + resultSet.getString("root.vehicle.d0.s1") + "," + resultSet.getString("root.vehicle.d0.s2") + "," + resultSet.getString("root.vehicle.d0.s3") + "," + resultSet.getString("root.vehicle.d0.s4") + "," + resultSet.getString("root.vehicle.d0.s5");
                    ++cnt;
                }
                Assert.assertEquals((long)23400L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectOneSeriesWithValueFilterTest() throws ClassNotFoundException {
        String selectSql = "select s0 from root.vehicle.d0 where s0 >= 20";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute(selectSql);
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString("root.vehicle.d0.s0");
                    ++cnt;
                }
                Assert.assertEquals((long)16440L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void seriesGlobalTimeFilterTest() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select s0 from root.vehicle.d0 where time > 22987");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString("root.vehicle.d0.s0");
                    ++cnt;
                }
                Assert.assertEquals((long)3012L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void crossSeriesReadUpdateTest() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select s1 from root.vehicle.d0 where s0 < 111");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                while (resultSet.next()) {
                    long time = Long.parseLong(resultSet.getString("Time"));
                    String value = resultSet.getString("root.vehicle.d0.s1");
                    if (time > 200900L) {
                        Assert.assertEquals((Object)"7777", (Object)value);
                    }
                    ++cnt;
                }
                Assert.assertEquals((long)22800L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

