/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBInsertWithQueryIT {
    @Before
    public void setUp() {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void insertWithQueryTest() throws ClassNotFoundException {
        this.insertData(0, 1000);
        this.selectAndCount(1000);
        this.insertData(1000, 2000);
        this.selectAndCount(2000);
    }

    @Test
    public void insertWithQueryMultiThreadTest() throws ClassNotFoundException, InterruptedException {
        this.insertData(0, 1000);
        this.selectWithMultiThread(1000);
        this.insertData(1000, 2000);
        this.selectWithMultiThread(2000);
    }

    @Test
    public void insertWithQueryUnsequenceTest() throws ClassNotFoundException {
        this.insertData(0, 1000);
        this.selectAndCount(1000);
        this.insertData(500, 1500);
        this.selectAndCount(1500);
        this.insertData(2000, 3000);
        this.selectAndCount(2500);
    }

    @Test
    public void insertWithQueryMultiThreadUnsequenceTest() throws ClassNotFoundException, InterruptedException {
        this.insertData(0, 1000);
        this.selectWithMultiThread(1000);
        this.insertData(500, 1500);
        this.selectWithMultiThread(1500);
        this.insertData(2000, 3000);
        this.selectWithMultiThread(2500);
    }

    @Test
    public void insertWithQueryFlushTest() throws ClassNotFoundException {
        this.insertData(0, 1000);
        this.selectAndCount(1000);
        this.flush();
        this.insertData(1000, 2000);
        this.selectAndCount(2000);
    }

    @Test
    public void flushWithQueryTest() throws ClassNotFoundException, InterruptedException {
        this.insertData(0, 1000);
        this.selectWithMultiThreadAndFlush(1000);
        this.insertData(500, 1500);
        this.selectWithMultiThreadAndFlush(1500);
    }

    @Test
    public void flushWithQueryUnorderTest() throws ClassNotFoundException, InterruptedException {
        this.insertData(0, 100);
        this.insertData(500, 600);
        this.selectWithMultiThread(200);
        this.insertData(200, 400);
        this.selectWithMultiThreadAndFlush(400);
        this.insertData(0, 1000);
        this.selectWithMultiThread(1000);
    }

    @Test
    public void flushWithQueryUnorderLargerTest() throws ClassNotFoundException, InterruptedException {
        this.insertData(0, 100);
        this.insertData(500, 600);
        this.selectWithMultiThread(200);
        this.insertData(200, 400);
        this.selectWithMultiThreadAndFlush(400);
        this.insertData(400, 700);
        this.selectWithMultiThreadAndFlush(600);
        this.insertData(0, 1000);
        this.selectWithMultiThread(1000);
        this.insertData(800, 1500);
        this.selectWithMultiThreadAndFlush(1500);
    }

    @Test
    public void insertWithQueryTogetherTest() throws InterruptedException {
        ArrayList<Thread> queryThreadList = new ArrayList<Thread>();
        Thread cur = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IoTDBInsertWithQueryIT.this.insertData(0, 200);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        queryThreadList.add(cur);
        cur.start();
        cur = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IoTDBInsertWithQueryIT.this.insertData(200, 400);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        queryThreadList.add(cur);
        cur.start();
        cur = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IoTDBInsertWithQueryIT.this.select();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        queryThreadList.add(cur);
        cur.start();
        cur = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IoTDBInsertWithQueryIT.this.insertData(100, 200);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        queryThreadList.add(cur);
        cur.start();
        cur = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IoTDBInsertWithQueryIT.this.select();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        queryThreadList.add(cur);
        cur.start();
        cur = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IoTDBInsertWithQueryIT.this.insertData(700, 900);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        queryThreadList.add(cur);
        cur.start();
        cur = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IoTDBInsertWithQueryIT.this.select();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        queryThreadList.add(cur);
        cur.start();
        cur = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IoTDBInsertWithQueryIT.this.flush();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        queryThreadList.add(cur);
        cur.start();
        cur = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IoTDBInsertWithQueryIT.this.insertData(500, 700);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        queryThreadList.add(cur);
        cur.start();
        cur = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IoTDBInsertWithQueryIT.this.select();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        queryThreadList.add(cur);
        cur.start();
        for (Thread thread : queryThreadList) {
            thread.join();
        }
    }

    private void selectWithMultiThreadAndFlush(final int res) throws InterruptedException {
        ArrayList<Thread> queryThreadList = new ArrayList<Thread>();
        for (int i = 0; i < 5; ++i) {
            Thread cur = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        IoTDBInsertWithQueryIT.this.selectAndCount(res);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            });
            if (i == 2) {
                Thread flushThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IoTDBInsertWithQueryIT.this.flush();
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                });
                flushThread.start();
                queryThreadList.add(flushThread);
            }
            queryThreadList.add(cur);
            cur.start();
        }
        for (Thread thread : queryThreadList) {
            thread.join();
        }
    }

    private void selectWithMultiThread(final int res) throws InterruptedException {
        ArrayList<Thread> queryThreadList = new ArrayList<Thread>();
        for (int i = 0; i < 5; ++i) {
            Thread cur = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        IoTDBInsertWithQueryIT.this.selectAndCount(res);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            });
            queryThreadList.add(cur);
            cur.start();
        }
        for (Thread thread : queryThreadList) {
            thread.join();
        }
    }

    private void insertData(int start, int end) throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (int time = start; time < end; ++time) {
                String sql = String.format("insert into root.fans.d0(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d0(timestamp,s1) values(%s,%s)", time, time % 40);
                statement.execute(sql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void flush() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("flush");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void selectAndCount(int res) throws ClassNotFoundException {
        String selectSql = "select * from root";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute(selectSql);
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                long before = -1L;
                while (resultSet.next()) {
                    long cur = Long.parseLong(resultSet.getString("Time"));
                    if (cur <= before) {
                        Assert.fail((String)"time order is wrong");
                    }
                    before = cur;
                    ++cnt;
                }
                Assert.assertEquals((long)res, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void select() throws ClassNotFoundException {
        String selectSql = "select * from root";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute(selectSql);
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                long before = -1L;
                while (resultSet.next()) {
                    long cur = Long.parseLong(resultSet.getString("Time"));
                    if (cur <= before) {
                        Assert.fail((String)"time order is wrong");
                    }
                    before = cur;
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

