/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBInsertNaNIT {
    private static final String CREATE_TEMPLATE_SQL = "CREATE TIMESERIES root.vehicle.%s.%s WITH DATATYPE=%s, ENCODING=%s, MAX_POINT_NUMBER=%d";
    private static final String INSERT_TEMPLATE_SQL = "insert into root.vehicle.%s(timestamp,%s) values(%d,%s)";
    private static final String INSERT_BRAND_NEW_TEMPLATE_SQL = "insert into root.cycle.%s(timestamp,%s) values(%d,%s)";
    private static List<String> sqls = new ArrayList<String>();
    private static final int TIMESTAMP = 10;
    private static final String VALUE = "NaN";
    private static final float DELTA_FLOAT = 1.0E-7f;
    private static final double DELTA_DOUBLE = 1.0E-7;

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        IoTDBInsertNaNIT.initCreateSQLStatement();
        EnvironmentUtils.envSetUp();
        IoTDBInsertNaNIT.insertData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    private static void initCreateSQLStatement() {
        int i;
        sqls.add("SET STORAGE GROUP TO root.vehicle.f0");
        sqls.add("SET STORAGE GROUP TO root.vehicle.d0");
        for (i = 0; i < 10; ++i) {
            sqls.add(String.format(CREATE_TEMPLATE_SQL, "f0", "s" + i + "rle", "FLOAT", "RLE", i));
            sqls.add(String.format(CREATE_TEMPLATE_SQL, "f0", "s" + i + "2f", "FLOAT", "TS_2DIFF", i));
            sqls.add(String.format(CREATE_TEMPLATE_SQL, "d0", "s" + i + "rle", "DOUBLE", "RLE", i));
            sqls.add(String.format(CREATE_TEMPLATE_SQL, "d0", "s" + i + "2f", "DOUBLE", "TS_2DIFF", i));
        }
        for (i = 0; i < 10; ++i) {
            sqls.add(String.format(INSERT_TEMPLATE_SQL, "f0", "s" + i + "rle", 10, VALUE));
            sqls.add(String.format(INSERT_TEMPLATE_SQL, "f0", "s" + i + "2f", 10, VALUE));
            sqls.add(String.format(INSERT_TEMPLATE_SQL, "d0", "s" + i + "rle", 10, VALUE));
            sqls.add(String.format(INSERT_TEMPLATE_SQL, "d0", "s" + i + "2f", 10, VALUE));
        }
    }

    private static void insertData() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : sqls) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void selectAllSQLTest() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select * from root.vehicle.*");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                while (resultSet.next()) {
                    Assert.assertEquals((Object)"10", (Object)resultSet.getString("Time"));
                    for (int i = 0; i < 10; ++i) {
                        Assert.assertEquals((float)Float.parseFloat(VALUE), (float)resultSet.getFloat(String.format("root.vehicle.%s.%s", "f0", "s" + i + "rle")), (float)1.0E-7f);
                        Assert.assertEquals((float)Float.parseFloat(VALUE), (float)resultSet.getFloat(String.format("root.vehicle.%s.%s", "f0", "s" + i + "2f")), (float)1.0E-7f);
                        Assert.assertEquals((double)Double.parseDouble(VALUE), (double)resultSet.getDouble(String.format("root.vehicle.%s.%s", "d0", "s" + i + "rle")), (double)1.0E-7);
                        Assert.assertEquals((double)Double.parseDouble(VALUE), (double)resultSet.getDouble(String.format("root.vehicle.%s.%s", "d0", "s" + i + "2f")), (double)1.0E-7);
                    }
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectTest() throws ClassNotFoundException {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TIMESERIES root.happy.device1.sensor1.temperature WITH DATATYPE=DOUBLE, ENCODING=RLE");
            statement.execute("INSERT INTO root.happy.device1.sensor1(timestamp,temperature) values(7925, NaN)");
            boolean hasResultSet = statement.execute("select * from root.happy.device1.sensor1");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                while (resultSet.next()) {
                    Assert.assertEquals((Object)"7925", (Object)resultSet.getString("Time"));
                    Assert.assertEquals((double)Double.parseDouble(VALUE), (double)resultSet.getDouble("root.happy.device1.sensor1.temperature"), (double)1.0E-7);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNaNValue() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute(String.format(INSERT_BRAND_NEW_TEMPLATE_SQL, "d0", "s02f", 10, VALUE));
            boolean hasResultSet = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResultSet);
            boolean exist = false;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    if (!resultSet.getString("timeseries").contains("root.cycle.d0.s0")) continue;
                    exist = true;
                }
            }
            Assert.assertTrue((boolean)exist);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

