/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBGroupByUnseqIT {
    private static String[] dataSet1 = new String[]{"SET STORAGE GROUP TO root.sg1", "CREATE TIMESERIES root.sg1.d1.s1 WITH DATATYPE=INT32, ENCODING=PLAIN", "INSERT INTO root.sg1.d1(time,s1) values(1, 1)", "INSERT INTO root.sg1.d1(time,s1) values(2, 2)", "INSERT INTO root.sg1.d1(time,s1) values(3, 3)", "INSERT INTO root.sg1.d1(time,s1) values(4, 4)", "INSERT INTO root.sg1.d1(time,s1) values(8, 8)", "INSERT INTO root.sg1.d1(time,s1) values(10, 10)", "INSERT INTO root.sg1.d1(time,s1) values(11, 11)", "INSERT INTO root.sg1.d1(time,s1) values(12, 12)", "flush", "INSERT INTO root.sg1.d1(time,s1) values(7, 7)", "INSERT INTO root.sg1.d1(time,s1) values(9, 9)", "flush"};
    private static String[] dataSet2 = new String[]{"SET STORAGE GROUP TO root.sg2", "CREATE TIMESERIES root.sg2.d1.s1 WITH DATATYPE=INT32, ENCODING=PLAIN", "INSERT INTO root.sg2.d1(time,s1) values(1, 1)", "INSERT INTO root.sg2.d1(time,s1) values(10, 10)", "flush", "INSERT INTO root.sg2.d1(time,s1) values(19, 19)", "INSERT INTO root.sg2.d1(time,s1) values(30, 30)", "flush", "INSERT INTO root.sg2.d1(time,s1) values(5, 5)", "INSERT INTO root.sg2.d1(time,s1) values(15, 15)", "INSERT INTO root.sg2.d1(time,s1) values(26, 26)", "INSERT INTO root.sg2.d1(time,s1) values(30, 30)", "flush"};
    private boolean enableUnseqCompaction;
    private int maxNumberOfPointsInPage;

    @Before
    public void setUp() throws Exception {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        EnvironmentUtils.closeStatMonitor();
        this.enableUnseqCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(false);
        this.maxNumberOfPointsInPage = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(4);
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(this.enableUnseqCompaction);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(this.maxNumberOfPointsInPage);
    }

    @Test
    public void test1() {
        String[] retArray1 = new String[]{"1,3", "4,1", "7,3", "10,3"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : dataSet1) {
                statement.execute(sql);
            }
            boolean hasResultSet = statement.execute("select count(s1) from root.sg1.d1 group by ([1, 13), 3ms)");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.count("root.sg1.d1.s1"));
                    Assert.assertEquals((Object)retArray1[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray1.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2() {
        String[] retArray1 = new String[]{"5,1", "10,1", "15,2", "20,0", "25,1"};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(2);
            for (String sql : dataSet2) {
                statement.execute(sql);
            }
            boolean hasResultSet = statement.execute("select count(s1) from root.sg2.d1 group by ([5, 30), 5ms)");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.count("root.sg2.d1.s1"));
                    Assert.assertEquals((Object)retArray1[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray1.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }
}

