/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBGroupByMonthIT {
    private static final String TIMESTAMP_STR = "Time";
    private final DateFormat df = new SimpleDateFormat("MM/dd/yyyy:HH:mm:ss");

    @Before
    public void setUp() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.NO_COMPACTION);
        this.df.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        this.prepareData();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
    }

    @Test
    public void groupByNaturalMonth1() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] retArray1 = new String[]{"10/31/2020:00:00:00", "30.0", "11/30/2020:00:00:00", "31.0", "12/31/2020:00:00:00", "31.0", "01/31/2021:00:00:00", "28.0", "02/28/2021:00:00:00", "1.0"};
            boolean hasResultSet = statement.execute("select sum(temperature) from root.sg1.d1 GROUP BY ([1604102400000, 1614556800000), 1mo, 1mo)");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String time = resultSet.getString(TIMESTAMP_STR);
                    String ans = resultSet.getString(TestConstant.sum("root.sg1.d1.temperature"));
                    Assert.assertEquals((Object)retArray1[cnt++], (Object)this.df.format(Long.parseLong(time)));
                    Assert.assertEquals((Object)retArray1[cnt++], (Object)ans);
                }
                Assert.assertEquals((long)retArray1.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void groupByNaturalMonth2() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] retArray1 = new String[]{"10/31/2020:00:00:00", "10.0", "11/30/2020:00:00:00", "10.0", "12/31/2020:00:00:00", "10.0", "01/31/2021:00:00:00", "10.0", "02/28/2021:00:00:00", "1.0"};
            boolean hasResultSet = statement.execute("select sum(temperature) from root.sg1.d1 GROUP BY ([1604102400000, 1614556800000), 10d, 1mo)");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String time = resultSet.getString(TIMESTAMP_STR);
                    String ans = resultSet.getString(TestConstant.sum("root.sg1.d1.temperature"));
                    Assert.assertEquals((Object)retArray1[cnt++], (Object)this.df.format(Long.parseLong(time)));
                    Assert.assertEquals((Object)retArray1[cnt++], (Object)ans);
                }
                Assert.assertEquals((long)retArray1.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void groupByNaturalMonth3() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select sum(temperature) from root.sg1.d1 GROUP BY ([1604102400000, 1606694400000), 1mo)");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            ResultSet resultSet = statement.getResultSet();
            while (resultSet.next()) {
                ++cnt;
            }
            Assert.assertEquals((long)1L, (long)cnt);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void groupByNaturalMonth4() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] retArray1 = new String[]{"01/31/2021:00:00:00", "28.0", "02/28/2021:00:00:00", "31.0"};
            boolean hasResultSet = statement.execute("select sum(temperature) from root.sg1.d1 GROUP BY ([1612051200000, 1617148800000), 1mo)");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String time = resultSet.getString(TIMESTAMP_STR);
                    String ans = resultSet.getString(TestConstant.sum("root.sg1.d1.temperature"));
                    Assert.assertEquals((Object)retArray1[cnt++], (Object)this.df.format(Long.parseLong(time)));
                    Assert.assertEquals((Object)retArray1[cnt++], (Object)ans);
                }
                Assert.assertEquals((long)retArray1.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void groupByNaturalMonth5() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("select sum(temperature) from root.sg1.d1 GROUP BY ([1612051200000, 1617148800000), 1mo) order by time desc");
            Assert.fail((String)"No Exception thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("doesn't support order by time desc now."));
        }
    }

    @Test
    public void groupByNaturalMonth6() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select sum(temperature) from root.sg1.d1 GROUP BY ([now() - 1mo, now()), 1d)");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString(TestConstant.sum("root.sg1.d1.temperature"));
                    if (!ans.equals("0.0")) continue;
                    ++cnt;
                }
                Assert.assertEquals((long)30L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void prepareData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            long startTime = 1604102400000L;
            long endTime = 1617148800000L;
            for (long i = startTime; i <= endTime; i += 86400000L) {
                statement.execute("insert into root.sg1.d1(timestamp, temperature) values (" + i + ", 1)");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

