/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBGroupByFillWithRangeIT {
    private static String[] dataSet1 = new String[]{"SET STORAGE GROUP TO root.ln.wf01.wt01", "CREATE TIMESERIES root.ln.wf01.wt01.temperature WITH DATATYPE=INT32, ENCODING=PLAIN", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature) values(1, 1)", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature) values(6, 6)", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature) values(11, 11)", "flush"};

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(1000L);
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        this.prepareData();
    }

    @After
    public void tearDown() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(86400L);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void previousFillTestWithTimeRange() {
        String[] retArray = new String[]{"5,null", "7,6", "9,6", "11,11"};
        String[] retArray2 = new String[]{"5,null", "7,6", "9,null", "11,11"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ((3, 11], 2ms) FILL(int32[previous, 2ms])");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ((3, 11], 2ms) FILL(int32[previous, 1ms])");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray2[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray2.length, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ((3, 11], 2ms) FILL(ALL[previousUntilLast, 1ms])");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray2[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray2.length, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ((3, 11], 2ms) FILL(ALL[previousUntilLast, 1ms]) order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray2[retArray2.length - cnt - 1], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray2.length, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void prepareData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : dataSet1) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

