/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBGroupByFillIT {
    private static String[] dataSet1 = new String[]{"SET STORAGE GROUP TO root.ln.wf01.wt01", "CREATE TIMESERIES root.ln.wf01.wt01.status WITH DATATYPE=BOOLEAN, ENCODING=PLAIN", "CREATE TIMESERIES root.ln.wf01.wt01.temperature WITH DATATYPE=INT32, ENCODING=PLAIN", "CREATE TIMESERIES root.ln.wf01.wt01.hardware WITH DATATYPE=DOUBLE, ENCODING=PLAIN", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(10, 21, false, 11.1)", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(12, 23, true, 22.3)", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(14, 25, false, 33.5)", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(29, 26, false, 33.2)", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(36, 29, false, 44.7)", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(37, 30, false, 55.8)", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(39, 40, false, 33.0)", "flush"};

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(1000L);
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        this.prepareData();
    }

    @After
    public void tearDown() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(86400L);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void previousTest1() {
        String[] retArray = new String[]{"17,25", "22,25", "27,26", "32,29", "37,40", "42,40", "47,40"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ([17, 48), 5ms) FILL(int32[previous])");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ([17, 48), 5ms) FILL(int32[previous]) order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[retArray.length - cnt - 1], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void previousTest2() {
        Statement statement;
        Connection connection;
        try {
            connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
            try {
                statement = connection.createStatement();
                try {
                    statement.execute("select count(temperature) from root.ln.wf01.wt01 GROUP BY ([17, 48), 5ms) FILL(int32[previous])");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (IoTDBSQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Group By Fill only support last_value function"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
            try {
                statement = connection.createStatement();
                try {
                    statement.execute("select count(temperature) from root.ln.wf01.wt01 GROUP BY ([17, 48), 5ms) FILL(int32[previous]) order by time desc");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (IoTDBSQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Group By Fill only support last_value function"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void previousTest3() {
        String[] retArray = new String[]{"2,null", "7,21", "12,25", "17,25", "22,25", "27,26", "32,29", "37,40", "42,40", "47,40"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ([2, 48), 5ms) FILL(int32[previous])");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ([2, 48), 5ms) FILL(int32[previous]) order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[retArray.length - cnt - 1], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void previousTest4() {
        String[] retArray = new String[]{"2,null,null", "7,21,11.1", "12,25,33.5", "17,25,33.5", "22,25,33.5", "27,26,33.2", "32,29,44.7", "37,40,33.0", "42,40,33.0", "47,40,33.0"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select last_value(temperature), last_value(hardware) from root.ln.wf01.wt01 GROUP BY ([2, 48), 5ms) FILL(int32[previous], double[previous])");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature")) + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.hardware"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            hasResultSet = statement.execute("select last_value(temperature), last_value(hardware) from root.ln.wf01.wt01 GROUP BY ([2, 48), 5ms) FILL(int32[previous], double[previous]) order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature")) + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.hardware"));
                    Assert.assertEquals((Object)retArray[retArray.length - cnt - 1], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void leftORightCPreviousTest() {
        String[] retArray = new String[]{"10,21", "15,25", "20,25", "25,25", "30,26", "35,26", "40,40"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ((5, 40], 5ms) FILL(int32[previous])");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ((5, 40], 5ms) FILL(int32[previous]) order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[retArray.length - cnt - 1], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void previousAllTest() {
        String[] retArray = new String[]{"2,null,null", "7,21,11.1", "12,25,33.5", "17,25,33.5", "22,25,33.5", "27,26,33.2", "32,29,44.7", "37,40,33.0", "42,40,33.0", "47,40,33.0"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select last_value(temperature), last_value(hardware) from root.ln.wf01.wt01 GROUP BY ([2, 48), 5ms) FILL(ALL[previous])");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature")) + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.hardware"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            hasResultSet = statement.execute("select last_value(temperature), last_value(hardware) from root.ln.wf01.wt01 GROUP BY ([2, 48), 5ms) FILL(ALL[previous]) order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature")) + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.hardware"));
                    Assert.assertEquals((Object)retArray[retArray.length - cnt - 1], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void previousUntilLastTest1() {
        String[] retArray = new String[]{"17,25", "22,25", "27,26", "32,29", "37,40", "42,null", "47,null"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ([17, 48), 5ms) FILL(int32[previousUntilLast])");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ([17, 48), 5ms) FILL(int32[previousUntilLast]) order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[retArray.length - cnt - 1], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void previousUntilLastTest2() {
        Statement statement;
        Connection connection;
        try {
            connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
            try {
                statement = connection.createStatement();
                try {
                    statement.execute("select count(temperature) from root.ln.wf01.wt01 GROUP BY ([17, 48), 5ms) FILL(int32[previousUntilLast])");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (IoTDBSQLException e) {
            System.out.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("Group By Fill only support last_value function"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
            try {
                statement = connection.createStatement();
                try {
                    statement.execute("select count(temperature) from root.ln.wf01.wt01 GROUP BY ([17, 48), 5ms) FILL(int32[previousUntilLast]) order by time desc");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (IoTDBSQLException e) {
            System.out.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("Group By Fill only support last_value function"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void previousUntilLastTest3() {
        String[] retArray = new String[]{"2,null", "7,21", "12,25", "17,25", "22,25", "27,26", "32,29", "37,40", "42,null", "47,null"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ([2, 48), 5ms) FILL(int32[previousUntilLast])");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ([2, 48), 5ms) FILL(int32[previousUntilLast])order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[retArray.length - cnt - 1], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void previousUntilLastTest4() {
        String[] retArray = new String[]{"2,null,null", "7,21,11.1", "12,25,33.5", "17,25,33.5", "22,25,33.5", "27,26,33.2", "32,29,44.7", "37,40,33.0", "42,null,null", "47,null,null"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select last_value(temperature), last_value(hardware) from root.ln.wf01.wt01 GROUP BY ([2, 48), 5ms) FILL(int32[previousUntilLast], double[previousUntilLast])");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature")) + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.hardware"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            hasResultSet = statement.execute("select last_value(temperature), last_value(hardware) from root.ln.wf01.wt01 GROUP BY ([2, 48), 5ms) FILL(int32[previousUntilLast], double[previousUntilLast]) order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature")) + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.hardware"));
                    Assert.assertEquals((Object)retArray[retArray.length - cnt - 1], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void previousUntilLastTest5() {
        String[] retArray = new String[]{"17,25", "22,25", "27,26", "32,29", "37,40", "42,null", "47,null"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ([17, 48), 5ms) FILL(float[previousUntilLast])");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ([17, 48), 5ms) FILL(float[previousUntilLast]) order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[retArray.length - cnt - 1], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void leftORightCPreviousUntilLastTest() {
        String[] retArray = new String[]{"9,null", "14,25", "19,25", "24,25", "29,26", "34,26", "39,40", "44,null"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ((4, 44], 5ms) FILL(int32[previousUntilLast])");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void previousUntilLastAllTest() {
        String[] retArray = new String[]{"2,null,null", "7,21,11.1", "12,25,33.5", "17,25,33.5", "22,25,33.5", "27,26,33.2", "32,29,44.7", "37,40,33.0", "42,null,null", "47,null,null"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select last_value(temperature), last_value(hardware) from root.ln.wf01.wt01 GROUP BY ([2, 48), 5ms) FILL(ALL[previousUntilLast])");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature")) + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.hardware"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void usingLimit() {
        String[] retArray = new String[]{"27,26", "32,29", "37,40", "42,40", "47,40"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select last_value(temperature) from root.ln.wf01.wt01 GROUP BY ([17, 48), 5ms) FILL(int32[previous]) limit 5 offset 2");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString(TestConstant.last_value("root.ln.wf01.wt01.temperature"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void TestGroupByFillWithoutAggregationFunc() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("select temperature from root.ln.wf01.wt01 group by ([0, 100), 5ms) FILL(int32[previous])");
            Assert.fail((String)"No expected exception thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("There is no aggregation function with group by query"));
        }
    }

    private void prepareData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : dataSet1) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

