/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBFilePathUtilsIT {
    private static Connection connection;
    private static final Logger logger;

    @BeforeClass
    public static void setUp() {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
    }

    private void insertData() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        Statement statement = connection.createStatement();
        statement.execute("insert into root.sg1.wf01.wt01(timestamp, status) values (1000, true)");
        statement.execute("insert into root.sg1.wf01.wt01(timestamp, status) values (2000, true)");
        statement.execute("insert into root.sg1.wf01.wt01(timestamp, status) values (3000, true)");
        statement.execute("flush");
        statement.close();
    }

    @Test
    public void splitTsFilePathTest() throws StorageEngineException, SQLException, ClassNotFoundException {
        this.insertData();
        String storageGroupName = "root.sg1";
        PartialPath sgPath = null;
        try {
            sgPath = new PartialPath(storageGroupName);
        }
        catch (IllegalPathException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)sgPath);
        List tsFileResources = StorageEngine.getInstance().getProcessor(sgPath).getSequenceFileTreeSet();
        Assert.assertNotNull((Object)tsFileResources);
        for (TsFileResource tsFileResource : tsFileResources) {
            String sgName = FilePathUtils.getLogicalStorageGroupName((TsFileResource)tsFileResource);
            Assert.assertEquals((Object)storageGroupName, (Object)sgName);
            Pair logicalSgNameAndTimePartitionIdPair = FilePathUtils.getLogicalSgNameAndTimePartitionIdPair((TsFileResource)tsFileResource);
            Assert.assertEquals((Object)storageGroupName, (Object)logicalSgNameAndTimePartitionIdPair.left);
        }
    }

    private static void close() {
        if (Objects.nonNull(connection)) {
            try {
                connection.close();
            }
            catch (Exception e) {
                logger.error("close the connection failed,", (Throwable)e);
            }
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        IoTDBFilePathUtilsIT.close();
        EnvironmentUtils.cleanEnv();
    }

    static {
        logger = LoggerFactory.getLogger(IoTDBFilePathUtilsIT.class);
    }
}

