/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.timegenerator.ServerTimeGenerator;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.ValueFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBEngineTimeGeneratorIT {
    private static TSFileConfig tsFileConfig = TSFileDescriptor.getInstance().getConfig();
    private static int maxNumberOfPointsInPage;
    private static int pageSizeInByte;
    private static int groupSizeInByte;
    private static int count;
    private static int count2;

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        maxNumberOfPointsInPage = tsFileConfig.getMaxNumberOfPointsInPage();
        pageSizeInByte = tsFileConfig.getPageSizeInByte();
        groupSizeInByte = tsFileConfig.getGroupSizeInByte();
        tsFileConfig.setMaxNumberOfPointsInPage(100);
        tsFileConfig.setPageSizeInByte(0x9600000);
        tsFileConfig.setGroupSizeInByte(0x6400000);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold(0x6400000L);
        EnvironmentUtils.envSetUp();
        IoTDBEngineTimeGeneratorIT.insertData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        tsFileConfig.setMaxNumberOfPointsInPage(maxNumberOfPointsInPage);
        tsFileConfig.setPageSizeInByte(pageSizeInByte);
        tsFileConfig.setGroupSizeInByte(groupSizeInByte);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold((long)groupSizeInByte);
        EnvironmentUtils.cleanEnv();
    }

    private static void insertData() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            long time;
            for (String sql : TestConstant.create_sql) {
                statement.execute(sql);
            }
            for (time = 300L; time < 1000L; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time % 17L);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time % 29L);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, time % 31L);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s3) values(%s,'%s')", time, TestConstant.stringValue[(int)time % 5]);
                statement.execute(sql);
                if (IoTDBEngineTimeGeneratorIT.satisfyTimeFilter1(time)) {
                    ++count;
                }
                if (!IoTDBEngineTimeGeneratorIT.satisfyTimeFilter2(time)) continue;
                ++count2;
            }
            statement.execute("FLUSH");
            for (time = 1200L; time < 1500L; ++time) {
                String sql = null;
                if (time % 2L == 0L) {
                    sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time % 17L);
                    statement.execute(sql);
                    sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time % 29L);
                    statement.execute(sql);
                    if (IoTDBEngineTimeGeneratorIT.satisfyTimeFilter1(time)) {
                        ++count;
                    }
                }
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, time % 31L);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s3) values(%s,'%s')", time, TestConstant.stringValue[(int)time % 5]);
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static boolean satisfyTimeFilter1(long time) {
        return time % 17L >= 14L && time > 500L;
    }

    private static boolean satisfyTimeFilter2(long time) {
        return !(time % 17L < 5L && time <= 900L || !((double)(time % 31L) >= 11.5) && time <= 900L);
    }

    @Test
    public void testOneSeriesWithValueAndTimeFilter() throws IOException, StorageEngineException, IllegalPathException, QueryProcessException {
        PartialPath pd0s0 = new PartialPath("root.vehicle.d0.s0");
        ValueFilter.ValueGtEq valueGtEq = ValueFilter.gtEq((Comparable)Integer.valueOf(14));
        TimeFilter.TimeGt timeGt = TimeFilter.gt((long)500L);
        SingleSeriesExpression singleSeriesExpression = new SingleSeriesExpression((Path)pd0s0, (Filter)FilterFactory.and((Filter)valueGtEq, (Filter)timeGt));
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        paths.add(pd0s0);
        queryPlan.setDeduplicatedPaths(paths);
        queryPlan.setExpression((IExpression)singleSeriesExpression);
        ServerTimeGenerator timeGenerator = new ServerTimeGenerator(EnvironmentUtils.TEST_QUERY_CONTEXT, queryPlan);
        int cnt = 0;
        while (timeGenerator.hasNext()) {
            long time = timeGenerator.next();
            Assert.assertTrue((boolean)IoTDBEngineTimeGeneratorIT.satisfyTimeFilter1(time));
            ++cnt;
        }
        Assert.assertEquals((long)count, (long)cnt);
    }

    @Test
    public void testEmptySeriesWithValueFilter() throws IOException, StorageEngineException, IllegalPathException, QueryProcessException {
        PartialPath pd1s0 = new PartialPath("root.vehicle.d1.s0");
        ValueFilter.ValueGtEq valueGtEq = ValueFilter.gtEq((Comparable)Integer.valueOf(5));
        SingleSeriesExpression singleSeriesExpression = new SingleSeriesExpression((Path)pd1s0, (Filter)valueGtEq);
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        paths.add(pd1s0);
        queryPlan.setDeduplicatedPaths(paths);
        queryPlan.setExpression((IExpression)singleSeriesExpression);
        ServerTimeGenerator timeGenerator = new ServerTimeGenerator(EnvironmentUtils.TEST_QUERY_CONTEXT, queryPlan);
        int cnt = 0;
        while (timeGenerator.hasNext()) {
            ++cnt;
        }
        Assert.assertEquals((long)0L, (long)cnt);
    }

    @Test
    public void testMultiSeriesWithValueFilterAndTimeFilter() throws IOException, StorageEngineException, IllegalPathException, QueryProcessException {
        System.out.println("Test >>> root.vehicle.d0.s0 >= 5 && root.vehicle.d0.s2 >= 11.5 || time > 900");
        PartialPath pd0s0 = new PartialPath("root.vehicle.d0.s0");
        PartialPath pd0s2 = new PartialPath("root.vehicle.d0.s2");
        ValueFilter.ValueGtEq valueGtEq5 = ValueFilter.gtEq((Comparable)Integer.valueOf(5));
        ValueFilter.ValueGtEq valueGtEq11 = ValueFilter.gtEq((Comparable)Float.valueOf(11.5f));
        TimeFilter.TimeGt timeGt = TimeFilter.gt((long)900L);
        SingleSeriesExpression singleSeriesExpression1 = new SingleSeriesExpression((Path)pd0s0, (Filter)FilterFactory.or((Filter)valueGtEq5, (Filter)timeGt));
        SingleSeriesExpression singleSeriesExpression2 = new SingleSeriesExpression((Path)pd0s2, (Filter)FilterFactory.or((Filter)valueGtEq11, (Filter)timeGt));
        BinaryExpression.AndExpression andExpression = BinaryExpression.and((IExpression)singleSeriesExpression1, (IExpression)singleSeriesExpression2);
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        paths.add(pd0s0);
        paths.add(pd0s2);
        queryPlan.setDeduplicatedPaths(paths);
        queryPlan.setExpression((IExpression)andExpression);
        ServerTimeGenerator timeGenerator = new ServerTimeGenerator(EnvironmentUtils.TEST_QUERY_CONTEXT, queryPlan);
        int cnt = 0;
        while (timeGenerator.hasNext()) {
            long time = timeGenerator.next();
            Assert.assertTrue((boolean)IoTDBEngineTimeGeneratorIT.satisfyTimeFilter2(time));
            ++cnt;
        }
        Assert.assertEquals((long)count2, (long)cnt);
    }

    static {
        count = 0;
        count2 = 150;
    }
}

