/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBEncodingIT {
    private static int partitionInterval = 100;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        TSFileDescriptor.getInstance().getConfig().setTimeEncoder("REGULAR");
        StorageEngine.setEnablePartition((boolean)true);
        StorageEngine.setTimePartitionInterval((long)partitionInterval);
        IoTDBEncodingIT.insertData();
    }

    @After
    public void tearDown() throws Exception {
        StorageEngine.setEnablePartition((boolean)false);
        StorageEngine.setTimePartitionInterval((long)-1L);
        TSFileDescriptor.getInstance().getConfig().setTimeEncoder("TS_2DIFF");
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testSetEncodingRegularFailed() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TIMESERIES root.test1.s0 WITH DATATYPE=INT64,ENCODING=REGULAR");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)303L, (long)e.getErrorCode());
        }
    }

    @Test
    public void testSetTimeEncoderRegularAndValueEncoderTS_2DIFF() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TIMESERIES root.db_0.tab0.salary WITH DATATYPE=INT64,ENCODING=TS_2DIFF");
            statement.execute("insert into root.db_0.tab0(time,salary) values(1,1100)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(2,1200)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(3,1300)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(4,1400)");
            statement.execute("flush");
            int[] result = new int[]{1100, 1200, 1300, 1400};
            try (ResultSet resultSet = statement.executeQuery("select * from root.db_0.tab0");){
                int index = 0;
                while (resultSet.next()) {
                    int salary = resultSet.getInt("root.db_0.tab0.salary");
                    Assert.assertEquals((long)result[index], (long)salary);
                    ++index;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSetTimeEncoderRegularAndValueEncoderTS_2DIFFOutofOrder() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TIMESERIES root.db_0.tab0.salary WITH DATATYPE=INT64,ENCODING=TS_2DIFF");
            statement.execute("insert into root.db_0.tab0(time,salary) values(1,1200)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(2,1100)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(7,1000)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(4,2200)");
            statement.execute("flush");
            int[] result = new int[]{1200, 1100, 2200, 1000};
            try (ResultSet resultSet = statement.executeQuery("select * from root.db_0.tab0");){
                int index = 0;
                while (resultSet.next()) {
                    int salary = resultSet.getInt("root.db_0.tab0.salary");
                    Assert.assertEquals((long)result[index], (long)salary);
                    ++index;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSetTimeEncoderRegularAndValueEncoderRLE() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TIMESERIES root.db_0.tab0.salary WITH DATATYPE=INT64,ENCODING=RLE");
            statement.execute("insert into root.db_0.tab0(time,salary) values(1,1100)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(2,1200)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(3,1300)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(4,1400)");
            statement.execute("flush");
            int[] result = new int[]{1100, 1200, 1300, 1400};
            try (ResultSet resultSet = statement.executeQuery("select * from root.db_0.tab0");){
                int index = 0;
                while (resultSet.next()) {
                    int salary = resultSet.getInt("root.db_0.tab0.salary");
                    Assert.assertEquals((long)result[index], (long)salary);
                    ++index;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSetTimeEncoderRegularAndValueEncoderRLEOutofOrder() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TIMESERIES root.db_0.tab0.salary WITH DATATYPE=INT64,ENCODING=RLE");
            statement.execute("insert into root.db_0.tab0(time,salary) values(1,1200)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(2,1100)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(7,1000)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(4,2200)");
            statement.execute("flush");
            int[] result = new int[]{1200, 1100, 2200, 1000};
            try (ResultSet resultSet = statement.executeQuery("select * from root.db_0.tab0");){
                int index = 0;
                while (resultSet.next()) {
                    int salary = resultSet.getInt("root.db_0.tab0.salary");
                    Assert.assertEquals((long)result[index], (long)salary);
                    ++index;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSetTimeEncoderRegularAndValueEncoderGORILLA() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TIMESERIES root.db_0.tab0.salary WITH DATATYPE=INT64,ENCODING=GORILLA");
            statement.execute("insert into root.db_0.tab0(time,salary) values(1,1100)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(2,1200)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(3,1300)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(4,1400)");
            statement.execute("flush");
            int[] result = new int[]{1100, 1200, 1300, 1400};
            try (ResultSet resultSet = statement.executeQuery("select * from root.db_0.tab0");){
                int index = 0;
                while (resultSet.next()) {
                    int salary = resultSet.getInt("root.db_0.tab0.salary");
                    Assert.assertEquals((long)result[index], (long)salary);
                    ++index;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSetTimeEncoderRegularAndValueEncoderGORILLAOutofOrder() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TIMESERIES root.db_0.tab0.salary WITH DATATYPE=INT64,ENCODING=GORILLA");
            statement.execute("insert into root.db_0.tab0(time,salary) values(1,1200)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(2,1100)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(7,1000)");
            statement.execute("insert into root.db_0.tab0(time,salary) values(4,2200)");
            statement.execute("flush");
            int[] result = new int[]{1200, 1100, 2200, 1000};
            try (ResultSet resultSet = statement.executeQuery("select * from root.db_0.tab0");){
                int index = 0;
                while (resultSet.next()) {
                    int salary = resultSet.getInt("root.db_0.tab0.salary");
                    Assert.assertEquals((long)result[index], (long)salary);
                    ++index;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void insertData() throws ClassNotFoundException {
        ArrayList<String> sqls = new ArrayList<String>(Arrays.asList("SET STORAGE GROUP TO root.test1", "SET STORAGE GROUP TO root.test2", "CREATE TIMESERIES root.test1.s0 WITH DATATYPE=INT64,ENCODING=PLAIN", "CREATE TIMESERIES root.test2.s0 WITH DATATYPE=INT64,ENCODING=PLAIN"));
        for (int i = 0; i < 10; ++i) {
            int j;
            for (j = 1; j <= 2; ++j) {
                sqls.add(String.format("INSERT INTO root.test%d(timestamp, s0) VALUES (%d, %d)", j, i * partitionInterval + 50, i * partitionInterval + 50));
            }
            if (i < 9) {
                sqls.add("FLUSH");
            }
            for (j = 1; j <= 2; ++j) {
                sqls.add(String.format("INSERT INTO root.test%d(timestamp, s0) VALUES (%d, %d)", j, i * partitionInterval, i * partitionInterval));
            }
            sqls.add("MERGE");
            if (i >= 9) continue;
            sqls.add("FLUSH");
        }
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : sqls) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

