/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBDisableAlignIT {
    private static String[] sqls = new String[]{"SET STORAGE GROUP TO root.vehicle", "SET STORAGE GROUP TO root.other", "CREATE TIMESERIES root.vehicle.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s1 WITH DATATYPE=INT64, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s2 WITH DATATYPE=FLOAT, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s3 WITH DATATYPE=TEXT, ENCODING=PLAIN", "CREATE TIMESERIES root.vehicle.d0.s4 WITH DATATYPE=BOOLEAN, ENCODING=PLAIN", "CREATE TIMESERIES root.vehicle.d1.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.other.d1.s0 WITH DATATYPE=FLOAT, ENCODING=RLE", "insert into root.vehicle.d0(timestamp,s0) values(1,101)", "insert into root.vehicle.d0(timestamp,s0) values(2,198)", "insert into root.vehicle.d0(timestamp,s0) values(100,99)", "insert into root.vehicle.d0(timestamp,s0) values(101,99)", "insert into root.vehicle.d0(timestamp,s0) values(102,80)", "insert into root.vehicle.d0(timestamp,s0) values(103,99)", "insert into root.vehicle.d0(timestamp,s0) values(104,90)", "insert into root.vehicle.d0(timestamp,s0) values(105,99)", "insert into root.vehicle.d0(timestamp,s0) values(106,99)", "insert into root.vehicle.d0(timestamp,s0) values(2,10000)", "insert into root.vehicle.d0(timestamp,s0) values(50,10000)", "insert into root.vehicle.d0(timestamp,s0) values(1000,22222)", "insert into root.vehicle.d0(timestamp,s1) values(1,1101)", "insert into root.vehicle.d0(timestamp,s1) values(2,198)", "insert into root.vehicle.d0(timestamp,s1) values(100,199)", "insert into root.vehicle.d0(timestamp,s1) values(101,199)", "insert into root.vehicle.d0(timestamp,s1) values(102,180)", "insert into root.vehicle.d0(timestamp,s1) values(103,199)", "insert into root.vehicle.d0(timestamp,s1) values(104,190)", "insert into root.vehicle.d0(timestamp,s1) values(105,199)", "insert into root.vehicle.d0(timestamp,s1) values(2,40000)", "insert into root.vehicle.d0(timestamp,s1) values(50,50000)", "insert into root.vehicle.d0(timestamp,s1) values(1000,55555)", "insert into root.vehicle.d0(timestamp,s2) values(1000,55555)", "insert into root.vehicle.d0(timestamp,s2) values(2,2.22)", "insert into root.vehicle.d0(timestamp,s2) values(3,3.33)", "insert into root.vehicle.d0(timestamp,s2) values(4,4.44)", "insert into root.vehicle.d0(timestamp,s2) values(102,10.00)", "insert into root.vehicle.d0(timestamp,s2) values(105,11.11)", "insert into root.vehicle.d0(timestamp,s2) values(1000,1000.11)", "insert into root.vehicle.d0(timestamp,s3) values(60,'aaaaa')", "insert into root.vehicle.d0(timestamp,s3) values(70,'bbbbb')", "insert into root.vehicle.d0(timestamp,s3) values(80,'ccccc')", "insert into root.vehicle.d0(timestamp,s3) values(101,'ddddd')", "insert into root.vehicle.d0(timestamp,s3) values(102,'fffff')", "insert into root.vehicle.d1(timestamp,s0) values(1,999)", "insert into root.vehicle.d1(timestamp,s0) values(1000,888)", "insert into root.vehicle.d0(timestamp,s1) values(2000-01-01T08:00:00+08:00, 100)", "insert into root.vehicle.d0(timestamp,s3) values(2000-01-01T08:00:00+08:00, 'good')", "insert into root.vehicle.d0(timestamp,s4) values(100, false)", "insert into root.vehicle.d0(timestamp,s4) values(100, true)", "insert into root.other.d1(timestamp,s0) values(2, 3.14)"};

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        IoTDBDisableAlignIT.insertData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    private static void insertData() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : sqls) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void selectTest() throws ClassNotFoundException {
        String[] retArray = new String[]{"1,101,1,1101,2,2.22,60,aaaaa,100,true,1,999,", "2,10000,2,40000,3,3.33,70,bbbbb,null,null,1000,888,", "50,10000,50,50000,4,4.44,80,ccccc,null,null,null,null,", "100,99,100,199,102,10.0,101,ddddd,null,null,null,null,", "101,99,101,199,105,11.11,102,fffff,null,null,null,null,", "102,80,102,180,1000,1000.11,946684800000,good,null,null,null,null,", "103,99,103,199,null,null,null,null,null,null,null,null,", "104,90,104,190,null,null,null,null,null,null,null,null,", "105,99,105,199,null,null,null,null,null,null,null,null,", "106,99,1000,55555,null,null,null,null,null,null,null,null,", "1000,22222,946684800000,100,null,null,null,null,null,null,null,null,"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select * from root.vehicle disable align");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                List<Integer> actualIndexToExpectedIndexList = this.checkHeader(resultSetMetaData, "Timeroot.vehicle.d0.s0,root.vehicle.d0.s0,Timeroot.vehicle.d0.s1,root.vehicle.d0.s1,Timeroot.vehicle.d0.s2,root.vehicle.d0.s2,Timeroot.vehicle.d0.s3,root.vehicle.d0.s3,Timeroot.vehicle.d0.s4,root.vehicle.d0.s4,Timeroot.vehicle.d1.s0,root.vehicle.d1.s0,", new int[]{4, -5, 6, 12, 16, 4});
                int cnt = 0;
                while (resultSet.next()) {
                    String[] expectedStrings = retArray[cnt].split(",");
                    StringBuilder expectedBuilder = new StringBuilder();
                    StringBuilder actualBuilder = new StringBuilder();
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        actualBuilder.append(resultSet.getString(i)).append(",");
                        expectedBuilder.append(expectedStrings[actualIndexToExpectedIndexList.get(i - 1)]).append(",");
                    }
                    Assert.assertEquals((Object)expectedBuilder.toString(), (Object)actualBuilder.toString());
                    ++cnt;
                }
                Assert.assertEquals((long)11L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectWithDuplicatedPathsTest() throws ClassNotFoundException {
        String[] retArray = new String[]{"1,101,1,101,1,1101,", "2,10000,2,10000,2,40000,", "50,10000,50,10000,50,50000,", "100,99,100,99,100,199,", "101,99,101,99,101,199,", "102,80,102,80,102,180,", "103,99,103,99,103,199,", "104,90,104,90,104,190,", "105,99,105,99,105,199,", "106,99,106,99,1000,55555,", "1000,22222,1000,22222,946684800000,100,"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select s0,s0,s1 from root.vehicle.d0 disable align");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                List<Integer> actualIndexToExpectedIndexList = this.checkHeader(resultSetMetaData, "Timeroot.vehicle.d0.s0,root.vehicle.d0.s0,Timeroot.vehicle.d0.s0,root.vehicle.d0.s0,Timeroot.vehicle.d0.s1,root.vehicle.d0.s1,", new int[]{4, 4, -5});
                int cnt = 0;
                while (resultSet.next()) {
                    String[] expectedStrings = retArray[cnt].split(",");
                    StringBuilder expectedBuilder = new StringBuilder();
                    StringBuilder actualBuilder = new StringBuilder();
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        actualBuilder.append(resultSet.getString(i)).append(",");
                        expectedBuilder.append(expectedStrings[actualIndexToExpectedIndexList.get(i - 1)]).append(",");
                    }
                    Assert.assertEquals((Object)expectedBuilder.toString(), (Object)actualBuilder.toString());
                    ++cnt;
                }
                Assert.assertEquals((long)11L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectLimitTest() throws ClassNotFoundException {
        String[] retArray = new String[]{"2,10000,1000,888,2,40000,3,3.33,70,bbbbb,null,null,", "50,10000,null,null,50,50000,4,4.44,80,ccccc,null,null,", "100,99,null,null,100,199,102,10.0,101,ddddd,null,null,", "101,99,null,null,101,199,105,11.11,102,fffff,null,null,", "102,80,null,null,102,180,1000,1000.11,946684800000,good,null,null,", "103,99,null,null,103,199,null,null,null,null,null,null,", "104,90,null,null,104,190,null,null,null,null,null,null,", "105,99,null,null,105,199,null,null,null,null,null,null,", "106,99,null,null,1000,55555,null,null,null,null,null,null,", "1000,22222,null,null,946684800000,100,null,null,null,null,null,null,"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select s0,s1,s2,s3,s4 from root.vehicle.* limit 10 offset 1 disable align");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                List<Integer> actualIndexToExpectedIndexList = this.checkHeader(resultSetMetaData, "Timeroot.vehicle.d0.s0,root.vehicle.d0.s0,Timeroot.vehicle.d1.s0,root.vehicle.d1.s0,Timeroot.vehicle.d0.s1,root.vehicle.d0.s1,Timeroot.vehicle.d0.s2,root.vehicle.d0.s2,Timeroot.vehicle.d0.s3,root.vehicle.d0.s3,Timeroot.vehicle.d0.s4,root.vehicle.d0.s4,", new int[]{4, 4, -5, 6, 12, 16});
                int cnt = 0;
                while (resultSet.next()) {
                    String[] expectedStrings = retArray[cnt].split(",");
                    StringBuilder expectedBuilder = new StringBuilder();
                    StringBuilder actualBuilder = new StringBuilder();
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        actualBuilder.append(resultSet.getString(i)).append(",");
                        expectedBuilder.append(expectedStrings[actualIndexToExpectedIndexList.get(i - 1)]).append(",");
                    }
                    Assert.assertEquals((Object)expectedBuilder.toString(), (Object)actualBuilder.toString());
                    ++cnt;
                }
                Assert.assertEquals((long)10L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectSlimitTest() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select * from root.vehicle.* slimit 2 soffset 1 disable align");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                Assert.assertEquals((long)4L, (long)resultSetMetaData.getColumnCount());
                int cnt = 0;
                while (resultSet.next()) {
                    ++cnt;
                }
                Assert.assertEquals((long)11L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void errorCaseTest1() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select * from root.vehicle where time = 3 Fill(int32[previous, 5ms]) disable align");
            Assert.fail((String)"No exception thrown.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("FILL doesn't support disable align clause."));
        }
    }

    @Test
    public void errorCaseTest2() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select count(*) from root.vehicle GROUP BY ([2,50),20ms) disable align");
            Assert.fail((String)"No exception thrown.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("GROUPBYTIME doesn't support disable align clause."));
        }
    }

    @Test
    public void errorCaseTest3() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select count(*) from root disable align");
            Assert.fail((String)"No exception thrown.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("AGGREGATION doesn't support disable align clause."));
        }
    }

    private List<Integer> checkHeader(ResultSetMetaData resultSetMetaData, String expectedHeaderStrings, int[] expectedTypes) throws SQLException {
        String[] expectedHeaders = expectedHeaderStrings.split(",");
        HashMap<String, Integer> expectedHeaderToTypeIndexMap = new HashMap<String, Integer>();
        HashMap<String, Integer> expectedHeaderToColumnIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < expectedHeaders.length; ++i) {
            if (i % 2 != 0) {
                expectedHeaderToTypeIndexMap.put(expectedHeaders[i], i / 2);
            }
            expectedHeaderToColumnIndexMap.put(expectedHeaders[i], i);
        }
        ArrayList<Integer> actualIndexToExpectedIndexList = new ArrayList<Integer>();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String columnName = resultSetMetaData.getColumnName(i);
            Integer typeIndex = (Integer)expectedHeaderToTypeIndexMap.get(columnName);
            if (typeIndex != null) {
                Assert.assertEquals((long)expectedTypes[typeIndex], (long)resultSetMetaData.getColumnType(i));
            }
            actualIndexToExpectedIndexList.add((Integer)expectedHeaderToColumnIndexMap.get(columnName));
        }
        return actualIndexToExpectedIndexList;
    }
}

