/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBDeleteTimeseriesIT {
    private long memtableSizeThreshold;
    private CompactionStrategy tsFileManagementStrategy;

    @Before
    public void setUp() {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        this.memtableSizeThreshold = IoTDBDescriptor.getInstance().getConfig().getMemtableSizeThreshold();
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold(16L);
        this.tsFileManagementStrategy = IoTDBDescriptor.getInstance().getConfig().getCompactionStrategy();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.NO_COMPACTION);
    }

    @After
    public void tearDown() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold(this.memtableSizeThreshold);
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(this.tsFileManagementStrategy);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void deleteTimeseriesAndCreateDifferentTypeTest() throws Exception {
        boolean hasResult;
        Statement statement;
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        String[] retArray = new String[]{"1,1,", "2,1.1,"};
        int cnt = 0;
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");){
            statement = connection.createStatement();
            try {
                int i;
                StringBuilder builder;
                ResultSetMetaData resultSetMetaData;
                statement.execute("create timeseries root.turbine1.d1.s1 with datatype=INT64, encoding=PLAIN, compression=SNAPPY");
                statement.execute("create timeseries root.turbine1.d1.s2 with datatype=INT64, encoding=PLAIN, compression=SNAPPY");
                statement.execute("INSERT INTO root.turbine1.d1(timestamp,s1,s2) VALUES(1,1,2)");
                hasResult = statement.execute("SELECT s1 FROM root.turbine1.d1");
                Assert.assertTrue((boolean)hasResult);
                try (ResultSet resultSet = statement.getResultSet();){
                    resultSetMetaData = resultSet.getMetaData();
                    while (resultSet.next()) {
                        builder = new StringBuilder();
                        for (i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                            builder.append(resultSet.getString(i)).append(",");
                        }
                        Assert.assertEquals((Object)retArray[cnt], (Object)builder.toString());
                        ++cnt;
                    }
                }
                statement.execute("DELETE timeseries root.turbine1.d1.s1");
                statement.execute("create timeseries root.turbine1.d1.s1 with datatype=DOUBLE, encoding=PLAIN, compression=SNAPPY");
                statement.execute("INSERT INTO root.turbine1.d1(timestamp,s1) VALUES(2,1.1)");
                statement.execute("FLUSH");
                hasResult = statement.execute("SELECT s1 FROM root.turbine1.d1");
                Assert.assertTrue((boolean)hasResult);
                resultSet = statement.getResultSet();
                try {
                    resultSetMetaData = resultSet.getMetaData();
                    while (resultSet.next()) {
                        builder = new StringBuilder();
                        for (i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                            builder.append(resultSet.getString(i)).append(",");
                        }
                        Assert.assertEquals((Object)retArray[cnt], (Object)builder.toString());
                        ++cnt;
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        EnvironmentUtils.restartDaemon();
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        try {
            statement = connection.createStatement();
            try {
                hasResult = statement.execute("SELECT * FROM root");
                Assert.assertTrue((boolean)hasResult);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void deleteTimeseriesAndCreateSameTypeTest() throws Exception {
        boolean hasResult;
        Statement statement;
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        String[] retArray = new String[]{"1,1,", "2,5,"};
        int cnt = 0;
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");){
            statement = connection.createStatement();
            try {
                int i;
                StringBuilder builder;
                ResultSetMetaData resultSetMetaData;
                statement.execute("create timeseries root.turbine1.d1.s1 with datatype=INT64, encoding=PLAIN, compression=SNAPPY");
                statement.execute("create timeseries root.turbine1.d1.s2 with datatype=INT64, encoding=PLAIN, compression=SNAPPY");
                statement.execute("INSERT INTO root.turbine1.d1(timestamp,s1,s2) VALUES(1,1,2)");
                hasResult = statement.execute("SELECT s1 FROM root.turbine1.d1");
                Assert.assertTrue((boolean)hasResult);
                try (ResultSet resultSet = statement.getResultSet();){
                    resultSetMetaData = resultSet.getMetaData();
                    while (resultSet.next()) {
                        builder = new StringBuilder();
                        for (i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                            builder.append(resultSet.getString(i)).append(",");
                        }
                        Assert.assertEquals((Object)retArray[cnt], (Object)builder.toString());
                        ++cnt;
                    }
                }
                statement.execute("DELETE timeseries root.turbine1.d1.s1");
                statement.execute("create timeseries root.turbine1.d1.s1 with datatype=INT64, encoding=PLAIN, compression=SNAPPY");
                statement.execute("INSERT INTO root.turbine1.d1(timestamp,s1) VALUES(2,5)");
                statement.execute("FLUSH");
                hasResult = statement.execute("SELECT s1 FROM root.turbine1.d1");
                Assert.assertTrue((boolean)hasResult);
                resultSet = statement.getResultSet();
                try {
                    resultSetMetaData = resultSet.getMetaData();
                    while (resultSet.next()) {
                        builder = new StringBuilder();
                        for (i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                            builder.append(resultSet.getString(i)).append(",");
                        }
                        Assert.assertEquals((Object)retArray[cnt], (Object)builder.toString());
                        ++cnt;
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        EnvironmentUtils.restartDaemon();
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        try {
            statement = connection.createStatement();
            try {
                hasResult = statement.execute("SELECT * FROM root");
                Assert.assertTrue((boolean)hasResult);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

