/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBDeleteStorageGroupIT {
    @Before
    public void setUp() {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testDeleteStorageGroup() throws Exception {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.ln.wf01.wt01");
            statement.execute("SET STORAGE GROUP TO root.ln.wf01.wt02");
            statement.execute("SET STORAGE GROUP TO root.ln.wf01.wt03");
            statement.execute("SET STORAGE GROUP TO root.ln.wf01.wt04");
            statement.execute("DELETE STORAGE GROUP root.ln.wf01.wt01");
            boolean hasResult = statement.execute("SHOW STORAGE GROUP");
            Assert.assertTrue((boolean)hasResult);
            String[] expected = new String[]{"root.ln.wf01.wt02", "root.ln.wf01.wt03", "root.ln.wf01.wt04"};
            ArrayList expectedList = new ArrayList();
            Collections.addAll(expectedList, expected);
            ArrayList<String> result = new ArrayList<String>();
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    result.add(resultSet.getString(1));
                }
            }
            Assert.assertEquals((long)expected.length, (long)result.size());
            Assert.assertTrue((boolean)expectedList.containsAll(result));
        }
    }

    @Test
    public void testDeleteMultipleStorageGroupWithQuote() throws Exception {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.ln1.wf01.wt01");
            statement.execute("SET STORAGE GROUP TO root.ln1.wf01.wt02");
            statement.execute("SET STORAGE GROUP TO root.ln1.wf02.wt03");
            statement.execute("SET STORAGE GROUP TO root.ln1.wf02.wt04");
            statement.execute("DELETE STORAGE GROUP root.ln1.wf01.wt01, root.ln1.wf02.wt03");
            boolean hasResult = statement.execute("SHOW STORAGE GROUP");
            Assert.assertTrue((boolean)hasResult);
            String[] expected = new String[]{"root.ln1.wf01.wt02", "root.ln1.wf02.wt04"};
            ArrayList expectedList = new ArrayList();
            Collections.addAll(expectedList, expected);
            ArrayList<String> result = new ArrayList<String>();
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    result.add(resultSet.getString(1));
                }
            }
            Assert.assertEquals((long)expected.length, (long)result.size());
            Assert.assertTrue((boolean)expectedList.containsAll(result));
        }
    }

    @Test(expected=IoTDBSQLException.class)
    public void deleteNonExistStorageGroup() throws Exception {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.ln2.wf01.wt01");
            statement.execute("DELETE STORAGE GROUP root.ln2.wf01.wt02");
        }
    }

    @Test
    public void testDeleteStorageGroupWithStar() throws Exception {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.ln3.wf01.wt01");
            statement.execute("SET STORAGE GROUP TO root.ln3.wf01.wt02");
            statement.execute("SET STORAGE GROUP TO root.ln3.wf02.wt03");
            statement.execute("SET STORAGE GROUP TO root.ln3.wf02.wt04");
            statement.execute("DELETE STORAGE GROUP root.ln3.wf02.*");
            boolean hasResult = statement.execute("SHOW STORAGE GROUP");
            Assert.assertTrue((boolean)hasResult);
            String[] expected = new String[]{"root.ln3.wf01.wt01", "root.ln3.wf01.wt02"};
            ArrayList expectedList = new ArrayList();
            Collections.addAll(expectedList, expected);
            ArrayList<String> result = new ArrayList<String>();
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    result.add(resultSet.getString(1));
                }
            }
            Assert.assertEquals((long)expected.length, (long)result.size());
            Assert.assertTrue((boolean)expectedList.containsAll(result));
        }
    }

    @Test
    public void testDeleteAllStorageGroups() throws Exception {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.ln4.wf01.wt01");
            statement.execute("SET STORAGE GROUP TO root.ln4.wf01.wt02");
            statement.execute("SET STORAGE GROUP TO root.ln4.wf02.wt03");
            statement.execute("SET STORAGE GROUP TO root.ln4.wf02.wt04");
            statement.execute("DELETE STORAGE GROUP root.*");
            boolean hasResult = statement.execute("SHOW STORAGE GROUP");
            Assert.assertTrue((boolean)hasResult);
            ArrayList<String> result = new ArrayList<String>();
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    result.add(resultSet.getString(1));
                }
            }
            Assert.assertEquals((long)0L, (long)result.size());
        }
    }
}

