/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBCreateTimeseriesIT {
    private Statement statement;
    private Connection connection;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        this.connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        this.statement = this.connection.createStatement();
    }

    @After
    public void tearDown() throws Exception {
        this.statement.close();
        this.connection.close();
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testCreateTimeseries1() throws Exception {
        String[] timeSeriesArray;
        for (String timeSeries : timeSeriesArray = new String[]{"root.sg1.aa.bb", "root.sg1.aa.bb.cc", "root.sg1.aa"}) {
            this.statement.execute(String.format("create timeseries %s with datatype=INT64, encoding=PLAIN, compression=SNAPPY", timeSeries));
        }
        this.createTimeSeries1Tool(timeSeriesArray);
        EnvironmentUtils.stopDaemon();
        this.setUp();
        this.createTimeSeries1Tool(timeSeriesArray);
    }

    private void createTimeSeries1Tool(String[] timeSeriesArray) throws SQLException {
        boolean hasResult = this.statement.execute("show timeseries");
        Assert.assertTrue((boolean)hasResult);
        ArrayList<String> resultList = new ArrayList<String>();
        try (ResultSet resultSet = this.statement.getResultSet();){
            while (resultSet.next()) {
                String timeseries = resultSet.getString("timeseries");
                resultList.add(timeseries);
            }
        }
        Assert.assertEquals((long)3L, (long)resultList.size());
        List collect = resultList.stream().sorted(Comparator.comparingInt(e -> e.split("\\.").length)).collect(Collectors.toList());
        Assert.assertEquals((Object)timeSeriesArray[2], collect.get(0));
        Assert.assertEquals((Object)timeSeriesArray[0], collect.get(1));
        Assert.assertEquals((Object)timeSeriesArray[1], collect.get(2));
    }

    @Test
    public void testCreateTimeseries2() throws Exception {
        String storageGroup = "root.sg1.a.b.c";
        this.statement.execute(String.format("SET storage group TO %s", storageGroup));
        try {
            this.statement.execute(String.format("create timeseries %s with datatype=INT64, encoding=PLAIN, compression=SNAPPY", storageGroup));
        }
        catch (IoTDBSQLException ioTDBSQLException) {
            // empty catch block
        }
        this.createTimeSeries2Tool(storageGroup);
        EnvironmentUtils.stopDaemon();
        this.setUp();
        this.createTimeSeries2Tool(storageGroup);
    }

    private void createTimeSeries2Tool(String storageGroup) throws SQLException {
        this.statement.execute("show timeseries");
        HashSet<String> resultList = new HashSet<String>();
        try (ResultSet resultSet = this.statement.getResultSet();){
            while (resultSet.next()) {
                String str = resultSet.getString("timeseries");
                resultList.add(str);
            }
        }
        Assert.assertFalse((boolean)resultList.contains(storageGroup));
        this.statement.execute("show storage group");
        resultList.clear();
        resultSet = this.statement.getResultSet();
        try {
            while (resultSet.next()) {
                String res = resultSet.getString("storage group");
                resultList.add(res);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        Assert.assertTrue((boolean)resultList.contains(storageGroup));
    }
}

