/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.logfile.MLogReader;
import org.apache.iotdb.db.metadata.logfile.MLogWriter;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBCreateSnapshotIT {
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        IoTDBCreateSnapshotIT.prepareData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void createSnapshotTest() throws ClassNotFoundException {
        Statement statement;
        Connection connection;
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try {
            connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
            try {
                statement = connection.createStatement();
                try {
                    this.checkShowTimeseries(statement);
                    statement.execute("CREATE SNAPSHOT FOR SCHEMA");
                    File snapshotFile = new File(config.getSchemaDir() + File.separator + "mtree-1.snapshot.bin");
                    Assert.assertTrue((boolean)snapshotFile.exists());
                    String[] exp = new String[]{"2,s0,,1,2,1,,-1,0", "2,s1,,2,2,1,,-1,0", "2,s2,,3,2,1,,-1,0", "2,s3,,5,0,1,,-1,0", "2,s4,,0,0,1,,-1,0", "1,d0,9223372036854775807,5", "2,s0,,1,2,1,,-1,0", "2,s1,,5,0,1,,-1,0", "2,s2,,0,0,1,,-1,0", "1,d1,9223372036854775807,3", "0,vehicle,2", "0,root,1"};
                    HashSet<PhysicalPlan> d0Plans = new HashSet<PhysicalPlan>(6);
                    for (int i = 0; i < 6; ++i) {
                        d0Plans.add(MLogWriter.convertFromString((String)exp[i]));
                    }
                    HashSet<PhysicalPlan> d1Plans = new HashSet<PhysicalPlan>(6);
                    for (int i = 0; i < 6; ++i) {
                        d1Plans.add(MLogWriter.convertFromString((String)exp[i + 6]));
                    }
                    try (MLogReader mLogReader = new MLogReader(snapshotFile);){
                        PhysicalPlan plan;
                        int i;
                        for (i = 0; i < 6 && mLogReader.hasNext(); ++i) {
                            plan = mLogReader.next();
                            Assert.assertTrue((boolean)d0Plans.removeIf(candidate -> candidate.equals(plan)));
                        }
                        Assert.assertTrue((boolean)d0Plans.isEmpty());
                        while (i < 12 && mLogReader.hasNext()) {
                            plan = mLogReader.next();
                            Assert.assertTrue((boolean)d1Plans.removeIf(candidate -> candidate.equals(plan)));
                            ++i;
                        }
                        Assert.assertTrue((boolean)d1Plans.isEmpty());
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            EnvironmentUtils.restartDaemon();
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
            try {
                statement = connection.createStatement();
                try {
                    this.checkShowTimeseries(statement);
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static void prepareData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] creationSqls;
            for (String sql : creationSqls = new String[]{"SET STORAGE GROUP TO root.vehicle.d0", "SET STORAGE GROUP TO root.vehicle.d1", "CREATE TIMESERIES root.vehicle.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s1 WITH DATATYPE=INT64, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s2 WITH DATATYPE=FLOAT, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s3 WITH DATATYPE=TEXT, ENCODING=PLAIN", "CREATE TIMESERIES root.vehicle.d0.s4 WITH DATATYPE=BOOLEAN, ENCODING=PLAIN", "CREATE TIMESERIES root.vehicle.d1.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d1.s1 WITH DATATYPE=TEXT, ENCODING=PLAIN", "CREATE TIMESERIES root.vehicle.d1.s2 WITH DATATYPE=BOOLEAN, ENCODING=PLAIN"}) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkShowTimeseries(Statement statement) throws SQLException {
        boolean hasResultSet = statement.execute("SHOW TIMESERIES");
        Assert.assertTrue((boolean)hasResultSet);
        try (ResultSet resultSet = statement.getResultSet();){
            int cnt = 0;
            while (resultSet.next()) {
                ++cnt;
            }
            Assert.assertEquals((long)8L, (long)cnt);
        }
    }
}

