/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBCompressTypeIT {
    @Before
    public void setUp() {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testGZIPCompression() throws Exception {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TIMESERIES root.ln.wf01.wt01.name WITH DATATYPE=TEXT");
            statement.execute("CREATE TIMESERIES root.ln.wf01.wt01.age WITH DATATYPE=INT32, ENCODING=RLE, COMPRESSOR = GZIP");
            statement.execute("insert into root.ln.wf01.wt01(timestamp,name,age) values(1000,'zhang',10)");
            statement.execute("flush");
            ResultSet r1 = statement.executeQuery("select * from root.ln.wf01.wt01");
            r1.next();
            Assert.assertEquals((Object)"zhang", (Object)r1.getString(2));
            Assert.assertEquals((long)10L, (long)r1.getInt(3));
            statement.execute("insert into root.ln.wf01.wt01(timestamp,name,age) values(2000,'wang',20)");
            statement.execute("flush");
            statement.execute("insert into root.ln.wf01.wt01(timestamp,name,age) values(3000,'li',30)");
            ResultSet r2 = statement.executeQuery("select * from root.ln.wf01.wt01 where name = 'wang'");
            r2.next();
            Assert.assertEquals((long)20L, (long)r2.getInt(3));
            ResultSet r3 = statement.executeQuery("select * from root.ln.wf01.wt01 where name = 'li'");
            r3.next();
            Assert.assertEquals((long)30L, (long)r3.getInt(3));
            ResultSet r4 = statement.executeQuery("select sum(age) from root.ln.wf01.wt01");
            r4.next();
            double d = r4.getDouble(1);
            Assert.assertTrue((60.0 == d ? 1 : 0) != 0);
            for (int i = 1; i <= 1000; ++i) {
                String time = String.valueOf(i * 100);
                String values = String.valueOf(i * 10);
                statement.execute(String.format("insert into root.ln.wf01.wt01(timestamp,name,age) values(%s,'wang', %s)", time, values));
            }
            statement.execute("flush");
            ResultSet r5 = statement.executeQuery("select * from root.ln.wf01.wt01 where timestamp = 100000");
            r5.next();
            Assert.assertEquals((long)10000L, (long)r5.getInt(3));
        }
    }
}

