/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class IoTDBClearCacheIT {
    private static final String[] sqls = new String[]{"set storage group to root.ln", "create timeseries root.ln.wf01.wt01.status with datatype=BOOLEAN,encoding=PLAIN", "insert into root.ln.wf01.wt01(timestamp,status) values(1509465600000,true)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509465660000,true)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509465720000,false)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509465780000,false)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509465840000,false)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509465900000,false)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509465960000,false)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509466020000,false)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509466080000,false)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509466140000,false)", "create timeseries root.ln.wf01.wt01.temperature with datatype=FLOAT,encoding=RLE", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509465600000,25.957603)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509465660000,24.359503)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509465720000,20.092794)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509465780000,20.182663)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509465840000,21.125198)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509465900000,22.720892)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509465960000,20.71)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509466020000,21.451046)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509466080000,22.57987)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509466140000,20.98177)", "create timeseries root.ln.wf02.wt02.hardware with datatype=TEXT,encoding=PLAIN", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509465600000,\"v2\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509465660000,\"v2\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509465720000,\"v1\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509465780000,\"v1\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509465840000,\"v1\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509465900000,\"v1\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509465960000,\"v1\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509466020000,\"v1\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509466080000,\"v1\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509466140000,\"v1\")", "create timeseries root.ln.wf02.wt02.status with datatype=BOOLEAN,encoding=PLAIN", "insert into root.ln.wf02.wt02(timestamp,status) values(1509465600000,true)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509465660000,true)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509465720000,false)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509465780000,false)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509465840000,false)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509465900000,false)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509465960000,false)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509466020000,false)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509466080000,false)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509466140000,false)", "set storage group to root.sgcc", "create timeseries root.sgcc.wf03.wt01.status with datatype=BOOLEAN,encoding=PLAIN", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509465600000,true)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509465660000,true)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509465720000,false)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509465780000,false)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509465840000,false)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509465900000,false)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509465960000,false)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509466020000,false)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509466080000,false)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509466140000,false)", "create timeseries root.sgcc.wf03.wt01.temperature with datatype=FLOAT,encoding=RLE", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509465600000,25.957603)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509465660000,24.359503)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509465720000,20.092794)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509465780000,20.182663)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509465840000,21.125198)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509465900000,22.720892)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509465960000,20.71)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509466020000,21.451046)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509466080000,22.57987)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509466140000,20.98177)", "flush"};
    private static final long MAX_WAIT_TIME_FOR_CLEAR_CACHE = 60000000000L;

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        IoTDBClearCacheIT.importData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    private static void importData() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : sqls) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public void clearCacheTest() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select * from root where time > 10");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                while (resultSet.next()) {
                    ++cnt;
                }
                Assert.assertEquals((long)10L, (long)cnt);
            }
            Assert.assertFalse((boolean)ChunkCache.getInstance().isEmpty());
            Assert.assertFalse((boolean)TimeSeriesMetadataCache.getInstance().isEmpty());
            statement.execute("CLEAR CACHE");
            Assert.assertTrue((boolean)this.waitForClearCacheFinish());
            Assert.assertTrue((boolean)TimeSeriesMetadataCache.getInstance().isEmpty());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private boolean waitForClearCacheFinish() throws StorageEngineException, InterruptedException {
        long startTime = System.nanoTime();
        while (!ChunkCache.getInstance().isEmpty() || !TimeSeriesMetadataCache.getInstance().isEmpty()) {
            TimeUnit.MILLISECONDS.sleep(100L);
            if (System.nanoTime() - startTime < 60000000000L) continue;
        }
        return ChunkCache.getInstance().isEmpty() && TimeSeriesMetadataCache.getInstance().isEmpty();
    }
}

