/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.iotdb.db.conf.IoTDBConfigCheck;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBCheckConfigIT {
    private File propertiesFile = SystemFileFactory.INSTANCE.getFile(IoTDBDescriptor.getInstance().getConfig().getSchemaDir() + File.separator + "system.properties");
    private TSFileConfig tsFileConfig = TSFileDescriptor.getInstance().getConfig();
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private Properties properties = new Properties();
    private PrintStream console = null;
    private ByteArrayOutputStream bytes = null;

    @Before
    public void setUp() {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        SecurityManager securityManager = new SecurityManager(){

            @Override
            public void checkPermission(Permission permission) {
                if (permission.getName().startsWith("exitVM")) {
                    throw new AccessControlException("Wrong system config");
                }
            }
        };
        System.setSecurityManager(securityManager);
        this.bytes = new ByteArrayOutputStream();
        this.console = System.out;
        System.setOut(new PrintStream(this.bytes));
        this.systemProperties.put("partition_interval", "604800");
        this.systemProperties.put("timestamp_precision", "ms");
        this.systemProperties.put("tsfile_storage_fs", "LOCAL");
        this.systemProperties.put("enable_partition", "false");
        this.systemProperties.put("max_degree_of_index_node", "256");
        this.systemProperties.put("tag_attribute_total_size", "700");
        this.systemProperties.put("iotdb_version", "0.11.2");
        this.systemProperties.put("virtual_storage_group_num", "1");
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        this.systemProperties.clear();
        this.properties.clear();
        System.setOut(this.console);
    }

    @Test
    public void testSaveTimeEncoderToSystemProperties() throws Exception {
        try {
            IoTDBConfigCheck.getInstance().checkConfig();
        }
        finally {
            System.setSecurityManager(null);
        }
        try (FileInputStream inputStream = new FileInputStream(this.propertiesFile);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, TSFileConfig.STRING_CHARSET);){
            this.properties.load(inputStreamReader);
        }
        String timeEncoder = (String)this.properties.get("time_encoder");
        Assert.assertTrue((!timeEncoder.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testAlterTimeEncoderAfterStartService() throws Exception {
        EnvironmentUtils.shutdownDaemon();
        EnvironmentUtils.stopDaemon();
        IoTDB.metaManager.clear();
        this.systemProperties.put("time_encoder", "REGULAR");
        this.writeSystemFile();
        EnvironmentUtils.reactiveDaemon();
        try {
            IoTDBConfigCheck.getInstance().checkConfig();
        }
        catch (Throwable t) {
            Assert.assertEquals((Object)"Wrong system config", (Object)t.getMessage());
        }
        finally {
            System.setSecurityManager(null);
        }
        Assert.assertTrue((boolean)this.bytes.toString().contains("Wrong time_encoder, please set as: REGULAR"));
    }

    @Test
    public void testSameTimeEncoderAfterStartService() throws Exception {
        EnvironmentUtils.shutdownDaemon();
        EnvironmentUtils.stopDaemon();
        IoTDB.metaManager.clear();
        this.systemProperties.put("time_encoder", "TS_2DIFF");
        this.writeSystemFile();
        EnvironmentUtils.reactiveDaemon();
        try {
            IoTDBConfigCheck.getInstance().checkConfig();
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)false);
        }
        finally {
            System.setSecurityManager(null);
        }
    }

    private void writeSystemFile() throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(this.propertiesFile);){
            this.systemProperties.forEach((k, v) -> this.properties.setProperty((String)k, (String)v));
            this.properties.store(outputStream, "System properties:");
        }
    }
}

