/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBAutoCreateSchemaIT {
    private Statement statement;
    private Connection connection;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        this.connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        this.statement = this.connection.createStatement();
    }

    @After
    public void tearDown() throws Exception {
        this.statement.close();
        this.connection.close();
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void createTimeseriesTest() throws ClassNotFoundException {
        String[] sqls = new String[]{"CREATE TIMESERIES root.sg0.d1.s2 WITH DATATYPE=INT32,ENCODING=RLE", "INSERT INTO root.sg0.d1(timestamp,s2) values(1,123)"};
        this.executeSQL(sqls);
    }

    @Test
    public void insertTest1() throws ClassNotFoundException {
        String[] sqls = new String[]{"SET STORAGE GROUP TO root.sg0", "INSERT INTO root.sg0.d1(timestamp,s2) values(1,123.123)", "INSERT INTO root.sg0.d1(timestamp,s3) values(1,\"abc\")"};
        this.executeSQL(sqls);
    }

    @Test
    public void insertTest2() throws ClassNotFoundException {
        String[] sqls = new String[]{"INSERT INTO root.sg0.d1(timestamp,s2) values(1,\"abc\")", "INSERT INTO root.sg0.d2(timestamp,s3) values(1,123.123)", "INSERT INTO root.sg0.d2(timestamp,s4) values(1,123456)"};
        this.executeSQL(sqls);
    }

    private void executeSQL(String[] sqls) throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String result = "";
            Long now_start = 0L;
            boolean cmp = false;
            for (String sql : sqls) {
                int i;
                if (cmp) {
                    Assert.assertEquals((Object)sql, (Object)result);
                    cmp = false;
                    continue;
                }
                if (sql.equals("SHOW TIMESERIES")) {
                    DatabaseMetaData data = connection.getMetaData();
                    result = data.toString();
                    cmp = true;
                    continue;
                }
                if (sql.contains("NOW()") && now_start == 0L) {
                    now_start = System.currentTimeMillis();
                }
                statement.execute(sql);
                if (!sql.split(" ")[0].equals("SELECT")) continue;
                ResultSet resultSet = statement.getResultSet();
                ResultSetMetaData metaData = resultSet.getMetaData();
                int count = metaData.getColumnCount();
                String[] column = new String[count];
                for (i = 0; i < count; ++i) {
                    column[i] = metaData.getColumnName(i + 1);
                }
                result = "";
                while (resultSet.next()) {
                    for (i = 1; i <= count; ++i) {
                        if (now_start > 0L && column[i - 1].equals("Time")) {
                            String timestr = resultSet.getString(i);
                            Long tn = Long.valueOf(timestr);
                            Long now = System.currentTimeMillis();
                            if (tn >= now_start && tn <= now) {
                                timestr = "NOW()";
                            }
                            result = result + timestr + ',';
                            continue;
                        }
                        result = result + resultSet.getString(i) + ',';
                    }
                    result = result + '\n';
                }
                cmp = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testInsertAutoCreate1() throws Exception {
        String[] timeSeriesArray;
        for (String timeSeries : timeSeriesArray = new String[]{"root.sg1.a.a", "root.sg1.a", "root.sg1.a.a.a"}) {
            this.statement.execute(String.format("INSERT INTO %s(timestamp, a) values(123, \"aabb\")", timeSeries));
        }
        this.insertAutoCreate1Tool();
        EnvironmentUtils.stopDaemon();
        this.setUp();
        this.insertAutoCreate1Tool();
    }

    private void insertAutoCreate1Tool() throws SQLException {
        boolean hasResult = this.statement.execute("select * from root.sg1");
        Assert.assertTrue((boolean)hasResult);
        HashSet<Object> strSet = new HashSet();
        String[] valueList = new String[]{};
        try (ResultSet resultSet = this.statement.getResultSet();){
            while (resultSet.next()) {
                valueList = new String[]{resultSet.getString("root.sg1.a.a"), resultSet.getString("root.sg1.a.a.a"), resultSet.getString("root.sg1.a.a.a.a")};
                strSet = new HashSet<String>(Arrays.asList(valueList));
            }
        }
        Assert.assertEquals((long)3L, (long)valueList.length);
        Assert.assertEquals((long)1L, (long)strSet.size());
        Assert.assertTrue((boolean)strSet.contains("aabb"));
    }

    @Test
    public void testInsertAutoCreate2() throws Exception {
        String storageGroup = "root.sg2.a.b.c";
        String timeSeriesPrefix = "root.sg2.a.b";
        this.statement.execute(String.format("SET storage group TO %s", storageGroup));
        try {
            this.statement.execute(String.format("INSERT INTO %s(timestamp, c) values(123, \"aabb\")", timeSeriesPrefix));
        }
        catch (IoTDBSQLException ioTDBSQLException) {
            // empty catch block
        }
        this.InsertAutoCreate2Tool(storageGroup, timeSeriesPrefix);
        EnvironmentUtils.stopDaemon();
        this.setUp();
        this.InsertAutoCreate2Tool(storageGroup, timeSeriesPrefix);
    }

    private void InsertAutoCreate2Tool(String storageGroup, String timeSeriesPrefix) throws SQLException {
        this.statement.execute("show timeseries");
        HashSet<String> resultList = new HashSet<String>();
        try (ResultSet resultSet = this.statement.getResultSet();){
            while (resultSet.next()) {
                String str = resultSet.getString("timeseries");
                resultList.add(str);
            }
        }
        Assert.assertFalse((boolean)resultList.contains(timeSeriesPrefix + "c"));
        this.statement.execute("show storage group");
        resultList.clear();
        resultSet = this.statement.getResultSet();
        try {
            while (resultSet.next()) {
                resultList.add(resultSet.getString("storage group"));
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        Assert.assertTrue((boolean)resultList.contains(storageGroup));
    }
}

