/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBAddSubDeviceIT {
    private static String[] sqls = new String[]{"CREATE TIMESERIES root.sg1.d1.s1 with datatype=INT32,encoding=RLE", "CREATE TIMESERIES root.sg1.d1.s1.s1 with datatype=INT32,encoding=RLE", "CREATE TIMESERIES root.sg1.d1.s1.s2 with datatype=INT32,encoding=RLE"};

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        IoTDBAddSubDeviceIT.insertData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    private static void insertData() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : sqls) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void showDevicesWithSg() throws ClassNotFoundException {
        String[] retArray = new String[]{"root.sg1.d1,root.sg1,", "root.sg1.d1.s1,root.sg1,"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("SHOW DEVICES WITH STORAGE GROUP");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                StringBuilder header = new StringBuilder();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    header.append(resultSetMetaData.getColumnName(i)).append(",");
                }
                Assert.assertEquals((Object)"devices,storage group,", (Object)header.toString());
                Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(1));
                int cnt = 0;
                while (resultSet.next()) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        builder.append(resultSet.getString(i)).append(",");
                    }
                    Assert.assertEquals((Object)retArray[cnt], (Object)builder.toString());
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void showDevices() throws ClassNotFoundException {
        String[] retArray = new String[]{"root.sg1.d1,", "root.sg1.d1.s1,"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("SHOW DEVICES");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                StringBuilder header = new StringBuilder();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    header.append(resultSetMetaData.getColumnName(i)).append(",");
                }
                Assert.assertEquals((Object)"devices,", (Object)header.toString());
                Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(1));
                int cnt = 0;
                while (resultSet.next()) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        builder.append(resultSet.getString(i)).append(",");
                    }
                    Assert.assertEquals((Object)retArray[cnt], (Object)builder.toString());
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void showTimeseries() throws ClassNotFoundException {
        String[] retArray = new String[]{"root.sg1.d1.s1,null,root.sg1,INT32,RLE,SNAPPY,null,null,", "root.sg1.d1.s1.s1,null,root.sg1,INT32,RLE,SNAPPY,null,null,", "root.sg1.d1.s1.s2,null,root.sg1,INT32,RLE,SNAPPY,null,null,"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("SHOW TIMESERIES");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                StringBuilder header = new StringBuilder();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    header.append(resultSetMetaData.getColumnName(i)).append(",");
                }
                Assert.assertEquals((Object)"timeseries,alias,storage group,dataType,encoding,compression,tags,attributes,", (Object)header.toString());
                Assert.assertEquals((long)12L, (long)resultSetMetaData.getColumnType(1));
                int cnt = 0;
                while (resultSet.next()) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        builder.append(resultSet.getString(i)).append(",");
                    }
                    Assert.assertEquals((Object)retArray[cnt], (Object)builder.toString());
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void insertDataInAllSeries() throws ClassNotFoundException {
        String[] retArray = new String[]{"0,1,2,3,"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("INSERT INTO root.sg1.d1 (timestamp, s1) VALUES(0, 1)");
            statement.execute("INSERT INTO root.sg1.d1.s1 (timestamp, s1) VALUES(0, 2)");
            statement.execute("INSERT INTO root.sg1.d1.s1 (timestamp, s2) VALUES(0, 3)");
            boolean hasResultSet = statement.execute("SELECT * FROM root.sg1.d1");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                StringBuilder header = new StringBuilder();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    header.append(resultSetMetaData.getColumnName(i)).append(",");
                }
                Assert.assertEquals((Object)"Time,root.sg1.d1.s1,root.sg1.d1.s1.s1,root.sg1.d1.s1.s2,", (Object)header.toString());
                int cnt = 0;
                while (resultSet.next()) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        builder.append(resultSet.getString(i)).append(",");
                    }
                    Assert.assertEquals((Object)retArray[cnt], (Object)builder.toString());
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

