/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IOTDBInsertIT {
    private static List<String> sqls = new ArrayList<String>();
    private static Connection connection;

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        IOTDBInsertIT.initCreateSQLStatement();
        EnvironmentUtils.envSetUp();
        IOTDBInsertIT.insertData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        IOTDBInsertIT.close();
        EnvironmentUtils.cleanEnv();
    }

    private static void close() {
        if (Objects.nonNull(connection)) {
            try {
                connection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void initCreateSQLStatement() {
        sqls.add("SET STORAGE GROUP TO root.t1");
        sqls.add("CREATE TIMESERIES root.t1.wf01.wt01.status WITH DATATYPE=BOOLEAN, ENCODING=PLAIN");
        sqls.add("CREATE TIMESERIES root.t1.wf01.wt01.temperature WITH DATATYPE=FLOAT, ENCODING=RLE");
    }

    private static void insertData() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        Statement statement = connection.createStatement();
        for (String sql : sqls) {
            statement.execute(sql);
        }
        statement.close();
    }

    @Test
    public void testNormalInset() throws SQLException {
        Statement st0 = connection.createStatement();
        st0.execute("insert into root.t1.wf01.wt01(timestamp, status) values (1000, true)");
        st0.execute("insert into root.t1.wf01.wt01(timestamp, status) values (2000, false)");
        st0.execute("insert into root.t1.wf01.wt01(timestamp, status) values (3000, true)");
        st0.execute("insert into root.t1.wf01.wt01(timestamp, status, temperature) values (4000, true, 17.1)");
        st0.execute("insert into root.t1.wf01.wt01(timestamp, status, temperature) values (5000, true, 20.1)");
        st0.execute("insert into root.t1.wf01.wt01(timestamp, status, temperature) values (6000, true, 22)");
        st0.close();
        Statement st1 = connection.createStatement();
        ResultSet rs1 = st1.executeQuery("select count(status) from root.t1.wf01.wt01");
        rs1.next();
        long countStatus = rs1.getLong(1);
        Assert.assertTrue((countStatus == 6L ? 1 : 0) != 0);
        ResultSet rs2 = st1.executeQuery("select count(temperature) from root.t1.wf01.wt01");
        rs2.next();
        long countTemperature = rs2.getLong(1);
        Assert.assertTrue((countTemperature == 3L ? 1 : 0) != 0);
        st1.close();
    }

    @Test(expected=Exception.class)
    public void testInsertWithTimesColumns() throws SQLException {
        Statement st1 = connection.createStatement();
        st1.execute("insert into root.t1.wf01.wt01(timestamp) values(11000)");
    }
}

