/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.MetadataManagerHelper;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessorInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileProcessorTest {
    private TsFileProcessor processor;
    private String storageGroup = "storage_group1";
    private StorageGroupInfo sgInfo = new StorageGroupInfo(null);
    private String filePath = TestConstant.OUTPUT_DATA_DIR.concat("testUnsealedTsFileProcessor.tsfile");
    private String deviceId = "root.vehicle.d0";
    private String measurementId = "s0";
    private TSDataType dataType = TSDataType.INT32;
    private TSEncoding encoding = TSEncoding.RLE;
    private Map<String, String> props = Collections.emptyMap();
    private QueryContext context;
    private static Logger logger = LoggerFactory.getLogger(TsFileProcessorTest.class);
    protected static final int INIT_ARRAY_SIZE = 64;

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
        MetadataManagerHelper.initMetadata();
        this.context = EnvironmentUtils.TEST_QUERY_CONTEXT;
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        EnvironmentUtils.cleanDir(TestConstant.OUTPUT_DATA_DIR);
    }

    @Test
    public void testWriteAndFlush() throws IOException, WriteProcessException, MetadataException {
        logger.info("testWriteAndFlush begin..");
        this.processor = new TsFileProcessor(this.storageGroup, SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, tsFileProcessor -> true, true, 64);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        tsFileProcessorInfo.addTSPMemCost(this.processor.getTsFileResource().calculateRamSize());
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        this.processor.query(this.deviceId, this.measurementId, this.dataType, this.encoding, this.props, this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)tsfileResourcesForQuery.isEmpty());
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)this.measurementId, (String)String.valueOf(i)));
            this.processor.insert(new InsertRowPlan(record));
        }
        tsfileResourcesForQuery.clear();
        this.processor.query(this.deviceId, this.measurementId, this.dataType, this.encoding, this.props, this.context, tsfileResourcesForQuery);
        Assert.assertFalse((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk().isEmpty());
        List memChunks = ((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk();
        for (ReadOnlyMemChunk chunk : memChunks) {
            IPointReader iterator = chunk.getPointReader();
            for (int num = 1; num <= 100; ++num) {
                iterator.hasNextTimeValuePair();
                TimeValuePair timeValuePair = iterator.nextTimeValuePair();
                Assert.assertEquals((long)num, (long)timeValuePair.getTimestamp());
                Assert.assertEquals((long)num, (long)timeValuePair.getValue().getInt());
            }
        }
        this.processor.syncFlush();
        tsfileResourcesForQuery.clear();
        this.processor.query(this.deviceId, this.measurementId, this.dataType, this.encoding, this.props, this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk().isEmpty());
        Assert.assertEquals((long)1L, (long)((TsFileResource)tsfileResourcesForQuery.get(0)).getChunkMetadataList().size());
        Assert.assertEquals((Object)this.measurementId, (Object)((ChunkMetadata)((TsFileResource)tsfileResourcesForQuery.get(0)).getChunkMetadataList().get(0)).getMeasurementUid());
        Assert.assertEquals((Object)this.dataType, (Object)((ChunkMetadata)((TsFileResource)tsfileResourcesForQuery.get(0)).getChunkMetadataList().get(0)).getDataType());
        this.processor.syncClose();
    }

    @Test
    public void testWriteAndRestoreMetadata() throws IOException, WriteProcessException, MetadataException {
        logger.info("testWriteAndRestoreMetadata begin..");
        this.processor = new TsFileProcessor(this.storageGroup, SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, tsFileProcessor -> true, true, 64);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        tsFileProcessorInfo.addTSPMemCost(this.processor.getTsFileResource().calculateRamSize());
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        this.processor.query(this.deviceId, this.measurementId, this.dataType, this.encoding, this.props, this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)tsfileResourcesForQuery.isEmpty());
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)this.measurementId, (String)String.valueOf(i)));
            this.processor.insert(new InsertRowPlan(record));
        }
        tsfileResourcesForQuery.clear();
        this.processor.query(this.deviceId, this.measurementId, this.dataType, this.encoding, this.props, this.context, tsfileResourcesForQuery);
        Assert.assertFalse((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk().isEmpty());
        int num = 1;
        List memChunks = ((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk();
        for (ReadOnlyMemChunk chunk : memChunks) {
            IPointReader iterator = chunk.getPointReader();
            while (num <= 100) {
                iterator.hasNextTimeValuePair();
                TimeValuePair timeValuePair = iterator.nextTimeValuePair();
                Assert.assertEquals((long)num, (long)timeValuePair.getTimestamp());
                Assert.assertEquals((long)num, (long)timeValuePair.getValue().getInt());
                ++num;
            }
        }
        logger.info("syncFlush..");
        this.processor.syncFlush();
        tsfileResourcesForQuery.clear();
        this.processor.query(this.deviceId, this.measurementId, this.dataType, this.encoding, this.props, this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk().isEmpty());
        Assert.assertEquals((long)1L, (long)((TsFileResource)tsfileResourcesForQuery.get(0)).getChunkMetadataList().size());
        Assert.assertEquals((Object)this.measurementId, (Object)((ChunkMetadata)((TsFileResource)tsfileResourcesForQuery.get(0)).getChunkMetadataList().get(0)).getMeasurementUid());
        Assert.assertEquals((Object)this.dataType, (Object)((ChunkMetadata)((TsFileResource)tsfileResourcesForQuery.get(0)).getChunkMetadataList().get(0)).getDataType());
        RestorableTsFileIOWriter tsFileIOWriter = this.processor.getWriter();
        Map chunkMetaDataListInChunkGroups = tsFileIOWriter.getDeviceChunkMetadataMap();
        RestorableTsFileIOWriter restorableTsFileIOWriter = new RestorableTsFileIOWriter(SystemFileFactory.INSTANCE.getFile(this.filePath));
        Map restoredChunkMetaDataListInChunkGroups = restorableTsFileIOWriter.getDeviceChunkMetadataMap();
        Assert.assertEquals((long)chunkMetaDataListInChunkGroups.size(), (long)restoredChunkMetaDataListInChunkGroups.size());
        for (Map.Entry entry1 : chunkMetaDataListInChunkGroups.entrySet()) {
            for (Map.Entry entry2 : restoredChunkMetaDataListInChunkGroups.entrySet()) {
                Assert.assertEquals(entry1.getKey(), entry2.getKey());
                Assert.assertEquals((long)((List)entry1.getValue()).size(), (long)((List)entry2.getValue()).size());
                for (int i = 0; i < ((List)entry1.getValue()).size(); ++i) {
                    ChunkMetadata chunkMetaData = (ChunkMetadata)((List)entry1.getValue()).get(i);
                    ChunkMetadata chunkMetadataRestore = (ChunkMetadata)((List)entry2.getValue()).get(i);
                    Assert.assertEquals((Object)chunkMetaData, (Object)chunkMetadataRestore);
                }
            }
        }
        restorableTsFileIOWriter.close();
        logger.info("syncClose..");
        this.processor.syncClose();
    }

    @Test
    public void testMultiFlush() throws IOException, WriteProcessException, MetadataException {
        logger.info("testWriteAndRestoreMetadata begin..");
        this.processor = new TsFileProcessor(this.storageGroup, SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, tsFileProcessor -> true, true, 64);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        tsFileProcessorInfo.addTSPMemCost(this.processor.getTsFileResource().calculateRamSize());
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        this.processor.query(this.deviceId, this.measurementId, this.dataType, this.encoding, this.props, this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)tsfileResourcesForQuery.isEmpty());
        for (int flushId = 0; flushId < 10; ++flushId) {
            for (int i = 1; i <= 10; ++i) {
                TSRecord record = new TSRecord((long)i, this.deviceId);
                record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)this.measurementId, (String)String.valueOf(i)));
                this.processor.insert(new InsertRowPlan(record));
            }
            this.processor.asyncFlush();
        }
        this.processor.syncFlush();
        tsfileResourcesForQuery.clear();
        this.processor.query(this.deviceId, this.measurementId, this.dataType, this.encoding, this.props, this.context, tsfileResourcesForQuery);
        Assert.assertFalse((boolean)tsfileResourcesForQuery.isEmpty());
        TestCase.assertTrue((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk().isEmpty());
        Assert.assertEquals((long)10L, (long)((TsFileResource)tsfileResourcesForQuery.get(0)).getChunkMetadataList().size());
        Assert.assertEquals((Object)this.measurementId, (Object)((ChunkMetadata)((TsFileResource)tsfileResourcesForQuery.get(0)).getChunkMetadataList().get(0)).getMeasurementUid());
        Assert.assertEquals((Object)this.dataType, (Object)((ChunkMetadata)((TsFileResource)tsfileResourcesForQuery.get(0)).getChunkMetadataList().get(0)).getDataType());
        this.processor.syncClose();
    }

    @Test
    public void testWriteAndClose() throws IOException, WriteProcessException, MetadataException {
        logger.info("testWriteAndRestoreMetadata begin..");
        this.processor = new TsFileProcessor(this.storageGroup, SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, tsFileProcessor -> true, true, 64);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        tsFileProcessorInfo.addTSPMemCost(this.processor.getTsFileResource().calculateRamSize());
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        this.processor.query(this.deviceId, this.measurementId, this.dataType, this.encoding, this.props, this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)tsfileResourcesForQuery.isEmpty());
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)this.measurementId, (String)String.valueOf(i)));
            this.processor.insert(new InsertRowPlan(record));
        }
        tsfileResourcesForQuery.clear();
        this.processor.query(this.deviceId, this.measurementId, this.dataType, this.encoding, this.props, this.context, tsfileResourcesForQuery);
        Assert.assertFalse((boolean)tsfileResourcesForQuery.isEmpty());
        Assert.assertFalse((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk().isEmpty());
        List memChunks = ((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk();
        for (ReadOnlyMemChunk chunk : memChunks) {
            IPointReader iterator = chunk.getPointReader();
            for (int num = 1; num <= 100; ++num) {
                iterator.hasNextTimeValuePair();
                TimeValuePair timeValuePair = iterator.nextTimeValuePair();
                Assert.assertEquals((long)num, (long)timeValuePair.getTimestamp());
                Assert.assertEquals((long)num, (long)timeValuePair.getValue().getInt());
            }
        }
        this.processor.syncClose();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TestCase.assertTrue((boolean)this.processor.getTsFileResource().isClosed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTsFileProcessor(TsFileProcessor unsealedTsFileProcessor) throws TsFileProcessorException {
        TsFileResource resource;
        TsFileResource tsFileResource = resource = unsealedTsFileProcessor.getTsFileResource();
        synchronized (tsFileResource) {
            for (String deviceId : resource.getDevices()) {
                resource.updateEndTime(deviceId, resource.getStartTime(deviceId));
            }
            try {
                resource.close();
            }
            catch (IOException e) {
                throw new TsFileProcessorException((Exception)e);
            }
        }
    }
}

