/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.MetadataManagerHelper;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StorageGroupProcessorTest {
    private String storageGroup = "root.vehicle.d0";
    private String systemDir = TestConstant.OUTPUT_DATA_DIR.concat("info");
    private String deviceId = "root.vehicle.d0";
    private String measurementId = "s0";
    private StorageGroupProcessor processor;
    private QueryContext context = EnvironmentUtils.TEST_QUERY_CONTEXT;

    @Before
    public void setUp() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.NO_COMPACTION);
        MetadataManagerHelper.initMetadata();
        EnvironmentUtils.envSetUp();
        this.processor = new DummySGP(this.systemDir, this.storageGroup);
        MergeManager.getINSTANCE().start();
    }

    @After
    public void tearDown() throws Exception {
        this.processor.syncDeleteDataFiles();
        EnvironmentUtils.cleanEnv();
        EnvironmentUtils.cleanDir(TestConstant.OUTPUT_DATA_DIR);
        MergeManager.getINSTANCE().stop();
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
    }

    private void insertToStorageGroupProcessor(TSRecord record) throws WriteProcessException, IllegalPathException {
        InsertRowPlan insertRowPlan = new InsertRowPlan(record);
        this.processor.insert(insertRowPlan);
    }

    @Test
    public void testUnseqUnsealedDelete() throws WriteProcessException, IOException, MetadataException {
        TSRecord record = new TSRecord(10000L, this.deviceId);
        record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(1000)));
        this.processor.insert(new InsertRowPlan(record));
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (int j = 1; j <= 10; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
        }
        for (Object tsfileProcessor : this.processor.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        for (int j = 11; j <= 20; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
        }
        this.processor.delete(new PartialPath(this.deviceId, this.measurementId), 0L, 15L, -1L);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        for (TsFileProcessor tsfileProcessor : this.processor.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.query(this.deviceId, this.measurementId, TSDataType.INT32, TSEncoding.RLE, Collections.emptyMap(), new QueryContext(), tsfileResourcesForQuery);
        }
        Assert.assertEquals((long)1L, (long)tsfileResourcesForQuery.size());
        Assert.assertEquals((long)0L, (long)((TsFileResource)tsfileResourcesForQuery.get(0)).getChunkMetadataList().size());
        List memChunks = ((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk();
        long time = 16L;
        for (ReadOnlyMemChunk memChunk : memChunks) {
            IPointReader iterator = memChunk.getPointReader();
            while (iterator.hasNextTimeValuePair()) {
                TimeValuePair timeValuePair = iterator.nextTimeValuePair();
                Assert.assertEquals((long)time++, (long)timeValuePair.getTimestamp());
            }
        }
    }

    @Test
    public void testSequenceSyncClose() throws WriteProcessException, QueryProcessException, IllegalPathException {
        for (int j = 1; j <= 10; ++j) {
            TSRecord record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = this.processor.query(new PartialPath(this.deviceId), this.measurementId, this.context, null, null);
        Assert.assertEquals((long)10L, (long)queryDataSource.getSeqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
    }

    @Test
    public void testInsertDataAndRemovePartitionAndInsert() throws WriteProcessException, QueryProcessException, IllegalPathException {
        TSRecord record;
        int j;
        for (j = 0; j < 10; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        this.processor.removePartitions((storageGroupName, timePartitionId) -> true);
        for (j = 0; j < 10; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = this.processor.query(new PartialPath(this.deviceId), this.measurementId, this.context, null, null);
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
    }

    @Test
    public void testIoTDBTabletWriteAndSyncClose() throws QueryProcessException, IllegalPathException {
        String[] measurements = new String[]{"s0", "s1"};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        MeasurementMNode[] measurementMNodes = new MeasurementMNode[]{new MeasurementMNode(null, "s0", new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), null), new MeasurementMNode(null, "s1", new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN), null)};
        InsertTabletPlan insertTabletPlan1 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        insertTabletPlan1.setMeasurementMNodes(measurementMNodes);
        long[] times = new long[100];
        Object[] columns = new Object[]{new int[100], new long[100]};
        for (int r = 0; r < 100; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        insertTabletPlan1.setTimes(times);
        insertTabletPlan1.setColumns(columns);
        insertTabletPlan1.setRowCount(times.length);
        this.processor.insertTablet(insertTabletPlan1);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        InsertTabletPlan insertTabletPlan2 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        insertTabletPlan2.setMeasurementMNodes(measurementMNodes);
        for (int r = 50; r < 149; ++r) {
            times[r - 50] = r;
            ((int[])columns[0])[r - 50] = 1;
            ((long[])columns[1])[r - 50] = 1L;
        }
        insertTabletPlan2.setTimes(times);
        insertTabletPlan2.setColumns(columns);
        insertTabletPlan2.setRowCount(times.length);
        this.processor.insertTablet(insertTabletPlan2);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        this.processor.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = this.processor.query(new PartialPath(this.deviceId), this.measurementId, this.context, null, null);
        Assert.assertEquals((long)2L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)1L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
    }

    @Test
    public void testSeqAndUnSeqSyncClose() throws WriteProcessException, QueryProcessException, IllegalPathException {
        TSRecord record;
        int j;
        for (j = 21; j <= 30; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (j = 10; j >= 1; --j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        QueryDataSource queryDataSource = this.processor.query(new PartialPath(this.deviceId), this.measurementId, this.context, null, null);
        Assert.assertEquals((long)10L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)10L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        for (TsFileResource resource : queryDataSource.getUnseqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
    }

    @Test
    public void testEnableDiscardOutOfOrderDataForInsertRowPlan() throws WriteProcessException, QueryProcessException, IllegalPathException, IOException {
        TSRecord record;
        int j;
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        boolean defaultValue = config.isEnableDiscardOutOfOrderData();
        config.setEnableDiscardOutOfOrderData(true);
        for (j = 21; j <= 30; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.insertToStorageGroupProcessor(record);
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (j = 10; j >= 1; --j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.insertToStorageGroupProcessor(record);
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (TsFileProcessor tsfileProcessor : this.processor.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        QueryDataSource queryDataSource = this.processor.query(new PartialPath(this.deviceId), this.measurementId, this.context, null, null);
        Assert.assertEquals((long)10L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        for (TsFileResource resource : queryDataSource.getUnseqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        config.setEnableDiscardOutOfOrderData(defaultValue);
    }

    @Test
    public void testEnableDiscardOutOfOrderDataForInsertTablet1() throws QueryProcessException, IllegalPathException, IOException {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        boolean defaultEnableDiscard = config.isEnableDiscardOutOfOrderData();
        long defaultTimePartition = config.getPartitionInterval();
        boolean defaultEnablePartition = config.isEnablePartition();
        config.setEnableDiscardOutOfOrderData(true);
        config.setEnablePartition(true);
        config.setPartitionInterval(100L);
        String[] measurements = new String[]{"s0", "s1"};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        MeasurementMNode[] measurementMNodes = new MeasurementMNode[]{new MeasurementMNode(null, "s0", new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), null), new MeasurementMNode(null, "s1", new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN), null)};
        InsertTabletPlan insertTabletPlan1 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        long[] times = new long[100];
        Object[] columns = new Object[]{new int[100], new long[100]};
        for (int r = 0; r < 100; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        insertTabletPlan1.setTimes(times);
        insertTabletPlan1.setColumns(columns);
        insertTabletPlan1.setRowCount(times.length);
        insertTabletPlan1.setMeasurementMNodes(measurementMNodes);
        this.processor.insertTablet(insertTabletPlan1);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        InsertTabletPlan insertTabletPlan2 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        for (int r = 149; r >= 50; --r) {
            times[r - 50] = r;
            ((int[])columns[0])[r - 50] = 1;
            ((long[])columns[1])[r - 50] = 1L;
        }
        insertTabletPlan2.setTimes(times);
        insertTabletPlan2.setColumns(columns);
        insertTabletPlan2.setRowCount(times.length);
        insertTabletPlan2.setMeasurementMNodes(measurementMNodes);
        this.processor.insertTablet(insertTabletPlan2);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (TsFileProcessor tsfileProcessor : this.processor.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        QueryDataSource queryDataSource = this.processor.query(new PartialPath(this.deviceId), this.measurementId, this.context, null, null);
        Assert.assertEquals((long)2L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        config.setEnableDiscardOutOfOrderData(defaultEnableDiscard);
        config.setPartitionInterval(defaultTimePartition);
        config.setEnablePartition(defaultEnablePartition);
    }

    @Test
    public void testEnableDiscardOutOfOrderDataForInsertTablet2() throws QueryProcessException, IllegalPathException, IOException {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        boolean defaultEnableDiscard = config.isEnableDiscardOutOfOrderData();
        long defaultTimePartition = config.getPartitionInterval();
        boolean defaultEnablePartition = config.isEnablePartition();
        config.setEnableDiscardOutOfOrderData(true);
        config.setEnablePartition(true);
        config.setPartitionInterval(1200L);
        String[] measurements = new String[]{"s0", "s1"};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        MeasurementMNode[] measurementMNodes = new MeasurementMNode[]{new MeasurementMNode(null, "s0", new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), null), new MeasurementMNode(null, "s1", new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN), null)};
        InsertTabletPlan insertTabletPlan1 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        long[] times = new long[1200];
        Object[] columns = new Object[]{new int[1200], new long[1200]};
        for (int r = 0; r < 1200; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        insertTabletPlan1.setTimes(times);
        insertTabletPlan1.setColumns(columns);
        insertTabletPlan1.setRowCount(times.length);
        insertTabletPlan1.setMeasurementMNodes(measurementMNodes);
        this.processor.insertTablet(insertTabletPlan1);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        InsertTabletPlan insertTabletPlan2 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        for (int r = 1249; r >= 50; --r) {
            times[r - 50] = r;
            ((int[])columns[0])[r - 50] = 1;
            ((long[])columns[1])[r - 50] = 1L;
        }
        insertTabletPlan2.setTimes(times);
        insertTabletPlan2.setColumns(columns);
        insertTabletPlan2.setRowCount(times.length);
        insertTabletPlan2.setMeasurementMNodes(measurementMNodes);
        this.processor.insertTablet(insertTabletPlan2);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (TsFileProcessor tsfileProcessor : this.processor.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        QueryDataSource queryDataSource = this.processor.query(new PartialPath(this.deviceId), this.measurementId, this.context, null, null);
        Assert.assertEquals((long)2L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        config.setEnableDiscardOutOfOrderData(defaultEnableDiscard);
        config.setPartitionInterval(defaultTimePartition);
        config.setEnablePartition(defaultEnablePartition);
    }

    @Test
    public void testEnableDiscardOutOfOrderDataForInsertTablet3() throws QueryProcessException, IllegalPathException, IOException {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        boolean defaultEnableDiscard = config.isEnableDiscardOutOfOrderData();
        long defaultTimePartition = config.getPartitionInterval();
        boolean defaultEnablePartition = config.isEnablePartition();
        config.setEnableDiscardOutOfOrderData(true);
        config.setEnablePartition(true);
        config.setPartitionInterval(1000L);
        String[] measurements = new String[]{"s0", "s1"};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        MeasurementMNode[] measurementMNodes = new MeasurementMNode[]{new MeasurementMNode(null, "s0", new MeasurementSchema("s0", TSDataType.INT32, TSEncoding.PLAIN), null), new MeasurementMNode(null, "s1", new MeasurementSchema("s1", TSDataType.INT64, TSEncoding.PLAIN), null)};
        InsertTabletPlan insertTabletPlan1 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        long[] times = new long[1200];
        Object[] columns = new Object[]{new int[1200], new long[1200]};
        for (int r = 0; r < 1200; ++r) {
            times[r] = r;
            ((int[])columns[0])[r] = 1;
            ((long[])columns[1])[r] = 1L;
        }
        insertTabletPlan1.setTimes(times);
        insertTabletPlan1.setColumns(columns);
        insertTabletPlan1.setRowCount(times.length);
        insertTabletPlan1.setMeasurementMNodes(measurementMNodes);
        this.processor.insertTablet(insertTabletPlan1);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        InsertTabletPlan insertTabletPlan2 = new InsertTabletPlan(new PartialPath("root.vehicle.d0"), measurements, dataTypes);
        for (int r = 1249; r >= 50; --r) {
            times[r - 50] = r;
            ((int[])columns[0])[r - 50] = 1;
            ((long[])columns[1])[r - 50] = 1L;
        }
        insertTabletPlan2.setTimes(times);
        insertTabletPlan2.setColumns(columns);
        insertTabletPlan2.setRowCount(times.length);
        insertTabletPlan2.setMeasurementMNodes(measurementMNodes);
        this.processor.insertTablet(insertTabletPlan2);
        this.processor.asyncCloseAllWorkingTsFileProcessors();
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (TsFileProcessor tsfileProcessor : this.processor.getWorkUnsequenceTsFileProcessors()) {
            tsfileProcessor.syncFlush();
        }
        QueryDataSource queryDataSource = this.processor.query(new PartialPath(this.deviceId), this.measurementId, this.context, null, null);
        Assert.assertEquals((long)2L, (long)queryDataSource.getSeqResources().size());
        Assert.assertEquals((long)0L, (long)queryDataSource.getUnseqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        config.setEnableDiscardOutOfOrderData(defaultEnableDiscard);
        config.setPartitionInterval(defaultTimePartition);
        config.setEnablePartition(defaultEnablePartition);
    }

    @Test
    public void testMerge() throws WriteProcessException, QueryProcessException, IllegalPathException {
        TSRecord record;
        int j;
        for (j = 21; j <= 30; ++j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        for (j = 10; j >= 1; --j) {
            record = new TSRecord((long)j, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT32, (String)this.measurementId, (String)String.valueOf(j)));
            this.processor.insert(new InsertRowPlan(record));
            this.processor.asyncCloseAllWorkingTsFileProcessors();
        }
        this.processor.syncCloseAllWorkingTsFileProcessors();
        this.processor.merge();
        while (this.processor.getTsFileManagement().isUnseqMerging) {
        }
        QueryDataSource queryDataSource = this.processor.query(new PartialPath(this.deviceId), this.measurementId, this.context, null, null);
        Assert.assertEquals((long)10L, (long)queryDataSource.getSeqResources().size());
        for (TsFileResource resource : queryDataSource.getSeqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
        for (TsFileResource resource : queryDataSource.getUnseqResources()) {
            Assert.assertTrue((boolean)resource.isClosed());
        }
    }

    class DummySGP
    extends StorageGroupProcessor {
        DummySGP(String systemInfoDir, String storageGroupName) throws StorageGroupProcessorException {
            super(systemInfoDir, storageGroupName, (TsFileFlushPolicy)new TsFileFlushPolicy.DirectFlushPolicy(), storageGroupName);
        }
    }
}

