/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Before;

abstract class MergeTest {
    static final String MERGE_TEST_SG = "root.mergeTest";
    int seqFileNum = 5;
    int unseqFileNum = 5;
    int measurementNum = 10;
    int deviceNum = 10;
    long ptNum = 100L;
    long flushInterval = 20L;
    TSEncoding encoding = TSEncoding.PLAIN;
    String[] deviceIds;
    MeasurementSchema[] measurementSchemas;
    List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    List<TsFileResource> unseqResources = new ArrayList<TsFileResource>();
    private int prevMergeChunkThreshold;

    MergeTest() {
    }

    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        IoTDB.metaManager.init();
        this.prevMergeChunkThreshold = IoTDBDescriptor.getInstance().getConfig().getMergeChunkPointNumberThreshold();
        IoTDBDescriptor.getInstance().getConfig().setMergeChunkPointNumberThreshold(-1);
        this.prepareSeries();
        this.prepareFiles(this.seqFileNum, this.unseqFileNum);
        MergeManager.getINSTANCE().start();
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        this.removeFiles(this.seqResources, this.unseqResources);
        this.seqResources.clear();
        this.unseqResources.clear();
        IoTDBDescriptor.getInstance().getConfig().setMergeChunkPointNumberThreshold(this.prevMergeChunkThreshold);
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        IoTDB.metaManager.clear();
        EnvironmentUtils.cleanAllDir();
        MergeManager.getINSTANCE().stop();
    }

    private void prepareSeries() throws MetadataException {
        int i;
        this.measurementSchemas = new MeasurementSchema[this.measurementNum];
        for (i = 0; i < this.measurementNum; ++i) {
            this.measurementSchemas[i] = new MeasurementSchema("sensor" + i, TSDataType.DOUBLE, this.encoding, CompressionType.UNCOMPRESSED);
        }
        this.deviceIds = new String[this.deviceNum];
        for (i = 0; i < this.deviceNum; ++i) {
            this.deviceIds[i] = "root.mergeTest.device" + i;
        }
        IoTDB.metaManager.setStorageGroup(new PartialPath(MERGE_TEST_SG));
        for (String device : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                PartialPath devicePath = new PartialPath(device);
                IoTDB.metaManager.createTimeseries(devicePath.concatNode(measurementSchema.getMeasurementId()), measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getCompressor(), Collections.emptyMap());
            }
        }
    }

    void prepareFiles(int seqFileNum, int unseqFileNum) throws IOException, WriteProcessException {
        TsFileResource tsFileResource;
        File file;
        int i;
        for (i = 0; i < seqFileNum; ++i) {
            file = new File(TestConstant.BASE_OUTPUT_PATH.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile"));
            tsFileResource = new TsFileResource(file);
            tsFileResource.setClosed(true);
            tsFileResource.setMinPlanIndex((long)i);
            tsFileResource.setMaxPlanIndex((long)i);
            tsFileResource.setVersion((long)i);
            this.seqResources.add(tsFileResource);
            this.prepareFile(tsFileResource, (long)i * this.ptNum, this.ptNum, 0L);
        }
        for (i = 0; i < unseqFileNum; ++i) {
            file = new File(TestConstant.BASE_OUTPUT_PATH.concat(10000 + i + "-" + (10000 + i) + "-" + 0 + "-" + 0 + ".tsfile"));
            tsFileResource = new TsFileResource(file);
            tsFileResource.setClosed(true);
            tsFileResource.setMinPlanIndex((long)(i + seqFileNum));
            tsFileResource.setMaxPlanIndex((long)(i + seqFileNum));
            tsFileResource.setVersion((long)(i + seqFileNum));
            this.unseqResources.add(tsFileResource);
            this.prepareFile(tsFileResource, (long)i * this.ptNum, this.ptNum * (long)(i + 1) / (long)unseqFileNum, 10000L);
        }
        File file2 = new File(TestConstant.BASE_OUTPUT_PATH.concat(unseqFileNum + "-" + unseqFileNum + "-" + 0 + "-" + 0 + ".tsfile"));
        TsFileResource tsFileResource2 = new TsFileResource(file2);
        tsFileResource2.setClosed(true);
        tsFileResource2.setMinPlanIndex((long)(seqFileNum + unseqFileNum));
        tsFileResource2.setMaxPlanIndex((long)(seqFileNum + unseqFileNum));
        tsFileResource2.setVersion((long)(seqFileNum + unseqFileNum));
        this.unseqResources.add(tsFileResource2);
        this.prepareFile(tsFileResource2, 0L, this.ptNum * (long)unseqFileNum, 20000L);
    }

    void removeFiles(List<TsFileResource> seqResList, List<TsFileResource> unseqResList) throws IOException {
        for (TsFileResource tsFileResource : seqResList) {
            tsFileResource.remove();
            tsFileResource.getModFile().remove();
        }
        for (TsFileResource tsFileResource : unseqResList) {
            tsFileResource.remove();
            tsFileResource.getModFile().remove();
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FileReaderManager.getInstance().stop();
    }

    void prepareFile(TsFileResource tsFileResource, long timeOffset, long ptNum, long valueOffset) throws IOException, WriteProcessException {
        TsFileWriter fileWriter = new TsFileWriter(tsFileResource.getTsFile());
        for (String deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId, measurementSchema.getMeasurementId()), measurementSchema);
            }
        }
        for (long i = timeOffset; i < timeOffset + ptNum; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i + valueOffset)));
                }
                fileWriter.write(record);
                tsFileResource.updateStartTime(this.deviceIds[j], i);
                tsFileResource.updateEndTime(this.deviceIds[j], i);
            }
            if ((i + 1L) % this.flushInterval != 0L) continue;
            fileWriter.flushAllChunkGroups();
        }
        fileWriter.close();
    }
}

