/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.merge.MergeTest;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.task.MergeTask;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MergeTaskTest
extends MergeTest {
    private File tempSGDir;

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    @Test
    public void testMerge() throws Exception {
        MergeTask mergeTask = new MergeTask(new MergeResource(this.seqResources, this.unseqResources), this.tempSGDir.getPath(), (k, v, l) -> {}, "test", false, 1, "root.mergeTest");
        mergeTask.call();
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        ArrayList<TsFileResource> list = new ArrayList<TsFileResource>();
        list.add((TsFileResource)this.seqResources.get(0));
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, list, new ArrayList(), null, null, true);
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)((double)batchData.getTimeByIndex(i) + 20000.0), (double)batchData.getDoubleByIndex(i), (double)0.001);
            }
        }
        tsFilesReader.close();
    }

    @Test
    public void testMergeEndTime() throws Exception {
        List testSeqResources = this.seqResources.subList(0, 3);
        List testUnseqResource = this.unseqResources.subList(5, 6);
        MergeTask mergeTask = new MergeTask(new MergeResource(testSeqResources, testUnseqResource), this.tempSGDir.getPath(), (k, v, l) -> Assert.assertEquals((long)499L, (long)((TsFileResource)k.get(2)).getEndTime("root.mergeTest.device1")), "test", false, 1, "root.mergeTest");
        mergeTask.call();
    }

    @Test
    public void testMergeEndTimeAfterDeletion() throws Exception {
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("10unseq-10-10-0.tsfile"));
        TsFileResource smallUnseqTsFileResource = new TsFileResource(file);
        smallUnseqTsFileResource.setClosed(true);
        smallUnseqTsFileResource.setMinPlanIndex(10L);
        smallUnseqTsFileResource.setMaxPlanIndex(10L);
        smallUnseqTsFileResource.setVersion(10L);
        this.prepareFile(smallUnseqTsFileResource, 0L, 50L, 0L);
        this.unseqResources.add(smallUnseqTsFileResource);
        for (String deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                PartialPath device = new PartialPath(deviceId);
                ((TsFileResource)this.seqResources.get(0)).getModFile().write((Modification)new Deletion(device.concatNode(measurementSchema.getMeasurementId()), ((TsFileResource)this.seqResources.get(0)).getTsFileSize(), Long.MIN_VALUE, Long.MAX_VALUE));
            }
        }
        List testSeqResources = this.seqResources.subList(0, 1);
        ArrayList<TsFileResource> testUnseqResources = new ArrayList<TsFileResource>();
        testUnseqResources.add(smallUnseqTsFileResource);
        MergeTask mergeTask = new MergeTask(new MergeResource(testSeqResources, testUnseqResources), this.tempSGDir.getPath(), (k, v, l) -> Assert.assertEquals((long)49L, (long)((TsFileResource)k.get(0)).getEndTime("root.mergeTest.device1")), "test", false, 1, "root.mergeTest");
        mergeTask.call();
    }

    @Test
    public void testFullMerge() throws Exception {
        MergeTask mergeTask = new MergeTask(new MergeResource(this.seqResources, this.unseqResources), this.tempSGDir.getPath(), (k, v, l) -> {}, "test", true, 1, "root.mergeTest");
        mergeTask.call();
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        ArrayList<TsFileResource> list = new ArrayList<TsFileResource>();
        list.add((TsFileResource)this.seqResources.get(0));
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, list, new ArrayList(), null, null, true);
        long count = 0L;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int t = 0; t < batchData.length(); ++t) {
                Assert.assertEquals((double)((double)batchData.getTimeByIndex(t) + 20000.0), (double)batchData.getDoubleByIndex(t), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)100L, (long)count);
        tsFilesReader.close();
    }

    @Test
    public void testChunkNumThreshold() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setMergeChunkPointNumberThreshold(Integer.MAX_VALUE);
        MergeTask mergeTask = new MergeTask(new MergeResource(this.seqResources, this.unseqResources), this.tempSGDir.getPath(), (k, v, l) -> {}, "test", false, 1, "root.mergeTest");
        mergeTask.call();
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        resources.add((TsFileResource)this.seqResources.get(0));
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, resources, new ArrayList(), null, null, true);
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)((double)batchData.getTimeByIndex(i) + 20000.0), (double)batchData.getDoubleByIndex(i), (double)0.001);
            }
        }
        tsFilesReader.close();
    }

    @Test
    public void testPartialMerge1() throws Exception {
        MergeTask mergeTask = new MergeTask(new MergeResource(this.seqResources, this.unseqResources.subList(0, 1)), this.tempSGDir.getPath(), (k, v, l) -> {}, "test", false, 1, "root.mergeTest");
        mergeTask.call();
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        ArrayList<TsFileResource> list = new ArrayList<TsFileResource>();
        list.add((TsFileResource)this.seqResources.get(0));
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, list, new ArrayList(), null, null, true);
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                if (batchData.getTimeByIndex(i) < 20L) {
                    Assert.assertEquals((double)((double)batchData.getTimeByIndex(i) + 10000.0), (double)batchData.getDoubleByIndex(i), (double)0.001);
                    continue;
                }
                Assert.assertEquals((double)((double)batchData.getTimeByIndex(i) + 0.0), (double)batchData.getDoubleByIndex(i), (double)0.001);
            }
        }
        tsFilesReader.close();
    }

    @Test
    public void testPartialMerge2() throws Exception {
        MergeTask mergeTask = new MergeTask(new MergeResource(this.seqResources, this.unseqResources.subList(5, 6)), this.tempSGDir.getPath(), (k, v, l) -> {}, "test", false, 1, "root.mergeTest");
        mergeTask.call();
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        ArrayList<TsFileResource> list = new ArrayList<TsFileResource>();
        list.add((TsFileResource)this.seqResources.get(0));
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, list, new ArrayList(), null, null, true);
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)((double)batchData.getTimeByIndex(i) + 20000.0), (double)batchData.getDoubleByIndex(i), (double)0.001);
            }
        }
        tsFilesReader.close();
    }

    @Test
    public void testPartialMerge3() throws Exception {
        MergeTask mergeTask = new MergeTask(new MergeResource(this.seqResources, this.unseqResources.subList(0, 5)), this.tempSGDir.getPath(), (k, v, l) -> {}, "test", false, 1, "root.mergeTest");
        mergeTask.call();
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        ArrayList<TsFileResource> list = new ArrayList<TsFileResource>();
        list.add((TsFileResource)this.seqResources.get(2));
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, list, new ArrayList(), null, null, true);
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                if (batchData.getTimeByIndex(i) < 260L) {
                    Assert.assertEquals((double)((double)batchData.getTimeByIndex(i) + 10000.0), (double)batchData.getDoubleByIndex(i), (double)0.001);
                    continue;
                }
                Assert.assertEquals((double)((double)batchData.getTimeByIndex(i) + 0.0), (double)batchData.getDoubleByIndex(i), (double)0.001);
            }
        }
        tsFilesReader.close();
    }

    @Test
    public void mergeWithDeletionTest() throws Exception {
        try {
            PartialPath device = new PartialPath(this.deviceIds[0]);
            ((TsFileResource)this.seqResources.get(0)).getModFile().write((Modification)new Deletion(device.concatNode(this.measurementSchemas[0].getMeasurementId()), ((TsFileResource)this.seqResources.get(0)).getTsFileSize(), 0L, 49L));
        }
        finally {
            ((TsFileResource)this.seqResources.get(0)).getModFile().close();
        }
        MergeTask mergeTask = new MergeTask(new MergeResource(this.seqResources, this.unseqResources.subList(0, 1)), this.tempSGDir.getPath(), (k, v, l) -> {
            try {
                ((TsFileResource)this.seqResources.get(0)).removeModFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, "test", false, 1, "root.mergeTest");
        mergeTask.call();
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        resources.add((TsFileResource)this.seqResources.get(0));
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, resources, new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                if (batchData.getTimeByIndex(i) <= 20L) {
                    Assert.assertEquals((double)((double)batchData.getTimeByIndex(i) + 10000.0), (double)batchData.getDoubleByIndex(i), (double)0.001);
                } else {
                    Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                }
                ++count;
            }
        }
        Assert.assertEquals((long)70L, (long)count);
        tsFilesReader.close();
    }

    @Test
    public void testOnlyUnseqMerge() throws Exception {
        ArrayList testSeqResources = new ArrayList();
        List testUnseqResource = this.unseqResources.subList(5, 6);
        MergeTask mergeTask = new MergeTask(new MergeResource(testSeqResources, testUnseqResource), this.tempSGDir.getPath(), (k, v, l) -> {}, "test", false, 1, "root.mergeTest");
        mergeTask.call();
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        resources.add((TsFileResource)this.seqResources.get(2));
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, resources, new ArrayList(), null, null, true);
        boolean count = false;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)((double)batchData.getTimeByIndex(i) + 0.0), (double)batchData.getDoubleByIndex(i), (double)0.001);
            }
        }
        tsFilesReader.close();
    }

    @Test
    public void testMergeWithFileWithoutSomeSensor() throws Exception {
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("10unseq-10-10-0.tsfile"));
        TsFileResource unseqTsFileResourceWithoutSomeSensor = new TsFileResource(file);
        unseqTsFileResourceWithoutSomeSensor.setClosed(true);
        unseqTsFileResourceWithoutSomeSensor.setMinPlanIndex(10L);
        unseqTsFileResourceWithoutSomeSensor.setMaxPlanIndex(10L);
        unseqTsFileResourceWithoutSomeSensor.setVersion(10L);
        this.prepareFileWithLastSensor(unseqTsFileResourceWithoutSomeSensor, 0L, 50L, 0L);
        this.unseqResources.add(unseqTsFileResourceWithoutSomeSensor);
        List testSeqResources = this.seqResources.subList(0, 1);
        ArrayList<TsFileResource> testUnseqResources = new ArrayList<TsFileResource>();
        testUnseqResources.add(unseqTsFileResourceWithoutSomeSensor);
        MergeTask mergeTask = new MergeTask(new MergeResource(testSeqResources, testUnseqResources), this.tempSGDir.getPath(), (k, v, l) -> Assert.assertEquals((long)99L, (long)((TsFileResource)k.get(0)).getEndTime("root.mergeTest.device1")), "test", false, 1, "root.mergeTest");
        mergeTask.call();
    }

    private void prepareFileWithLastSensor(TsFileResource tsFileResource, long timeOffset, long ptNum, long valueOffset) throws IOException, WriteProcessException {
        TsFileWriter fileWriter = new TsFileWriter(tsFileResource.getTsFile());
        for (int i = 0; i < this.deviceIds.length - 1; ++i) {
            for (int j = 0; j < this.measurementSchemas.length - 1; ++j) {
                fileWriter.registerTimeseries(new Path(this.deviceIds[i], this.measurementSchemas[j].getMeasurementId()), this.measurementSchemas[j]);
            }
        }
        for (long i = timeOffset; i < timeOffset + ptNum; ++i) {
            for (int j = 0; j < this.deviceNum - 1; ++j) {
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum - 1; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i + valueOffset)));
                }
                fileWriter.write(record);
                tsFileResource.updateStartTime(this.deviceIds[j], i);
                tsFileResource.updateEndTime(this.deviceIds[j], i);
            }
            if ((i + 1L) % this.flushInterval != 0L) continue;
            fileWriter.flushAllChunkGroups();
        }
        fileWriter.close();
    }
}

