/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.merge.MergeTest;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.task.MergeTask;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class MergePerfTest
extends MergeTest {
    private long timeConsumption;
    private boolean fullMerge;
    private File tempSGDir;

    public void test() throws Exception {
        IoTDB.metaManager.init();
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
        this.setUp();
        this.timeConsumption = System.currentTimeMillis();
        MergeResource resource = new MergeResource(this.seqResources, this.unseqResources);
        resource.setCacheDeviceMeta(true);
        MergeTask mergeTask = new MergeTask(resource, this.tempSGDir.getPath(), (k, v, l) -> {}, "test", this.fullMerge, 100, "root.mergeTest");
        mergeTask.call();
        this.timeConsumption = System.currentTimeMillis() - this.timeConsumption;
        this.tearDown();
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    public static void main(String[] args) throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setMergeChunkPointNumberThreshold(-1);
        ArrayList timeConsumptions = new ArrayList();
        MergePerfTest perfTest = new MergePerfTest();
        perfTest.seqFileNum = 5;
        perfTest.unseqFileNum = 5;
        perfTest.measurementNum = 100;
        perfTest.deviceNum = 10;
        perfTest.ptNum = 5000L;
        perfTest.flushInterval = 1000L;
        perfTest.fullMerge = true;
        perfTest.encoding = TSEncoding.PLAIN;
        for (int i = 0; i < 1; ++i) {
            perfTest.test();
        }
        System.out.println(timeConsumptions);
    }
}

