/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.merge.MergeTest;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.task.MergeTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MergeOverLapTest
extends MergeTest {
    private File tempSGDir;

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        this.ptNum = 1000L;
        super.setUp();
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    @Override
    void prepareFiles(int seqFileNum, int unseqFileNum) throws IOException, WriteProcessException {
        TsFileResource tsFileResource;
        File file;
        int i;
        for (i = 0; i < seqFileNum; ++i) {
            file = new File(TestConstant.BASE_OUTPUT_PATH.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile"));
            tsFileResource = new TsFileResource(file);
            tsFileResource.setClosed(true);
            tsFileResource.setMinPlanIndex((long)i);
            tsFileResource.setMaxPlanIndex((long)i);
            this.seqResources.add(tsFileResource);
            this.prepareFile(tsFileResource, (long)i * this.ptNum, this.ptNum, 0L);
        }
        for (i = 0; i < unseqFileNum; ++i) {
            file = new File(TestConstant.BASE_OUTPUT_PATH.concat(10000 + i + "-" + (10000 + i) + "-" + 0 + "-" + 0 + ".tsfile"));
            tsFileResource = new TsFileResource(file);
            tsFileResource.setClosed(true);
            tsFileResource.setMaxPlanIndex((long)(i + seqFileNum));
            tsFileResource.setMinPlanIndex((long)(i + seqFileNum));
            this.unseqResources.add(tsFileResource);
            this.prepareUnseqFile(tsFileResource, (long)i * this.ptNum, this.ptNum * (long)(i + 1) / (long)unseqFileNum, 10000L);
        }
        File file2 = new File(TestConstant.BASE_OUTPUT_PATH.concat(unseqFileNum + "-" + unseqFileNum + "-" + 0 + "-" + 0 + ".tsfile"));
        TsFileResource tsFileResource2 = new TsFileResource(file2);
        tsFileResource2.setClosed(true);
        tsFileResource2.setMinPlanIndex((long)(seqFileNum + unseqFileNum));
        tsFileResource2.setMaxPlanIndex((long)(seqFileNum + unseqFileNum));
        this.unseqResources.add(tsFileResource2);
        this.prepareUnseqFile(tsFileResource2, 0L, this.ptNum * (long)unseqFileNum, 20000L);
    }

    private void prepareUnseqFile(TsFileResource tsFileResource, long timeOffset, long ptNum, long valueOffset) throws IOException, WriteProcessException {
        TsFileWriter fileWriter = new TsFileWriter(tsFileResource.getTsFile());
        for (String deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId, measurementSchema.getMeasurementId()), measurementSchema);
            }
        }
        for (long i = timeOffset; i < timeOffset + ptNum; ++i) {
            TSRecord record;
            int j;
            for (j = 0; j < this.deviceNum; ++j) {
                record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i + valueOffset)));
                }
                fileWriter.write(record);
                tsFileResource.updateStartTime(this.deviceIds[j], i);
                tsFileResource.updateEndTime(this.deviceIds[j], i);
            }
            if ((i + 1L) % 100L == 0L) {
                for (j = 0; j < this.deviceNum; ++j) {
                    record = new TSRecord(i, this.deviceIds[j]);
                    for (int k = 0; k < this.measurementNum; ++k) {
                        record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i + valueOffset)));
                    }
                    fileWriter.write(record);
                    tsFileResource.updateStartTime(this.deviceIds[j], i);
                    tsFileResource.updateEndTime(this.deviceIds[j], i);
                }
            }
            if ((i + 1L) % this.flushInterval != 0L) continue;
            fileWriter.flushAllChunkGroups();
        }
        fileWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFullMerge() throws Exception {
        MergeTask mergeTask = new MergeTask(new MergeResource(this.seqResources, this.unseqResources), this.tempSGDir.getPath(), (k, v, l) -> {}, "test", true, 1, "root.mergeTest");
        mergeTask.call();
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        resources.add((TsFileResource)this.seqResources.get(0));
        int cnt = 0;
        try (SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, resources, new ArrayList(), null, null, true);){
            while (tsFilesReader.hasNextBatch()) {
                BatchData batchData = tsFilesReader.nextBatch();
                for (int i = 0; i < batchData.length(); ++i) {
                    ++cnt;
                    Assert.assertEquals((double)((double)batchData.getTimeByIndex(i) + 20000.0), (double)batchData.getDoubleByIndex(i), (double)0.001);
                }
            }
            Assert.assertEquals((long)1000L, (long)cnt);
        }
    }
}

