/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge;

import com.google.common.util.concurrent.RateLimiter;
import java.util.PriorityQueue;
import org.apache.iotdb.db.engine.merge.MergeTest;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.engine.merge.task.MergeMultiChunkTask;
import org.apache.iotdb.db.engine.merge.task.MergeTask;
import org.junit.Assert;
import org.junit.Test;

public class MergeManagerTest
extends MergeTest {
    @Test
    public void testRateLimiter() {
        RateLimiter compactionRateLimiter = MergeManager.getINSTANCE().getMergeWriteRateLimiter();
        long startTime = System.currentTimeMillis();
        MergeManager.mergeRateLimiterAcquire((RateLimiter)compactionRateLimiter, (long)0xA000000L);
        Assert.assertTrue((System.currentTimeMillis() - startTime <= 1000L ? 1 : 0) != 0);
        MergeManager.mergeRateLimiterAcquire((RateLimiter)compactionRateLimiter, (long)0x1000000L);
        Assert.assertTrue((System.currentTimeMillis() - startTime >= 9000L ? 1 : 0) != 0);
    }

    @Test
    public void testGenMergeReport() {
        FakedMergeMultiChunkTask chunkTask = new FakedMergeMultiChunkTask();
        for (int i = 0; i < 5; ++i) {
            MergeManager.getINSTANCE().submitMainTask((MergeTask)new FakedMainMergeTask(i));
            MergeManager.getINSTANCE().submitChunkSubTask(chunkTask.createSubTask(i));
        }
        String report = MergeManager.getINSTANCE().genMergeTaskReport();
        this.checkReport(report);
    }

    @Test
    public void testAbortMerge() {
        FakedMergeMultiChunkTask chunkTask = new FakedMergeMultiChunkTask();
        for (int i = 0; i < 5; ++i) {
            MergeManager.getINSTANCE().submitMainTask((MergeTask)new FakedMainMergeTask(i));
            MergeManager.getINSTANCE().submitChunkSubTask(chunkTask.createSubTask(i));
        }
        MergeManager.getINSTANCE().abortMerge("non-exist");
        String report = MergeManager.getINSTANCE().genMergeTaskReport();
        this.checkReport(report);
        MergeManager.getINSTANCE().abortMerge("test");
        report = MergeManager.getINSTANCE().genMergeTaskReport();
        Assert.assertEquals((Object)String.format("Main tasks:%nSub tasks:%n", new Object[0]), (Object)report);
    }

    private void checkReport(String report) {
        int i;
        String[] split = report.split(System.lineSeparator());
        Assert.assertEquals((Object)"Main tasks:", (Object)split[0]);
        Assert.assertEquals((Object)"\tStorage group: test", (Object)split[1]);
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)split[2 + i].contains("task" + i));
            Assert.assertTrue((boolean)split[2 + i].contains("0,"));
            Assert.assertTrue((boolean)split[2 + i].contains("done:false"));
            Assert.assertTrue((boolean)split[2 + i].contains("cancelled:false"));
        }
        Assert.assertEquals((Object)"Sub tasks:", (Object)split[7]);
        Assert.assertEquals((Object)"\tStorage group: test", (Object)split[8]);
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)split[9 + i].contains("task" + i));
            Assert.assertTrue((boolean)split[9 + i].contains("0,"));
            Assert.assertTrue((boolean)split[9 + i].contains("done:false"));
            Assert.assertTrue((boolean)split[9 + i].contains("cancelled:false"));
        }
    }

    static class FakedMergeMultiChunkTask
    extends MergeMultiChunkTask {
        public FakedMergeMultiChunkTask() {
            super(null, null, null, null, false, null, 0, null);
        }

        public MergeMultiChunkTask.MergeChunkHeapTask createSubTask(int serialNum) {
            return new FakedSubMergeTask(serialNum);
        }

        class FakedSubMergeTask
        extends MergeMultiChunkTask.MergeChunkHeapTask {
            private int serialNum;
            private String progress;

            public FakedSubMergeTask(int serialNum) {
                super((MergeMultiChunkTask)FakedMergeMultiChunkTask.this, new PriorityQueue(), null, null, null, null, null, null, false, serialNum);
                this.progress = "0";
                this.serialNum = serialNum;
            }

            public Void call() {
                while (!Thread.currentThread().isInterrupted()) {
                }
                this.progress = "1";
                return null;
            }

            public String getStorageGroupName() {
                return "test";
            }

            public String getProgress() {
                return this.progress;
            }

            public String getTaskName() {
                return "task" + this.serialNum;
            }
        }
    }

    static class FakedMainMergeTask
    extends MergeTask {
        private int serialNum;
        private String progress = "0";

        public FakedMainMergeTask(int serialNum) {
            super(null, null, null, null, false, 0, null);
            this.serialNum = serialNum;
        }

        public Void call() {
            while (!Thread.currentThread().isInterrupted()) {
            }
            this.progress = "1";
            return null;
        }

        public String getStorageGroupName() {
            return "test";
        }

        public String getProgress() {
            return this.progress;
        }

        public String getTaskName() {
            return "task" + this.serialNum;
        }
    }
}

