/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.engine.merge.MergeTest;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.selector.MaxSeriesMergeFileSelector;
import org.apache.iotdb.db.exception.MergeException;
import org.junit.Assert;
import org.junit.Test;

public class MaxSeriesMergeFileSelectorTest
extends MergeTest {
    @Test
    public void testFullSelection() throws MergeException, IOException {
        MergeResource resource = new MergeResource(this.seqResources, this.unseqResources);
        MaxSeriesMergeFileSelector mergeFileSelector = new MaxSeriesMergeFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        List seqSelected = result[0];
        List unseqSelected = result[1];
        Assert.assertEquals((Object)this.seqResources, (Object)seqSelected);
        Assert.assertEquals((Object)this.unseqResources, (Object)unseqSelected);
        Assert.assertEquals((long)1024L, (long)mergeFileSelector.getConcurrentMergeNum());
        resource.clear();
        resource = new MergeResource(this.seqResources.subList(0, 1), this.unseqResources);
        mergeFileSelector = new MaxSeriesMergeFileSelector(resource, Long.MAX_VALUE);
        result = mergeFileSelector.select();
        seqSelected = result[0];
        unseqSelected = result[1];
        Assert.assertEquals(this.seqResources.subList(0, 1), (Object)seqSelected);
        Assert.assertEquals((Object)this.unseqResources, (Object)unseqSelected);
        Assert.assertEquals((long)1024L, (long)mergeFileSelector.getConcurrentMergeNum());
        resource.clear();
        resource = new MergeResource(this.seqResources, this.unseqResources.subList(0, 1));
        mergeFileSelector = new MaxSeriesMergeFileSelector(resource, Long.MAX_VALUE);
        result = mergeFileSelector.select();
        seqSelected = result[0];
        unseqSelected = result[1];
        Assert.assertEquals(this.seqResources.subList(0, 1), (Object)seqSelected);
        Assert.assertEquals(this.unseqResources.subList(0, 1), (Object)unseqSelected);
        Assert.assertEquals((long)1024L, (long)mergeFileSelector.getConcurrentMergeNum());
        resource.clear();
    }

    @Test
    public void testNonSelection() throws MergeException, IOException {
        MergeResource resource = new MergeResource(this.seqResources, this.unseqResources);
        MaxSeriesMergeFileSelector mergeFileSelector = new MaxSeriesMergeFileSelector(resource, 1L);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)0L, (long)result.length);
        Assert.assertEquals((long)0L, (long)mergeFileSelector.getConcurrentMergeNum());
        resource.clear();
    }

    @Test
    public void testRestrictedSelection() throws MergeException, IOException {
        MergeResource resource = new MergeResource(this.seqResources, this.unseqResources);
        MaxSeriesMergeFileSelector mergeFileSelector = new MaxSeriesMergeFileSelector(resource, 400000L);
        List[] result = mergeFileSelector.select();
        List seqSelected = result[0];
        List unseqSelected = result[1];
        Assert.assertEquals(this.seqResources.subList(0, 4), (Object)seqSelected);
        Assert.assertEquals(this.unseqResources.subList(0, 4), (Object)unseqSelected);
        Assert.assertEquals((long)1024L, (long)mergeFileSelector.getConcurrentMergeNum());
        resource.clear();
    }

    @Test
    public void testRestrictedSelection2() throws MergeException, IOException {
        MergeResource resource = new MergeResource(this.seqResources, this.unseqResources);
        MaxSeriesMergeFileSelector mergeFileSelector = new MaxSeriesMergeFileSelector(resource, 100000L);
        List[] result = mergeFileSelector.select();
        List seqSelected = result[0];
        List unseqSelected = result[1];
        Assert.assertEquals(this.seqResources.subList(0, 2), (Object)seqSelected);
        Assert.assertEquals(this.unseqResources.subList(0, 2), (Object)unseqSelected);
        resource.clear();
    }
}

