/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.merge.MergeTest;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.selector.MaxFileMergeFileSelector;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.timeindex.ITimeIndex;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.Assert;
import org.junit.Test;

public class MaxFileMergeFileSelectorTest
extends MergeTest {
    @Test
    public void testFullSelection() throws MergeException, IOException {
        MergeResource resource = new MergeResource(this.seqResources, this.unseqResources);
        MaxFileMergeFileSelector mergeFileSelector = new MaxFileMergeFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        List seqSelected = result[0];
        List unseqSelected = result[1];
        Assert.assertEquals((Object)this.seqResources, (Object)seqSelected);
        Assert.assertEquals((Object)this.unseqResources, (Object)unseqSelected);
        resource.clear();
        resource = new MergeResource(this.seqResources.subList(0, 1), this.unseqResources);
        mergeFileSelector = new MaxFileMergeFileSelector(resource, Long.MAX_VALUE);
        result = mergeFileSelector.select();
        seqSelected = result[0];
        unseqSelected = result[1];
        Assert.assertEquals(this.seqResources.subList(0, 1), (Object)seqSelected);
        Assert.assertEquals((Object)this.unseqResources, (Object)unseqSelected);
        resource.clear();
        resource = new MergeResource(this.seqResources, this.unseqResources.subList(0, 1));
        mergeFileSelector = new MaxFileMergeFileSelector(resource, Long.MAX_VALUE);
        result = mergeFileSelector.select();
        seqSelected = result[0];
        unseqSelected = result[1];
        Assert.assertEquals(this.seqResources.subList(0, 1), (Object)seqSelected);
        Assert.assertEquals(this.unseqResources.subList(0, 1), (Object)unseqSelected);
        resource.clear();
    }

    @Test
    public void testNonSelection() throws MergeException, IOException {
        MergeResource resource = new MergeResource(this.seqResources, this.unseqResources);
        MaxFileMergeFileSelector mergeFileSelector = new MaxFileMergeFileSelector(resource, 1L);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)0L, (long)result.length);
        resource.clear();
    }

    @Test
    public void testRestrictedSelection() throws MergeException, IOException {
        MergeResource resource = new MergeResource(this.seqResources, this.unseqResources);
        MaxFileMergeFileSelector mergeFileSelector = new MaxFileMergeFileSelector(resource, 400000L);
        List[] result = mergeFileSelector.select();
        List seqSelected = result[0];
        List unseqSelected = result[1];
        Assert.assertEquals(this.seqResources.subList(0, 4), (Object)seqSelected);
        Assert.assertEquals(this.unseqResources.subList(0, 4), (Object)unseqSelected);
        resource.clear();
    }

    @Test
    public void testFileOpenSelection() throws MergeException, IOException, WriteProcessException, NoSuchFieldException, IllegalAccessException {
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("10unseq-10-10-0.tsfile"));
        TsFileResource largeUnseqTsFileResource = new TsFileResource(file);
        this.unseqResources.add(largeUnseqTsFileResource);
        largeUnseqTsFileResource.setClosed(true);
        largeUnseqTsFileResource.setMinPlanIndex(10L);
        largeUnseqTsFileResource.setMaxPlanIndex(10L);
        largeUnseqTsFileResource.setVersion(10L);
        this.prepareFile(largeUnseqTsFileResource, 0L, (long)this.seqFileNum * this.ptNum, 0L);
        TsFileResource secondTsFileResource = (TsFileResource)this.seqResources.get(1);
        secondTsFileResource.setClosed(false);
        Set devices = secondTsFileResource.getDevices();
        Field timeIndexField = TsFileResource.class.getDeclaredField("timeIndex");
        timeIndexField.setAccessible(true);
        ITimeIndex timeIndex = (ITimeIndex)timeIndexField.get(secondTsFileResource);
        ITimeIndex newTimeIndex = IoTDBDescriptor.getInstance().getConfig().getTimeIndexLevel().getTimeIndex();
        for (String device : devices) {
            newTimeIndex.updateStartTime(device, timeIndex.getStartTime(device));
        }
        secondTsFileResource.setTimeIndex(newTimeIndex);
        ArrayList<TsFileResource> newUnseqResources = new ArrayList<TsFileResource>();
        newUnseqResources.add(largeUnseqTsFileResource);
        MergeResource resource = new MergeResource(this.seqResources, newUnseqResources);
        MaxFileMergeFileSelector mergeFileSelector = new MaxFileMergeFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)0L, (long)result.length);
        resource.clear();
    }

    @Test
    public void testFileOpenSelectionFromCompaction() throws IOException, WriteProcessException, NoSuchFieldException, IllegalAccessException {
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("10unseq-10-10-0.tsfile"));
        TsFileResource largeUnseqTsFileResource = new TsFileResource(file);
        this.unseqResources.add(largeUnseqTsFileResource);
        largeUnseqTsFileResource.setClosed(true);
        largeUnseqTsFileResource.setMinPlanIndex(10L);
        largeUnseqTsFileResource.setMaxPlanIndex(10L);
        largeUnseqTsFileResource.setVersion(10L);
        this.prepareFile(largeUnseqTsFileResource, 0L, (long)this.seqFileNum * this.ptNum, 0L);
        TsFileResource secondTsFileResource = (TsFileResource)this.seqResources.get(1);
        secondTsFileResource.setClosed(false);
        Set devices = secondTsFileResource.getDevices();
        Field timeIndexField = TsFileResource.class.getDeclaredField("timeIndex");
        timeIndexField.setAccessible(true);
        ITimeIndex timeIndex = (ITimeIndex)timeIndexField.get(secondTsFileResource);
        ITimeIndex newTimeIndex = IoTDBDescriptor.getInstance().getConfig().getTimeIndexLevel().getTimeIndex();
        for (String device : devices) {
            newTimeIndex.updateStartTime(device, timeIndex.getStartTime(device));
        }
        secondTsFileResource.setTimeIndex(newTimeIndex);
        ArrayList<TsFileResource> newUnseqResources = new ArrayList<TsFileResource>();
        newUnseqResources.add(largeUnseqTsFileResource);
        long timeLowerBound = System.currentTimeMillis() - Long.MAX_VALUE;
        MergeResource mergeResource = new MergeResource((Collection)this.seqResources, newUnseqResources, timeLowerBound);
        Assert.assertEquals((long)5L, (long)mergeResource.getSeqFiles().size());
        Assert.assertEquals((long)1L, (long)mergeResource.getUnseqFiles().size());
        mergeResource.clear();
    }

    @Test
    public void testFileSelectionAboutLastSeqFile() throws MergeException, IOException, WriteProcessException {
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("10unseq-10-10-0.tsfile"));
        TsFileResource largeUnseqTsFileResource = new TsFileResource(file);
        largeUnseqTsFileResource.setClosed(true);
        largeUnseqTsFileResource.setMinPlanIndex(10L);
        largeUnseqTsFileResource.setMaxPlanIndex(10L);
        largeUnseqTsFileResource.setVersion(10L);
        this.prepareFile(largeUnseqTsFileResource, 0L, this.ptNum + 1L, 0L);
        this.unseqResources.clear();
        this.unseqResources.add(largeUnseqTsFileResource);
        MergeResource resource = new MergeResource(this.seqResources, this.unseqResources);
        MaxFileMergeFileSelector mergeFileSelector = new MaxFileMergeFileSelector(resource, Long.MAX_VALUE);
        List[] result = mergeFileSelector.select();
        Assert.assertEquals((long)2L, (long)result[0].size());
        resource.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectContinuousUnseqFile() throws IOException, WriteProcessException, MergeException {
        ArrayList<TsFileResource> seqList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unseqList = new ArrayList<TsFileResource>();
        try {
            int seqFileNum = 99;
            for (int i = 0; i < seqFileNum; ++i) {
                File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("10seq-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
                TsFileResource fileResource = new TsFileResource(file);
                fileResource.setClosed(true);
                this.prepareFile(fileResource, i, 1L, 0L);
                seqList.add(fileResource);
            }
            int unseqFileNum = 3;
            for (int i = 0; i < unseqFileNum; ++i) {
                File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("10unseq-" + i + "-" + 10 + "-" + 0 + ".tsfile"));
                TsFileResource fileResource = new TsFileResource(file);
                fileResource.setClosed(true);
                unseqList.add(fileResource);
            }
            this.prepareFile((TsFileResource)unseqList.get(0), 0L, 1L, 10L);
            this.prepareFile((TsFileResource)unseqList.get(1), 0L, 100L, 20L);
            this.prepareFile((TsFileResource)unseqList.get(2), 99L, 1L, 30L);
            MergeResource resource = new MergeResource(seqList, unseqList);
            MaxFileMergeFileSelector mergeFileSelector = new MaxFileMergeFileSelector(resource, 29000L);
            List[] result = mergeFileSelector.select();
            Assert.assertEquals((long)1L, (long)result[0].size());
            Assert.assertEquals((long)1L, (long)result[1].size());
            Assert.assertEquals(seqList.get(0), result[0].get(0));
            Assert.assertEquals(unseqList.get(0), result[1].get(0));
            resource.clear();
            resource = new MergeResource(seqList.subList(1, seqList.size()), unseqList.subList(1, unseqList.size()));
            mergeFileSelector = new MaxFileMergeFileSelector(resource, 29000L);
            result = mergeFileSelector.select();
            Assert.assertEquals((long)0L, (long)result.length);
            resource.clear();
        }
        finally {
            this.removeFiles(seqList, unseqList);
        }
    }
}

