/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.engine.memtable.WritableMemChunk;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.utils.MathUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrimitiveMemTableTest {
    double delta;

    @Before
    public void setUp() {
        this.delta = Math.pow(0.1, TSFileDescriptor.getInstance().getConfig().getFloatPrecision());
    }

    @Test
    public void memSeriesSortIteratorTest() throws IOException {
        TSDataType dataType = TSDataType.INT32;
        WritableMemChunk series = new WritableMemChunk(new MeasurementSchema("s1", dataType, TSEncoding.PLAIN), TVList.newList((TSDataType)dataType));
        int count = 1000;
        for (int i = 0; i < count; ++i) {
            series.write((long)i, (Object)i);
        }
        IPointReader it = series.getSortedTVListForQuery().getIterator();
        int i = 0;
        while (it.hasNextTimeValuePair()) {
            Assert.assertEquals((long)i, (long)it.nextTimeValuePair().getTimestamp());
            ++i;
        }
        Assert.assertEquals((long)count, (long)i);
    }

    @Test
    public void simpleTest() throws IOException, QueryProcessException, MetadataException {
        int i;
        PrimitiveMemTable memTable = new PrimitiveMemTable();
        int count = 10;
        String deviceId = "d1";
        String[] measurementId = new String[count];
        for (int i2 = 0; i2 < measurementId.length; ++i2) {
            measurementId[i2] = "s" + i2;
        }
        int dataSize = 10000;
        for (i = 0; i < dataSize; ++i) {
            memTable.write(deviceId, measurementId[0], new MeasurementSchema(measurementId[0], TSDataType.INT32, TSEncoding.PLAIN), (long)(dataSize - i - 1), (Object)(i + 10));
        }
        for (i = 0; i < dataSize; ++i) {
            memTable.write(deviceId, measurementId[0], new MeasurementSchema(measurementId[0], TSDataType.INT32, TSEncoding.PLAIN), (long)i, (Object)i);
        }
        ReadOnlyMemChunk memChunk = memTable.query(deviceId, measurementId[0], TSDataType.INT32, TSEncoding.RLE, Collections.emptyMap(), Long.MIN_VALUE, null);
        IPointReader iterator = memChunk.getPointReader();
        for (int i3 = 0; i3 < dataSize; ++i3) {
            iterator.hasNextTimeValuePair();
            TimeValuePair timeValuePair = iterator.nextTimeValuePair();
            Assert.assertEquals((long)i3, (long)timeValuePair.getTimestamp());
            Assert.assertEquals((Object)i3, (Object)timeValuePair.getValue().getValue());
        }
    }

    private void write(IMemTable memTable, String deviceId, String sensorId, TSDataType dataType, TSEncoding encoding, int size) throws IOException, QueryProcessException, MetadataException {
        Object[] ret;
        for (TimeValuePair timeValuePair : ret = this.genTimeValuePair(size, dataType)) {
            memTable.write(deviceId, sensorId, new MeasurementSchema(sensorId, dataType, encoding), timeValuePair.getTimestamp(), timeValuePair.getValue().getValue());
        }
        IPointReader tvPair = memTable.query(deviceId, sensorId, dataType, encoding, Collections.emptyMap(), Long.MIN_VALUE, null).getPointReader();
        Arrays.sort(ret);
        Object last = null;
        for (int i = 0; i < ret.length; ++i) {
            Object object;
            while (last != null && i < ret.length && last.getTimestamp() == ret[i].getTimestamp()) {
                ++i;
            }
            if (i >= ret.length) break;
            last = object = ret[i];
            tvPair.hasNextTimeValuePair();
            TimeValuePair next = tvPair.nextTimeValuePair();
            Assert.assertEquals((long)object.getTimestamp(), (long)next.getTimestamp());
            if (dataType == TSDataType.DOUBLE) {
                Assert.assertEquals((double)object.getValue().getDouble(), (double)MathUtils.roundWithGivenPrecision((double)next.getValue().getDouble()), (double)this.delta);
                continue;
            }
            if (dataType == TSDataType.FLOAT) {
                float expected = object.getValue().getFloat();
                float actual = MathUtils.roundWithGivenPrecision((float)next.getValue().getFloat());
                Assert.assertEquals((double)expected, (double)actual, (double)(this.delta + 1.1754943508222875E-38));
                continue;
            }
            Assert.assertEquals((Object)object.getValue(), (Object)next.getValue());
        }
    }

    @Test
    public void testFloatType() throws IOException, QueryProcessException, MetadataException {
        PrimitiveMemTable memTable = new PrimitiveMemTable();
        String deviceId = "d1";
        int size = 100;
        this.write((IMemTable)memTable, deviceId, "s1", TSDataType.FLOAT, TSEncoding.RLE, size);
    }

    @Test
    public void testAllType() throws IOException, QueryProcessException, MetadataException {
        PrimitiveMemTable memTable = new PrimitiveMemTable();
        int count = 10;
        String deviceId = "d1";
        String[] measurementId = new String[count];
        for (int i = 0; i < measurementId.length; ++i) {
            measurementId[i] = "s" + i;
        }
        int index = 0;
        int size = 10000;
        this.write((IMemTable)memTable, deviceId, measurementId[index++], TSDataType.BOOLEAN, TSEncoding.RLE, size);
        this.write((IMemTable)memTable, deviceId, measurementId[index++], TSDataType.INT32, TSEncoding.RLE, size);
        this.write((IMemTable)memTable, deviceId, measurementId[index++], TSDataType.INT64, TSEncoding.RLE, size);
        this.write((IMemTable)memTable, deviceId, measurementId[index++], TSDataType.FLOAT, TSEncoding.RLE, size);
        this.write((IMemTable)memTable, deviceId, measurementId[index++], TSDataType.DOUBLE, TSEncoding.RLE, size);
        this.write((IMemTable)memTable, deviceId, measurementId[index++], TSDataType.TEXT, TSEncoding.PLAIN, size);
    }

    private TimeValuePair[] genTimeValuePair(int size, TSDataType dataType) {
        TimeValuePair[] ret = new TimeValuePair[size];
        Random rand = new Random();
        block8: for (int i = 0; i < size; ++i) {
            switch (dataType) {
                case BOOLEAN: {
                    ret[i] = new TimeValuePair(rand.nextLong(), TsPrimitiveType.getByType((TSDataType)dataType, (Object)true));
                    continue block8;
                }
                case INT32: {
                    ret[i] = new TimeValuePair(rand.nextLong(), TsPrimitiveType.getByType((TSDataType)dataType, (Object)rand.nextInt()));
                    continue block8;
                }
                case INT64: {
                    ret[i] = new TimeValuePair(rand.nextLong(), TsPrimitiveType.getByType((TSDataType)dataType, (Object)rand.nextLong()));
                    continue block8;
                }
                case FLOAT: {
                    ret[i] = new TimeValuePair(rand.nextLong(), TsPrimitiveType.getByType((TSDataType)dataType, (Object)Float.valueOf(rand.nextFloat())));
                    continue block8;
                }
                case DOUBLE: {
                    ret[i] = new TimeValuePair(rand.nextLong(), TsPrimitiveType.getByType((TSDataType)dataType, (Object)rand.nextDouble()));
                    continue block8;
                }
                case TEXT: {
                    ret[i] = new TimeValuePair(rand.nextLong(), TsPrimitiveType.getByType((TSDataType)dataType, (Object)new Binary("a" + rand.nextDouble())));
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException("Unsupported data type:" + dataType);
                }
            }
        }
        return ret;
    }
}

