/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.LevelCompactionTest;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.compaction.no.NoCompactionTsFileManagement;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NoCompactionTsFileManagementTest
extends LevelCompactionTest {
    File tempSGDir;

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    @Test
    public void testAddRemoveAndIterator() {
        NoCompactionTsFileManagement noCompactionTsFileManagement = new NoCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        for (TsFileResource tsFileResource : this.seqResources) {
            noCompactionTsFileManagement.add(tsFileResource, true);
        }
        noCompactionTsFileManagement.addAll(this.seqResources, false);
        Assert.assertEquals((long)6L, (long)noCompactionTsFileManagement.getTsFileList(true).size());
        Assert.assertEquals((long)6L, (long)noCompactionTsFileManagement.getTsFileList(false).size());
        Assert.assertEquals((long)6L, (long)noCompactionTsFileManagement.size(true));
        Assert.assertEquals((long)6L, (long)noCompactionTsFileManagement.size(false));
        Assert.assertTrue((boolean)noCompactionTsFileManagement.contains((TsFileResource)this.seqResources.get(0), true));
        Assert.assertFalse((boolean)noCompactionTsFileManagement.contains(new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("10-10-0-0.tsfile"))), false));
        Assert.assertTrue((boolean)noCompactionTsFileManagement.contains((TsFileResource)this.seqResources.get(0), false));
        Assert.assertFalse((boolean)noCompactionTsFileManagement.contains(new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("10-10-0-0.tsfile"))), false));
        Assert.assertFalse((boolean)noCompactionTsFileManagement.isEmpty(true));
        Assert.assertFalse((boolean)noCompactionTsFileManagement.isEmpty(false));
        noCompactionTsFileManagement.remove((TsFileResource)noCompactionTsFileManagement.getTsFileList(true).get(0), true);
        noCompactionTsFileManagement.remove((TsFileResource)noCompactionTsFileManagement.getTsFileList(false).get(0), false);
        Assert.assertEquals((long)5L, (long)noCompactionTsFileManagement.getTsFileList(true).size());
        noCompactionTsFileManagement.removeAll(noCompactionTsFileManagement.getTsFileList(false), false);
        Assert.assertEquals((long)0L, (long)noCompactionTsFileManagement.getTsFileList(false).size());
        long count = 0L;
        Iterator iterator = noCompactionTsFileManagement.getIterator(true);
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        Assert.assertEquals((long)5L, (long)count);
        noCompactionTsFileManagement.removeAll(noCompactionTsFileManagement.getTsFileList(true), true);
        Assert.assertEquals((long)0L, (long)noCompactionTsFileManagement.getTsFileList(true).size());
        Assert.assertTrue((boolean)noCompactionTsFileManagement.isEmpty(true));
        Assert.assertTrue((boolean)noCompactionTsFileManagement.isEmpty(false));
        noCompactionTsFileManagement.add(new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("10-10-10-0.tsfile"))), true);
        noCompactionTsFileManagement.add(new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("10-10-10-0.tsfile"))), false);
        noCompactionTsFileManagement.forkCurrentFileList(0L);
        noCompactionTsFileManagement.recover();
        TsFileManagement.CompactionMergeTask compactionMergeTask = new TsFileManagement.CompactionMergeTask((TsFileManagement)noCompactionTsFileManagement, (isMergeExecutedInCurrentTask, timePartitionId) -> {}, 0L);
        compactionMergeTask.call();
        Assert.assertEquals((long)1L, (long)noCompactionTsFileManagement.size(true));
        Assert.assertEquals((long)1L, (long)noCompactionTsFileManagement.size(false));
        noCompactionTsFileManagement.clear();
        Assert.assertEquals((long)0L, (long)noCompactionTsFileManagement.size(true));
        Assert.assertEquals((long)0L, (long)noCompactionTsFileManagement.size(false));
    }

    @Test
    public void testIteratorRemove() {
        NoCompactionTsFileManagement noCompactionTsFileManagement = new NoCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        for (TsFileResource tsFileResource : this.seqResources) {
            noCompactionTsFileManagement.add(tsFileResource, true);
        }
        noCompactionTsFileManagement.addAll(this.seqResources, false);
        Assert.assertEquals((long)6L, (long)noCompactionTsFileManagement.getTsFileList(true).size());
        Iterator tsFileResourceIterator = noCompactionTsFileManagement.getIterator(true);
        tsFileResourceIterator.next();
        try {
            tsFileResourceIterator.remove();
        }
        catch (UnsupportedOperationException tsFileResource) {
            // empty catch block
        }
        Assert.assertEquals((long)6L, (long)noCompactionTsFileManagement.getTsFileList(true).size());
        TsFileResource tsFileResource1 = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("10-10-1-0.tsfile")));
        TsFileResource tsFileResource2 = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("11-11-1-0.tsfile")));
        noCompactionTsFileManagement.add(tsFileResource1, true);
        noCompactionTsFileManagement.add(tsFileResource2, true);
        TsFileResource tsFileResource3 = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("12-12-2-0.tsfile")));
        noCompactionTsFileManagement.add(tsFileResource3, true);
        Iterator tsFileResourceIterator2 = noCompactionTsFileManagement.getIterator(true);
        int count = 0;
        while (tsFileResourceIterator2.hasNext()) {
            ++count;
            tsFileResourceIterator2.next();
        }
        Assert.assertEquals((long)9L, (long)count);
    }
}

