/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.LevelCompactionTest;
import org.apache.iotdb.db.engine.compaction.level.LevelCompactionTsFileManagement;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LevelCompactionTsFileManagementTest
extends LevelCompactionTest {
    File tempSGDir;

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    @Test
    public void testAddRemoveAndIterator() throws IOException {
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        for (TsFileResource tsFileResource : this.seqResources) {
            levelCompactionTsFileManagement.add(tsFileResource, true);
        }
        levelCompactionTsFileManagement.addAll(this.seqResources, false);
        Assert.assertEquals((long)6L, (long)levelCompactionTsFileManagement.getTsFileList(true).size());
        Assert.assertEquals((long)6L, (long)levelCompactionTsFileManagement.getTsFileList(false).size());
        Assert.assertEquals((long)6L, (long)levelCompactionTsFileManagement.size(true));
        Assert.assertEquals((long)6L, (long)levelCompactionTsFileManagement.size(false));
        Assert.assertTrue((boolean)levelCompactionTsFileManagement.contains((TsFileResource)this.seqResources.get(0), true));
        Assert.assertFalse((boolean)levelCompactionTsFileManagement.contains(new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("10-10-0-0.tsfile"))), false));
        Assert.assertTrue((boolean)levelCompactionTsFileManagement.contains((TsFileResource)this.seqResources.get(0), false));
        Assert.assertFalse((boolean)levelCompactionTsFileManagement.contains(new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("10-10-0-0.tsfile"))), false));
        Assert.assertFalse((boolean)levelCompactionTsFileManagement.isEmpty(true));
        Assert.assertFalse((boolean)levelCompactionTsFileManagement.isEmpty(false));
        levelCompactionTsFileManagement.remove((TsFileResource)levelCompactionTsFileManagement.getTsFileList(true).get(0), true);
        levelCompactionTsFileManagement.remove((TsFileResource)levelCompactionTsFileManagement.getTsFileList(false).get(0), false);
        Assert.assertEquals((long)5L, (long)levelCompactionTsFileManagement.getTsFileList(true).size());
        levelCompactionTsFileManagement.removeAll(levelCompactionTsFileManagement.getTsFileList(false), false);
        Assert.assertEquals((long)0L, (long)levelCompactionTsFileManagement.getTsFileList(false).size());
        long count = 0L;
        Iterator iterator = levelCompactionTsFileManagement.getIterator(true);
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        Assert.assertEquals((long)5L, (long)count);
        levelCompactionTsFileManagement.removeAll(levelCompactionTsFileManagement.getTsFileList(true), true);
        Assert.assertEquals((long)0L, (long)levelCompactionTsFileManagement.getTsFileList(true).size());
        Assert.assertTrue((boolean)levelCompactionTsFileManagement.isEmpty(true));
        Assert.assertTrue((boolean)levelCompactionTsFileManagement.isEmpty(false));
        levelCompactionTsFileManagement.add(new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("10-10-10-0.tsfile"))), true);
        levelCompactionTsFileManagement.add(new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("10-10-10-0.tsfile"))), false);
        Assert.assertEquals((long)1L, (long)levelCompactionTsFileManagement.size(true));
        Assert.assertEquals((long)1L, (long)levelCompactionTsFileManagement.size(false));
        levelCompactionTsFileManagement.clear();
        Assert.assertEquals((long)0L, (long)levelCompactionTsFileManagement.size(true));
        Assert.assertEquals((long)0L, (long)levelCompactionTsFileManagement.size(false));
    }

    @Test
    public void testIteratorRemove() throws IOException {
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        for (TsFileResource tsFileResource : this.seqResources) {
            levelCompactionTsFileManagement.add(tsFileResource, true);
        }
        levelCompactionTsFileManagement.addAll(this.seqResources, false);
        Assert.assertEquals((long)6L, (long)levelCompactionTsFileManagement.getTsFileList(true).size());
        Iterator tsFileResourceIterator = levelCompactionTsFileManagement.getIterator(true);
        tsFileResourceIterator.next();
        try {
            tsFileResourceIterator.remove();
        }
        catch (UnsupportedOperationException tsFileResource) {
            // empty catch block
        }
        Assert.assertEquals((long)6L, (long)levelCompactionTsFileManagement.getTsFileList(true).size());
        TsFileResource tsFileResource1 = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("10-10-1-0.tsfile")));
        TsFileResource tsFileResource2 = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("11-11-1-0.tsfile")));
        levelCompactionTsFileManagement.add(tsFileResource1, true);
        levelCompactionTsFileManagement.add(tsFileResource2, true);
        TsFileResource tsFileResource3 = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("12-12-2-0.tsfile")));
        levelCompactionTsFileManagement.add(tsFileResource3, true);
        Iterator tsFileResourceIterator2 = levelCompactionTsFileManagement.getIterator(true);
        int count = 0;
        while (tsFileResourceIterator2.hasNext()) {
            ++count;
            tsFileResourceIterator2.next();
        }
        Assert.assertEquals((long)9L, (long)count);
    }
}

