/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Before;

abstract class LevelCompactionTest {
    static final String COMPACTION_TEST_SG = "root.compactionTest";
    protected int seqFileNum = 6;
    int unseqFileNum = 0;
    protected int measurementNum = 10;
    int deviceNum = 10;
    long ptNum = 100L;
    long flushInterval = 20L;
    TSEncoding encoding = TSEncoding.PLAIN;
    String[] deviceIds;
    MeasurementSchema[] measurementSchemas;
    List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    List<TsFileResource> unseqResources = new ArrayList<TsFileResource>();
    private int prevMergeChunkThreshold;

    LevelCompactionTest() {
    }

    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        IoTDB.metaManager.init();
        this.prevMergeChunkThreshold = IoTDBDescriptor.getInstance().getConfig().getMergeChunkPointNumberThreshold();
        IoTDBDescriptor.getInstance().getConfig().setMergeChunkPointNumberThreshold(-1);
        this.prepareSeries();
        this.prepareFiles(this.seqFileNum, this.unseqFileNum);
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        this.removeFiles();
        this.seqResources.clear();
        this.unseqResources.clear();
        IoTDBDescriptor.getInstance().getConfig().setMergeChunkPointNumberThreshold(this.prevMergeChunkThreshold);
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        IoTDB.metaManager.clear();
        EnvironmentUtils.cleanAllDir();
    }

    void prepareSeries() throws MetadataException {
        int i;
        this.measurementSchemas = new MeasurementSchema[this.measurementNum];
        for (i = 0; i < this.measurementNum; ++i) {
            this.measurementSchemas[i] = new MeasurementSchema("sensor" + i, TSDataType.DOUBLE, this.encoding, CompressionType.UNCOMPRESSED);
        }
        this.deviceIds = new String[this.deviceNum];
        for (i = 0; i < this.deviceNum; ++i) {
            this.deviceIds[i] = "root.compactionTest.device" + i;
        }
        IoTDB.metaManager.setStorageGroup(new PartialPath(COMPACTION_TEST_SG));
        for (String device : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                PartialPath devicePath = new PartialPath(device);
                IoTDB.metaManager.createTimeseries(devicePath.concatNode(measurementSchema.getMeasurementId()), measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getCompressor(), Collections.emptyMap());
            }
        }
    }

    void prepareFiles(int seqFileNum, int unseqFileNum) throws IOException, WriteProcessException {
        TsFileResource tsFileResource;
        File file;
        int i;
        for (i = 0; i < seqFileNum; ++i) {
            file = new File(TestConstant.BASE_OUTPUT_PATH.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile"));
            tsFileResource = new TsFileResource(file);
            tsFileResource.setClosed(true);
            tsFileResource.updatePlanIndexes((long)i);
            this.seqResources.add(tsFileResource);
            this.prepareFile(tsFileResource, (long)i * this.ptNum, this.ptNum, 0L);
        }
        for (i = 0; i < unseqFileNum; ++i) {
            file = new File(TestConstant.BASE_OUTPUT_PATH.concat(10000 + i + "-" + (10000 + i) + "-" + 0 + "-" + 0 + ".tsfile"));
            tsFileResource = new TsFileResource(file);
            tsFileResource.setClosed(true);
            tsFileResource.updatePlanIndexes((long)(i + seqFileNum));
            this.unseqResources.add(tsFileResource);
            this.prepareFile(tsFileResource, (long)i * this.ptNum, this.ptNum * (long)(i + 1) / (long)unseqFileNum, 10000L);
        }
        File file2 = new File(TestConstant.BASE_OUTPUT_PATH.concat(unseqFileNum + "-" + unseqFileNum + "-" + 0 + "-" + 0 + ".tsfile"));
        TsFileResource tsFileResource2 = new TsFileResource(file2);
        tsFileResource2.setClosed(true);
        tsFileResource2.updatePlanIndexes((long)(seqFileNum + unseqFileNum));
        this.unseqResources.add(tsFileResource2);
        this.prepareFile(tsFileResource2, 0L, this.ptNum * (long)unseqFileNum, 20000L);
    }

    private void removeFiles() throws IOException {
        File[] resourceFiles;
        TsFileResource files;
        for (TsFileResource tsFileResource : this.seqResources) {
            if (!tsFileResource.getTsFile().exists()) continue;
            tsFileResource.remove();
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            if (!tsFileResource.getTsFile().exists()) continue;
            tsFileResource.remove();
        }
        for (File file : files = FSFactoryProducer.getFSFactory().listFilesBySuffix("target", ".tsfile")) {
            file.delete();
        }
        for (File resourceFile : resourceFiles = FSFactoryProducer.getFSFactory().listFilesBySuffix("target", ".resource")) {
            resourceFile.delete();
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FileReaderManager.getInstance().stop();
    }

    void prepareFile(TsFileResource tsFileResource, long timeOffset, long ptNum, long valueOffset) throws IOException, WriteProcessException {
        TsFileWriter fileWriter = new TsFileWriter(tsFileResource.getTsFile());
        for (String deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId, measurementSchema.getMeasurementId()), measurementSchema);
            }
        }
        for (long i = timeOffset; i < timeOffset + ptNum; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i + valueOffset)));
                }
                fileWriter.write(record);
                tsFileResource.updateStartTime(this.deviceIds[j], i);
                tsFileResource.updateEndTime(this.deviceIds[j], i);
            }
            if ((i + 1L) % this.flushInterval != 0L) continue;
            fileWriter.flushAllChunkGroups();
        }
        fileWriter.close();
    }

    List<TsFileResource> prepareTsFileResources() throws IOException, WriteProcessException {
        ArrayList<TsFileResource> ret = new ArrayList<TsFileResource>();
        File file1 = new File(TestConstant.BASE_OUTPUT_PATH.concat(System.nanoTime() + "-" + 0 + "-" + 0 + "-" + 0 + ".tsfile"));
        TsFileResource tsFileResource1 = new TsFileResource(file1);
        tsFileResource1.setClosed(true);
        tsFileResource1.updatePlanIndexes(0L);
        TsFileWriter fileWriter1 = new TsFileWriter(tsFileResource1.getTsFile());
        fileWriter1.registerTimeseries(new Path(this.deviceIds[0], this.measurementSchemas[0].getMeasurementId()), this.measurementSchemas[0]);
        TSRecord record1 = new TSRecord(0L, this.deviceIds[0]);
        record1.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[0].getType(), (String)this.measurementSchemas[0].getMeasurementId(), (String)String.valueOf(0)));
        fileWriter1.write(record1);
        fileWriter1.close();
        File file2 = new File(TestConstant.BASE_OUTPUT_PATH.concat(System.nanoTime() + "-" + 1 + "-" + 0 + "-" + 0 + ".tsfile"));
        TsFileResource tsFileResource2 = new TsFileResource(file2);
        tsFileResource2.setClosed(true);
        tsFileResource2.updatePlanIndexes(1L);
        TsFileWriter fileWriter2 = new TsFileWriter(tsFileResource2.getTsFile());
        fileWriter2.registerTimeseries(new Path(this.deviceIds[0], this.measurementSchemas[1].getMeasurementId()), this.measurementSchemas[1]);
        TSRecord record2 = new TSRecord(0L, this.deviceIds[0]);
        record2.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[1].getType(), (String)this.measurementSchemas[1].getMeasurementId(), (String)String.valueOf(0)));
        fileWriter2.write(record2);
        fileWriter2.close();
        ret.add(tsFileResource1);
        ret.add(tsFileResource2);
        return ret;
    }
}

