/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.LevelCompactionTest;
import org.apache.iotdb.db.engine.compaction.level.LevelCompactionTsFileManagement;
import org.apache.iotdb.db.engine.compaction.utils.CompactionLogger;
import org.apache.iotdb.db.engine.compaction.utils.CompactionUtils;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LevelCompactionRecoverTest
extends LevelCompactionTest {
    File tempSGDir;

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    @Test
    public void testCompactionMergeRecoverMergeFinished() throws IOException, IllegalPathException {
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)500L, (long)count);
        CompactionLogger compactionLogger = new CompactionLogger(this.tempSGDir.getPath(), "root.compactionTest");
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(0)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(1)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(2)).getTsFile());
        compactionLogger.logSequence(true);
        TsFileResource targetTsFileResource = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("0-0-1-0.tsfile")));
        compactionLogger.logFile("target", targetTsFileResource.getTsFile());
        CompactionUtils.merge((TsFileResource)targetTsFileResource, new ArrayList(this.seqResources.subList(0, 3)), (String)"root.compactionTest", (CompactionLogger)compactionLogger, new HashSet(), (boolean)true, new ArrayList());
        compactionLogger.close();
        levelCompactionTsFileManagement.addRecover(targetTsFileResource, true);
        levelCompactionTsFileManagement.recover();
        context = new QueryContext();
        path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionMergeRecoverMergeFinishedAndDeleteOneOffset() throws IOException, IllegalPathException {
        String line;
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)500L, (long)count);
        CompactionLogger compactionLogger = new CompactionLogger(this.tempSGDir.getPath(), "root.compactionTest");
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(0)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(1)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(2)).getTsFile());
        compactionLogger.logSequence(true);
        TsFileResource targetTsFileResource = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("0-0-1-0.tsfile")));
        compactionLogger.logFile("target", targetTsFileResource.getTsFile());
        CompactionUtils.merge((TsFileResource)targetTsFileResource, new ArrayList(this.seqResources.subList(0, 3)), (String)"root.compactionTest", (CompactionLogger)compactionLogger, new HashSet(), (boolean)true, new ArrayList());
        compactionLogger.close();
        BufferedReader logReader = new BufferedReader(new FileReader(SystemFileFactory.INSTANCE.getFile(this.tempSGDir.getPath(), "root.compactionTest.compaction.log")));
        ArrayList<String> logs = new ArrayList<String>();
        while ((line = logReader.readLine()) != null) {
            logs.add(line);
        }
        logReader.close();
        BufferedWriter logStream = new BufferedWriter(new FileWriter(SystemFileFactory.INSTANCE.getFile(this.tempSGDir.getPath(), "root.compactionTest.compaction.log"), false));
        for (int i = 0; i < logs.size() - 1; ++i) {
            logStream.write((String)logs.get(i));
            logStream.newLine();
        }
        logStream.close();
        levelCompactionTsFileManagement.addRecover(targetTsFileResource, true);
        levelCompactionTsFileManagement.recover();
        context = new QueryContext();
        path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionMergeRecoverMergeFinishedAndDeleteOneDeviceWithOffset() throws IOException, IllegalPathException {
        String line;
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)500L, (long)count);
        CompactionLogger compactionLogger = new CompactionLogger(this.tempSGDir.getPath(), "root.compactionTest");
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(0)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(1)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(2)).getTsFile());
        compactionLogger.logSequence(true);
        TsFileResource targetTsFileResource = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("0-0-1-0.tsfile")));
        compactionLogger.logFile("target", targetTsFileResource.getTsFile());
        CompactionUtils.merge((TsFileResource)targetTsFileResource, new ArrayList(this.seqResources.subList(0, 3)), (String)"root.compactionTest", (CompactionLogger)compactionLogger, new HashSet(), (boolean)true, new ArrayList());
        compactionLogger.close();
        BufferedReader logReader = new BufferedReader(new FileReader(SystemFileFactory.INSTANCE.getFile(this.tempSGDir.getPath(), "root.compactionTest.compaction.log")));
        ArrayList<String> logs = new ArrayList<String>();
        while ((line = logReader.readLine()) != null) {
            logs.add(line);
        }
        logReader.close();
        BufferedWriter logStream = new BufferedWriter(new FileWriter(SystemFileFactory.INSTANCE.getFile(this.tempSGDir.getPath(), "root.compactionTest.compaction.log"), false));
        for (int i = 0; i < logs.size() - 1; ++i) {
            logStream.write((String)logs.get(i));
            logStream.newLine();
        }
        logStream.close();
        TsFileOutput out = FSFactoryProducer.getFileOutputFactory().getTsFileOutput(targetTsFileResource.getTsFile().getPath(), true);
        out.truncate(Long.parseLong(((String)logs.get(logs.size() - 1)).split(" ")[1]) - 1L);
        out.close();
        levelCompactionTsFileManagement.addRecover(targetTsFileResource, true);
        levelCompactionTsFileManagement.recover();
        context = new QueryContext();
        path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionMergeRecoverMergeFinishedUnseq() throws IOException, IllegalPathException {
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.seqResources, false);
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)500L, (long)count);
        CompactionLogger compactionLogger = new CompactionLogger(this.tempSGDir.getPath(), "root.compactionTest");
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(0)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(1)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(2)).getTsFile());
        compactionLogger.logSequence(false);
        TsFileResource targetTsFileResource = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("0-0-1-0.tsfile")));
        compactionLogger.logFile("target", targetTsFileResource.getTsFile());
        CompactionUtils.merge((TsFileResource)targetTsFileResource, new ArrayList(this.seqResources.subList(0, 3)), (String)"root.compactionTest", (CompactionLogger)compactionLogger, new HashSet(), (boolean)false, new ArrayList());
        compactionLogger.close();
        levelCompactionTsFileManagement.addRecover(targetTsFileResource, false);
        levelCompactionTsFileManagement.recover();
        context = new QueryContext();
        path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(false), new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionMergeRecoverMergeStartSourceLog() throws IOException, IllegalPathException {
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        CompactionLogger compactionLogger = new CompactionLogger(this.tempSGDir.getPath(), "root.compactionTest");
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(0)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(1)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(2)).getTsFile());
        compactionLogger.close();
        levelCompactionTsFileManagement.recover();
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionMergeRecoverMergeStartSequenceLog() throws IOException, IllegalPathException {
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        CompactionLogger compactionLogger = new CompactionLogger(this.tempSGDir.getPath(), "root.compactionTest");
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(0)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(1)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(2)).getTsFile());
        compactionLogger.logSequence(true);
        compactionLogger.close();
        levelCompactionTsFileManagement.recover();
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionMergeRecoverMergeStart() throws IOException, IllegalPathException {
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        CompactionLogger compactionLogger = new CompactionLogger(this.tempSGDir.getPath(), "root.compactionTest");
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(0)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(1)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(2)).getTsFile());
        compactionLogger.logSequence(true);
        TsFileResource targetTsFileResource = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("0-0-1-0.tsfile")));
        compactionLogger.logFile("target", targetTsFileResource.getTsFile());
        levelCompactionTsFileManagement.add(targetTsFileResource, true);
        compactionLogger.close();
        levelCompactionTsFileManagement.recover();
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionMergeRecoverMergeFinishedNoLog() throws IOException, IllegalPathException {
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        CompactionLogger compactionLogger = new CompactionLogger(this.tempSGDir.getPath(), "root.compactionTest");
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(0)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(1)).getTsFile());
        compactionLogger.logFile("source", ((TsFileResource)this.seqResources.get(2)).getTsFile());
        compactionLogger.logSequence(true);
        TsFileResource targetTsFileResource = new TsFileResource(new File(TestConstant.BASE_OUTPUT_PATH.concat("0-0-1-0.tsfile")));
        compactionLogger.logFile("target", targetTsFileResource.getTsFile());
        CompactionUtils.merge((TsFileResource)targetTsFileResource, new ArrayList(this.seqResources.subList(0, 3)), (String)"root.compactionTest", (CompactionLogger)compactionLogger, new HashSet(), (boolean)true, new ArrayList());
        levelCompactionTsFileManagement.addRecover(targetTsFileResource, true);
        compactionLogger.close();
        levelCompactionTsFileManagement.recover();
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)500L, (long)count);
    }
}

