/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.LevelCompactionTest;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.compaction.level.LevelCompactionTsFileManagement;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LevelCompactionMoreDataTest
extends LevelCompactionTest {
    protected int measurementNum = 3000;
    protected int seqFileNum = 2;
    File tempSGDir;
    boolean compactionMergeWorking = false;

    @Override
    void prepareSeries() throws MetadataException {
        int i;
        this.measurementSchemas = new MeasurementSchema[this.measurementNum];
        for (i = 0; i < this.measurementNum; ++i) {
            this.measurementSchemas[i] = new MeasurementSchema("sensor" + i, TSDataType.DOUBLE, this.encoding, CompressionType.UNCOMPRESSED);
        }
        this.deviceIds = new String[this.deviceNum];
        for (i = 0; i < this.deviceNum; ++i) {
            this.deviceIds[i] = "root.compactionTest.device" + i;
        }
        IoTDB.metaManager.setStorageGroup(new PartialPath("root.compactionTest"));
        for (String device : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                PartialPath devicePath = new PartialPath(device);
                IoTDB.metaManager.createTimeseries(devicePath.concatNode(measurementSchema.getMeasurementId()), measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getCompressor(), Collections.emptyMap());
            }
        }
    }

    @Override
    void prepareFiles(int seqFileNum, int unseqFileNum) throws IOException, WriteProcessException {
        TsFileResource tsFileResource;
        File file;
        int i;
        for (i = 0; i < seqFileNum; ++i) {
            file = new File(TestConstant.BASE_OUTPUT_PATH.concat(i + "-" + i + "-" + 0 + "-" + 0 + ".tsfile"));
            tsFileResource = new TsFileResource(file);
            tsFileResource.setClosed(true);
            tsFileResource.updatePlanIndexes((long)i);
            this.seqResources.add(tsFileResource);
            this.prepareFile(tsFileResource, (long)i * this.ptNum, this.ptNum, 0L);
        }
        for (i = 0; i < unseqFileNum; ++i) {
            file = new File(TestConstant.BASE_OUTPUT_PATH.concat(10000 + i + "-" + (10000 + i) + "-" + 0 + "-" + 0 + ".tsfile"));
            tsFileResource = new TsFileResource(file);
            tsFileResource.setClosed(true);
            tsFileResource.updatePlanIndexes((long)(i + seqFileNum));
            this.unseqResources.add(tsFileResource);
            this.prepareFile(tsFileResource, (long)i * this.ptNum, this.ptNum * (long)(i + 1) / (long)unseqFileNum, 10000L);
        }
        File file2 = new File(TestConstant.BASE_OUTPUT_PATH.concat(unseqFileNum + "-" + unseqFileNum + "-" + 0 + "-" + 0 + ".tsfile"));
        TsFileResource tsFileResource2 = new TsFileResource(file2);
        tsFileResource2.setClosed(true);
        tsFileResource2.updatePlanIndexes((long)(seqFileNum + unseqFileNum));
        this.unseqResources.add(tsFileResource2);
        this.prepareFile(tsFileResource2, 0L, this.ptNum * (long)unseqFileNum, 20000L);
    }

    @Override
    void prepareFile(TsFileResource tsFileResource, long timeOffset, long ptNum, long valueOffset) throws IOException, WriteProcessException {
        TsFileWriter fileWriter = new TsFileWriter(tsFileResource.getTsFile());
        for (String deviceId : this.deviceIds) {
            for (MeasurementSchema measurementSchema : this.measurementSchemas) {
                fileWriter.registerTimeseries(new Path(deviceId, measurementSchema.getMeasurementId()), measurementSchema);
            }
        }
        for (long i = timeOffset; i < timeOffset + ptNum; ++i) {
            for (int j = 0; j < this.deviceNum; ++j) {
                TSRecord record = new TSRecord(i, this.deviceIds[j]);
                for (int k = 0; k < this.measurementNum; ++k) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i + valueOffset + (long)k)));
                }
                fileWriter.write(record);
                tsFileResource.updateStartTime(this.deviceIds[j], i);
                tsFileResource.updateEndTime(this.deviceIds[j], i);
            }
            if ((i + 1L) % this.flushInterval != 0L) continue;
            fileWriter.flushAllChunkGroups();
        }
        fileWriter.close();
    }

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    @Test
    public void testSensorWithTwoOrThreeNode() throws IllegalPathException, IOException {
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        levelCompactionTsFileManagement.forkCurrentFileList(0L);
        LevelCompactionTsFileManagement levelCompactionTsFileManagement2 = levelCompactionTsFileManagement;
        Objects.requireNonNull(levelCompactionTsFileManagement2);
        TsFileManagement.CompactionMergeTask compactionMergeTask = new TsFileManagement.CompactionMergeTask((TsFileManagement)levelCompactionTsFileManagement2, this::closeCompactionMergeCallBack, 0L);
        this.compactionMergeWorking = true;
        compactionMergeTask.call();
        while (this.compactionMergeWorking) {
        }
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[2688].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[2688].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)(batchData.getTimeByIndex(i) + 2688L), (double)batchData.getDoubleByIndex(i), (double)0.001);
            }
        }
    }

    private void closeCompactionMergeCallBack(boolean isMergeExecutedInCurrentTask, long timePartitionId) {
        this.compactionMergeWorking = false;
    }
}

