/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.LevelCompactionTest;
import org.apache.iotdb.db.engine.compaction.level.LevelCompactionTsFileManagement;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LevelCompactionModsTest
extends LevelCompactionTest {
    File tempSGDir;

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    @Test
    public void testCompactionMods() throws IllegalPathException, IOException {
        Deletion modification2;
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        TsFileResource sourceTsFileResource = (TsFileResource)this.seqResources.get(0);
        TsFileResource targetTsFileResource = (TsFileResource)this.seqResources.get(1);
        ArrayList<Deletion> filterModifications = new ArrayList<Deletion>();
        try (ModificationFile sourceModificationFile = new ModificationFile(sourceTsFileResource.getTsFilePath() + ".mods");){
            Deletion modification1 = new Deletion(new PartialPath(this.deviceIds[0], "sensor0"), 0L, 0L);
            modification2 = new Deletion(new PartialPath(this.deviceIds[0], "sensor1"), Long.MAX_VALUE, 0L);
            sourceModificationFile.write((Modification)modification1);
            sourceModificationFile.write((Modification)modification2);
            filterModifications.add(modification1);
        }
        ArrayList<TsFileResource> sourceTsFileResources = new ArrayList<TsFileResource>();
        sourceTsFileResources.add(sourceTsFileResource);
        levelCompactionTsFileManagement.renameLevelFilesMods(filterModifications, sourceTsFileResources, targetTsFileResource);
        try (ModificationFile targetModificationFile = new ModificationFile(targetTsFileResource.getTsFilePath() + ".mods");){
            Collection modifications = targetModificationFile.getModifications();
            Assert.assertEquals((long)1L, (long)modifications.size());
            Assert.assertEquals((Object)modification2, modifications.stream().findFirst().get());
        }
    }

    @Test
    public void testCompactionModsByOffset() throws IllegalPathException, IOException {
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        TsFileResource sourceTsFileResource = (TsFileResource)this.seqResources.get(0);
        TsFileResource targetTsFileResource = (TsFileResource)this.seqResources.get(1);
        ArrayList<Deletion> filterModifications = new ArrayList<Deletion>();
        try (ModificationFile sourceModificationFile = new ModificationFile(sourceTsFileResource.getTsFilePath() + ".mods");){
            Deletion modification1 = new Deletion(new PartialPath(this.deviceIds[0], "sensor0"), sourceTsFileResource.getTsFileSize() / 2L, 0L, 100L);
            Deletion modification2 = new Deletion(new PartialPath(this.deviceIds[0], "sensor1"), sourceTsFileResource.getTsFileSize() / 2L, 0L, 100L);
            sourceModificationFile.write((Modification)modification1);
            sourceModificationFile.write((Modification)modification2);
            filterModifications.add(modification1);
        }
        ArrayList<TsFileResource> sourceTsFileResources = new ArrayList<TsFileResource>();
        sourceTsFileResources.add(sourceTsFileResource);
        levelCompactionTsFileManagement.renameLevelFilesMods(filterModifications, sourceTsFileResources, targetTsFileResource);
        try (ModificationFile targetModificationFile = new ModificationFile(targetTsFileResource.getTsFilePath() + ".mods");){
            Collection modifications = targetModificationFile.getModifications();
            Assert.assertEquals((long)1L, (long)modifications.size());
            Assert.assertEquals((long)Long.MAX_VALUE, (long)((Modification)modifications.stream().findFirst().get()).getFileOffset());
        }
    }
}

