/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.LevelCompactionTest;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.compaction.level.LevelCompactionTsFileManagement;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LevelCompactionMergeTest
extends LevelCompactionTest {
    File tempSGDir;
    boolean compactionMergeWorking = false;

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    @Test
    public void testCompactionMergeOnce() throws IllegalPathException, IOException {
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        levelCompactionTsFileManagement.forkCurrentFileList(0L);
        LevelCompactionTsFileManagement levelCompactionTsFileManagement2 = levelCompactionTsFileManagement;
        Objects.requireNonNull(levelCompactionTsFileManagement2);
        TsFileManagement.CompactionMergeTask compactionMergeTask = new TsFileManagement.CompactionMergeTask((TsFileManagement)levelCompactionTsFileManagement2, this::closeCompactionMergeCallBack, 0L);
        this.compactionMergeWorking = true;
        compactionMergeTask.call();
        while (this.compactionMergeWorking) {
        }
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
            }
        }
    }

    @Test
    public void testCompactionMergeStableList() throws IllegalPathException, IOException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(2);
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        levelCompactionTsFileManagement.forkCurrentFileList(0L);
        LevelCompactionTsFileManagement levelCompactionTsFileManagement2 = levelCompactionTsFileManagement;
        Objects.requireNonNull(levelCompactionTsFileManagement2);
        TsFileManagement.CompactionMergeTask compactionMergeTask = new TsFileManagement.CompactionMergeTask((TsFileManagement)levelCompactionTsFileManagement2, this::closeCompactionMergeCallBack, 0L);
        this.compactionMergeWorking = true;
        compactionMergeTask.call();
        while (this.compactionMergeWorking) {
        }
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                ++count;
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
            }
        }
        Assert.assertEquals((long)500L, (long)count);
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
    }

    @Test
    public void testCompactionModsByOffsetAfterMerge() throws IllegalPathException, IOException {
        int prevPageLimit = IoTDBDescriptor.getInstance().getConfig().getMergePagePointNumberThreshold();
        IoTDBDescriptor.getInstance().getConfig().setMergePagePointNumberThreshold(1);
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        TsFileResource forthSeqTsFileResource = (TsFileResource)this.seqResources.get(3);
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        try (ModificationFile sourceModificationFile = new ModificationFile(forthSeqTsFileResource.getTsFilePath() + ".mods");){
            Deletion modification = new Deletion(path, forthSeqTsFileResource.getTsFileSize() / 10L, 300L, 310L);
            sourceModificationFile.write((Modification)modification);
        }
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        levelCompactionTsFileManagement.forkCurrentFileList(0L);
        LevelCompactionTsFileManagement levelCompactionTsFileManagement2 = levelCompactionTsFileManagement;
        Objects.requireNonNull(levelCompactionTsFileManagement2);
        TsFileManagement.CompactionMergeTask compactionMergeTask = new TsFileManagement.CompactionMergeTask((TsFileManagement)levelCompactionTsFileManagement2, this::closeCompactionMergeCallBack, 0L);
        this.compactionMergeWorking = true;
        compactionMergeTask.call();
        while (this.compactionMergeWorking) {
        }
        QueryContext context = new QueryContext();
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[0].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        long count = 0L;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            count += (long)batchData.length();
        }
        Assert.assertEquals((long)489L, (long)count);
        List tsFileResourceList = levelCompactionTsFileManagement.getTsFileList(true);
        for (TsFileResource tsFileResource : tsFileResourceList) {
            tsFileResource.getModFile().remove();
            tsFileResource.remove();
        }
        IoTDBDescriptor.getInstance().getConfig().setMergePagePointNumberThreshold(prevPageLimit);
    }

    @Test
    public void testCompactionAppendChunkMerge() throws IOException {
        int prevMergeChunkPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getMergeChunkPointNumberThreshold();
        IoTDBDescriptor.getInstance().getConfig().setMergeChunkPointNumberThreshold(1);
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        levelCompactionTsFileManagement.forkCurrentFileList(0L);
        LevelCompactionTsFileManagement levelCompactionTsFileManagement2 = levelCompactionTsFileManagement;
        Objects.requireNonNull(levelCompactionTsFileManagement2);
        TsFileManagement.CompactionMergeTask compactionMergeTask = new TsFileManagement.CompactionMergeTask((TsFileManagement)levelCompactionTsFileManagement2, this::closeCompactionMergeCallBack, 0L);
        this.compactionMergeWorking = true;
        compactionMergeTask.call();
        while (this.compactionMergeWorking) {
        }
        TsFileResource newTsFileResource = (TsFileResource)levelCompactionTsFileManagement.getTsFileListByTimePartition(true, 0L).get(0);
        TsFileSequenceReader tsFileSequenceReader = new TsFileSequenceReader(newTsFileResource.getTsFilePath());
        Map sensorChunkMetadataListMap = tsFileSequenceReader.readChunkMetadataInDevice(this.deviceIds[0]);
        for (List chunkMetadataList : sensorChunkMetadataListMap.values()) {
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                Assert.assertEquals((long)20L, (long)chunkMetadata.getNumOfPoints());
            }
        }
        tsFileSequenceReader.close();
        IoTDBDescriptor.getInstance().getConfig().setMergeChunkPointNumberThreshold(prevMergeChunkPointNumberThreshold);
    }

    @Test
    public void testCompactionNoAppendChunkMerge() throws IOException {
        int prevMergeChunkPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getMergeChunkPointNumberThreshold();
        IoTDBDescriptor.getInstance().getConfig().setMergeChunkPointNumberThreshold(100000);
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        levelCompactionTsFileManagement.forkCurrentFileList(0L);
        LevelCompactionTsFileManagement levelCompactionTsFileManagement2 = levelCompactionTsFileManagement;
        Objects.requireNonNull(levelCompactionTsFileManagement2);
        TsFileManagement.CompactionMergeTask compactionMergeTask = new TsFileManagement.CompactionMergeTask((TsFileManagement)levelCompactionTsFileManagement2, this::closeCompactionMergeCallBack, 0L);
        this.compactionMergeWorking = true;
        compactionMergeTask.call();
        while (this.compactionMergeWorking) {
        }
        TsFileResource newTsFileResource = (TsFileResource)levelCompactionTsFileManagement.getTsFileListByTimePartition(true, 0L).get(0);
        TsFileSequenceReader tsFileSequenceReader = new TsFileSequenceReader(newTsFileResource.getTsFilePath());
        Map sensorChunkMetadataListMap = tsFileSequenceReader.readChunkMetadataInDevice(this.deviceIds[0]);
        for (List chunkMetadataList : sensorChunkMetadataListMap.values()) {
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                Assert.assertEquals((long)500L, (long)chunkMetadata.getNumOfPoints());
            }
        }
        tsFileSequenceReader.close();
        IoTDBDescriptor.getInstance().getConfig().setMergeChunkPointNumberThreshold(prevMergeChunkPointNumberThreshold);
    }

    private void closeCompactionMergeCallBack(boolean isMergeExecutedInCurrentTask, long timePartitionId) {
        this.compactionMergeWorking = false;
    }

    @Test
    public void testCompactionDiffTimeSeries() throws IOException, WriteProcessException, IllegalPathException {
        int prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        int prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(2);
        List<TsFileResource> compactionFiles = this.prepareTsFileResources();
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(compactionFiles, true);
        QueryContext context = new QueryContext();
        PartialPath path = new PartialPath(this.deviceIds[0] + "." + this.measurementSchemas[1].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[1].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                ++count;
            }
        }
        Assert.assertEquals((long)count, (long)1L);
        levelCompactionTsFileManagement.forkCurrentFileList(0L);
        LevelCompactionTsFileManagement levelCompactionTsFileManagement2 = levelCompactionTsFileManagement;
        Objects.requireNonNull(levelCompactionTsFileManagement2);
        TsFileManagement.CompactionMergeTask compactionOnePartitionUtil = new TsFileManagement.CompactionMergeTask((TsFileManagement)levelCompactionTsFileManagement2, this::closeCompactionMergeCallBack, 0L);
        this.compactionMergeWorking = true;
        compactionOnePartitionUtil.call();
        while (this.compactionMergeWorking) {
        }
        context = new QueryContext();
        tsFilesReader = new SeriesRawDataBatchReader(path, this.measurementSchemas[1].getType(), context, levelCompactionTsFileManagement.getTsFileList(true), new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                ++count;
            }
        }
        Assert.assertEquals((long)count, (long)1L);
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(prevSeqLevelNum);
    }
}

