/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.LevelCompactionTest;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.compaction.level.LevelCompactionTsFileManagement;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LevelCompactionLogTest
extends LevelCompactionTest {
    File tempSGDir;
    boolean compactionMergeWorking = false;

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    @Test
    public void testCompactionLog() throws IOException {
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        levelCompactionTsFileManagement.forkCurrentFileList(0L);
        LevelCompactionTsFileManagement levelCompactionTsFileManagement2 = levelCompactionTsFileManagement;
        Objects.requireNonNull(levelCompactionTsFileManagement2);
        TsFileManagement.CompactionMergeTask compactionMergeTask = new TsFileManagement.CompactionMergeTask((TsFileManagement)levelCompactionTsFileManagement2, this::closeCompactionMergeCallBack, 0L);
        this.compactionMergeWorking = true;
        compactionMergeTask.call();
        while (this.compactionMergeWorking) {
        }
        File logFile = FSFactoryProducer.getFSFactory().getFile(this.tempSGDir.getPath(), "root.compactionTest.compaction.log");
        Assert.assertFalse((boolean)logFile.exists());
    }

    private void closeCompactionMergeCallBack(boolean isMergeExecutedInCurrentTask, long timePartitionId) {
        this.compactionMergeWorking = false;
    }
}

