/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.compaction.LevelCompactionTest;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.compaction.level.LevelCompactionTsFileManagement;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LevelCompactionCacheTest
extends LevelCompactionTest {
    File tempSGDir;
    boolean compactionMergeWorking = false;

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    @Test
    public void testCompactionChunkCache() throws IOException {
        LevelCompactionTsFileManagement levelCompactionTsFileManagement = new LevelCompactionTsFileManagement("root.compactionTest", this.tempSGDir.getPath());
        TsFileResource tsFileResource = (TsFileResource)this.seqResources.get(1);
        TsFileSequenceReader reader = new TsFileSequenceReader(tsFileResource.getTsFilePath());
        List paths = reader.getAllPaths();
        TreeSet<String> allSensors = new TreeSet<String>();
        for (Path path : paths) {
            allSensors.add(path.getMeasurement());
        }
        ChunkMetadata firstChunkMetadata = (ChunkMetadata)reader.getChunkMetadataList((Path)paths.get(0)).get(0);
        firstChunkMetadata.setFilePath(tsFileResource.getTsFilePath());
        TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey firstTimeSeriesMetadataCacheKey = new TimeSeriesMetadataCache.TimeSeriesMetadataCacheKey(((TsFileResource)this.seqResources.get(1)).getTsFilePath(), ((Path)paths.get(0)).getDevice(), ((Path)paths.get(0)).getMeasurement());
        ChunkCache.getInstance().get(firstChunkMetadata);
        TimeSeriesMetadataCache.getInstance().get(firstTimeSeriesMetadataCacheKey, allSensors);
        levelCompactionTsFileManagement.addAll(this.seqResources, true);
        levelCompactionTsFileManagement.addAll(this.unseqResources, false);
        levelCompactionTsFileManagement.forkCurrentFileList(0L);
        LevelCompactionTsFileManagement levelCompactionTsFileManagement2 = levelCompactionTsFileManagement;
        Objects.requireNonNull(levelCompactionTsFileManagement2);
        TsFileManagement.CompactionMergeTask compactionMergeTask = new TsFileManagement.CompactionMergeTask((TsFileManagement)levelCompactionTsFileManagement2, this::closeCompactionMergeCallBack, 0L);
        this.compactionMergeWorking = true;
        compactionMergeTask.call();
        while (this.compactionMergeWorking) {
        }
        firstChunkMetadata.setFilePath(null);
        try {
            ChunkCache.getInstance().get(firstChunkMetadata);
            Assert.fail();
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            TimeSeriesMetadataCache.getInstance().get(firstTimeSeriesMetadataCacheKey, new TreeSet());
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
        reader.close();
    }

    private void closeCompactionMergeCallBack(boolean isMergeExecutedInCurrentTask, long timePartitionId) {
        this.compactionMergeWorking = false;
    }
}

