/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import com.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.LevelCompactionTest;
import org.apache.iotdb.db.engine.compaction.utils.CompactionUtils;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReaderByTimestamp;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompactionChunkTest
extends LevelCompactionTest {
    File tempSGDir;

    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
        this.tempSGDir = new File(TestConstant.BASE_OUTPUT_PATH.concat("tempSG"));
        this.tempSGDir.mkdirs();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
        FileUtils.deleteDirectory((File)this.tempSGDir);
    }

    @Test
    public void testAppendMerge() throws IOException, IllegalPathException {
        HashMap measurementChunkMetadataMap = new HashMap();
        List sourceTsfileResources = this.seqResources.subList(0, 2);
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("0-0-1-0.tsfile"));
        TsFileResource targetTsfileResource = new TsFileResource(file);
        RateLimiter compactionWriteRateLimiter = MergeManager.getINSTANCE().getMergeWriteRateLimiter();
        String device = "root.compactionTest.device0";
        RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(targetTsfileResource.getTsFile());
        writer.startChunkGroup(device);
        for (TsFileResource tsFileResource : sourceTsfileResources) {
            TsFileSequenceReader reader = new TsFileSequenceReader(tsFileResource.getTsFilePath());
            Map chunkMetadataMap = reader.readChunkMetadataInDevice(device);
            for (Map.Entry entry : chunkMetadataMap.entrySet()) {
                for (ChunkMetadata chunkMetadata : (List)entry.getValue()) {
                    String measurementUid = chunkMetadata.getMeasurementUid();
                    Map readerChunkMetadataMap = measurementChunkMetadataMap.containsKey(measurementUid) ? (Map)measurementChunkMetadataMap.get(measurementUid) : new LinkedHashMap();
                    List chunkMetadataList = readerChunkMetadataMap.containsKey(reader) ? (List)readerChunkMetadataMap.get(reader) : new ArrayList();
                    chunkMetadataList.add(chunkMetadata);
                    readerChunkMetadataMap.put(reader, chunkMetadataList);
                    measurementChunkMetadataMap.put(chunkMetadata.getMeasurementUid(), readerChunkMetadataMap);
                }
            }
            for (Map.Entry entry : measurementChunkMetadataMap.entrySet()) {
                CompactionUtils.writeByAppendPageMerge((String)device, (RateLimiter)compactionWriteRateLimiter, entry, (TsFileResource)targetTsfileResource, (RestorableTsFileIOWriter)writer);
            }
            reader.close();
        }
        writer.endChunkGroup();
        targetTsfileResource.serialize();
        writer.endFile();
        targetTsfileResource.close();
        TsFileSequenceReader reader = new TsFileSequenceReader(file.getPath());
        List paths = reader.getAllPaths();
        for (Path path : paths) {
            List chunkMetadataList = reader.getChunkMetadataList(path);
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                Chunk chunk = reader.readMemChunk(chunkMetadata);
                ChunkReaderByTimestamp chunkReader = new ChunkReaderByTimestamp(chunk);
                long totalPointCount = 0L;
                while (chunkReader.hasNextSatisfiedPage()) {
                    BatchData batchData = chunkReader.nextPageData();
                    for (int i = 0; i < batchData.length(); ++i) {
                        Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                    }
                    totalPointCount += (long)batchData.length();
                }
                Assert.assertEquals((long)totalPointCount, (long)chunkMetadata.getNumOfPoints());
            }
        }
        reader.close();
    }

    @Test
    public void testDeserializeMerge() throws IOException, IllegalPathException {
        HashMap measurementChunkMetadataMap = new HashMap();
        List sourceTsfileResources = this.seqResources.subList(0, 2);
        File file = new File(TestConstant.BASE_OUTPUT_PATH.concat("0-0-1-0.tsfile"));
        TsFileResource targetTsfileResource = new TsFileResource(file);
        RateLimiter compactionWriteRateLimiter = MergeManager.getINSTANCE().getMergeWriteRateLimiter();
        String device = "root.compactionTest.device0";
        RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(targetTsfileResource.getTsFile());
        writer.startChunkGroup(device);
        for (TsFileResource tsFileResource : sourceTsfileResources) {
            TsFileSequenceReader reader = new TsFileSequenceReader(tsFileResource.getTsFilePath());
            Map chunkMetadataMap = reader.readChunkMetadataInDevice(device);
            for (Map.Entry entry : chunkMetadataMap.entrySet()) {
                for (ChunkMetadata chunkMetadata : (List)entry.getValue()) {
                    String measurementUid = chunkMetadata.getMeasurementUid();
                    Map readerChunkMetadataMap = measurementChunkMetadataMap.containsKey(measurementUid) ? (Map)measurementChunkMetadataMap.get(measurementUid) : new LinkedHashMap();
                    List chunkMetadataList = readerChunkMetadataMap.containsKey(reader) ? (List)readerChunkMetadataMap.get(reader) : new ArrayList();
                    chunkMetadataList.add(chunkMetadata);
                    readerChunkMetadataMap.put(reader, chunkMetadataList);
                    measurementChunkMetadataMap.put(chunkMetadata.getMeasurementUid(), readerChunkMetadataMap);
                }
            }
            for (Map.Entry entry : measurementChunkMetadataMap.entrySet()) {
                CompactionUtils.writeByDeserializePageMerge((String)device, (RateLimiter)compactionWriteRateLimiter, entry, (TsFileResource)targetTsfileResource, (RestorableTsFileIOWriter)writer, new HashMap(), new ArrayList());
            }
            reader.close();
        }
        writer.endChunkGroup();
        targetTsfileResource.serialize();
        writer.endFile();
        targetTsfileResource.close();
        TsFileSequenceReader reader = new TsFileSequenceReader(file.getPath());
        List paths = reader.getAllPaths();
        for (Path path : paths) {
            List chunkMetadataList = reader.getChunkMetadataList(path);
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                Chunk chunk = reader.readMemChunk(chunkMetadata);
                ChunkReaderByTimestamp chunkReader = new ChunkReaderByTimestamp(chunk);
                long totalPointCount = 0L;
                while (chunkReader.hasNextSatisfiedPage()) {
                    BatchData batchData = chunkReader.nextPageData();
                    for (int i = 0; i < batchData.length(); ++i) {
                        Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                    }
                    totalPointCount += (long)batchData.length();
                }
                Assert.assertEquals((long)totalPointCount, (long)chunkMetadata.getNumOfPoints());
            }
        }
        reader.close();
    }
}

