/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.cost.statistic;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.cost.statistic.Measurement;
import org.apache.iotdb.db.cost.statistic.Operation;
import org.apache.iotdb.db.exception.StartupException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceStatTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformanceStatTest.class);

    @Before
    public void setUp() {
        IoTDBDescriptor.getInstance().getConfig().setEnablePerformanceStat(true);
    }

    @After
    public void tearDown() {
        IoTDBDescriptor.getInstance().getConfig().setEnablePerformanceStat(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        Measurement measurement = Measurement.INSTANCE;
        Operation operation = Operation.EXECUTE_JDBC_BATCH;
        measurement.addOperationLatency(operation, System.currentTimeMillis());
        measurement.addOperationLatency(operation, System.currentTimeMillis() - 8000000L);
        long batchOpCnt = measurement.getOperationCnt()[operation.ordinal()];
        Assert.assertEquals((long)0L, (long)batchOpCnt);
        try {
            measurement.start();
            measurement.startContinuousPrintStatistics();
            measurement.addOperationLatency(operation, System.currentTimeMillis());
            measurement.addOperationLatency(operation, System.currentTimeMillis() - 8000000L);
            Thread.currentThread();
            Thread.sleep(1000L);
            batchOpCnt = measurement.getOperationCnt()[operation.ordinal()];
            Assert.assertEquals((long)2L, (long)batchOpCnt);
            measurement.stopPrintStatistic();
            measurement.stopPrintStatistic();
            measurement.stopPrintStatistic();
            LOGGER.info("After stopPrintStatistic!");
            Thread.currentThread();
            Thread.sleep(1000L);
            measurement.clearStatisticalState();
            batchOpCnt = measurement.getOperationCnt()[operation.ordinal()];
            Assert.assertEquals((long)0L, (long)batchOpCnt);
            measurement.startContinuousPrintStatistics();
            LOGGER.info("ReStart!");
            Thread.currentThread();
            Thread.sleep(1000L);
            measurement.startContinuousPrintStatistics();
            LOGGER.info("ReStart2!");
            Thread.currentThread();
            Thread.sleep(1000L);
            measurement.stopPrintStatistic();
            LOGGER.info("After stopStatistic2!");
        }
        catch (Exception e) {
            LOGGER.error("find error in stat performance, the message is {}", (Object)e.getMessage());
        }
        finally {
            measurement.stop();
        }
    }

    @Test
    public void testSwitch() {
        Measurement measurement = Measurement.INSTANCE;
        try {
            measurement.start();
            measurement.startStatistics();
            measurement.startStatistics();
            measurement.startContinuousPrintStatistics();
            measurement.stopPrintStatistic();
            measurement.stopStatistic();
            measurement.clearStatisticalState();
            measurement.startPrintStatisticsOnce();
            measurement.startContinuousPrintStatistics();
            measurement.startStatistics();
        }
        catch (StartupException e) {
            e.printStackTrace();
        }
        finally {
            measurement.stop();
        }
    }
}

