/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.adapter;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.CompressionRatio;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompressionRatioTest {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private CompressionRatio compressionRatio = CompressionRatio.getInstance();
    private static final String directory = FilePathUtils.regularizePath((String)CONFIG.getSystemDir()) + "compression_ratio";

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        FileUtils.forceMkdir((File)new File(directory));
        this.compressionRatio.reset();
        this.compressionRatio.restore();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testCompressionRatio() throws IOException {
        double compressionRatioSum = 0.0;
        int calcuTimes = 0;
        if (new File(directory, String.format(Locale.ENGLISH, "Ratio-%f-%d", compressionRatioSum, calcuTimes)).exists()) {
            Assert.fail();
        }
        double compressionRatio = 10.0;
        int i = 0;
        while (i < 500) {
            this.compressionRatio.updateRatio(compressionRatio);
            if (new File(directory, String.format(Locale.ENGLISH, "Ratio-%f-%d", compressionRatioSum, calcuTimes)).exists()) {
                Assert.fail();
            }
            if (!new File(directory, String.format(Locale.ENGLISH, "Ratio-%f-%d", compressionRatioSum += compressionRatio, ++calcuTimes)).exists()) {
                Assert.fail();
            }
            Assert.assertEquals((long)0L, (long)Double.compare(compressionRatioSum / (double)calcuTimes, this.compressionRatio.getRatio()));
            i = (int)((double)i + compressionRatio);
        }
    }

    @Test
    public void testRestore() throws IOException {
        double compressionRatioSum = 0.0;
        int calcuTimes = 0;
        if (new File(directory, String.format(Locale.ENGLISH, "Ratio-%f-%d", compressionRatioSum, calcuTimes)).exists()) {
            Assert.fail();
        }
        int compressionRatio = 10;
        for (int i = 0; i < 100; i += compressionRatio) {
            this.compressionRatio.updateRatio((double)compressionRatio);
            if (new File(directory, String.format(Locale.ENGLISH, "Ratio-%f-%d", compressionRatioSum, calcuTimes)).exists()) {
                Assert.fail();
            }
            if (!new File(directory, String.format(Locale.ENGLISH, "Ratio-%f-%d", compressionRatioSum += (double)compressionRatio, ++calcuTimes)).exists()) {
                Assert.fail();
            }
            Assert.assertEquals((long)0L, (long)Double.compare(compressionRatioSum / (double)calcuTimes, this.compressionRatio.getRatio()));
        }
        this.compressionRatio.restore();
        Assert.assertEquals((long)10L, (long)this.compressionRatio.getCalcTimes());
        Assert.assertEquals((long)0L, (long)Double.compare(compressionRatioSum / (double)calcuTimes, this.compressionRatio.getRatio()));
    }
}

